/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.core.model.common;

import com.google.common.base.Strings;
import io.mateu.mdd.shared.AppConfigLocator;
import io.mateu.mdd.shared.IAppConfig;
import io.mateu.mdd.shared.interfaces.FileType;
import io.mateu.mdd.shared.interfaces.IResource;
import io.mateu.util.Helper;
import io.mateu.util.common.Utils;
import io.mateu.util.data.FileLocator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Version;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
public class Resource
implements IResource {
    private static final Logger log = LoggerFactory.getLogger(Resource.class);
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id = 0L;
    @Version
    int __version = 0;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private FileType type = FileType.BYTES;
    private String name;
    private String path;
    private byte[] bytes;
    private String url;

    public Resource() {
    }

    public Resource(String name, InputStream stream) throws FileNotFoundException {
        this.type = FileType.BYTES;
        this.bytes = Helper.leerByteArray((InputStream)stream);
        this.name = name;
    }

    public Resource(File file) throws FileNotFoundException {
        this.type = FileType.BYTES;
        this.bytes = Helper.leerByteArray((InputStream)new FileInputStream(file));
        this.name = file.getName();
    }

    public Resource(URL url) {
        this.type = FileType.URL;
        this.url = url.toString();
        this.name = url.getFile();
    }

    public byte[] getBytes() {
        if (FileType.BYTES.equals((Object)this.type)) {
            return this.bytes;
        }
        byte[] r = null;
        if (!Strings.isNullOrEmpty((String)this.url)) {
            try {
                r = Utils.readBytes((URL)new URL(this.url));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return r;
    }

    public FileLocator toFileLocator() throws Exception {
        if (FileType.BYTES.equals((Object)this.type)) {
            if (this.bytes != null) {
                URL url;
                File temp;
                block11: {
                    String extension = ".tmp";
                    String fileName = this.getName();
                    if (this.getName() == null || "".equals(this.getName().trim())) {
                        fileName = "" + this.getId();
                    }
                    if (fileName.lastIndexOf(".") < fileName.length() - 1) {
                        extension = fileName.substring(fileName.lastIndexOf("."));
                        fileName = fileName.substring(0, fileName.lastIndexOf(".")).replaceAll(" ", "_");
                    }
                    temp = System.getProperty("tmpdir") == null ? File.createTempFile(fileName, extension) : new File(new File(System.getProperty("tmpdir")), fileName + extension);
                    log.debug("java.io.tmpdir=" + System.getProperty("java.io.tmpdir"));
                    log.debug("Temp file : " + temp.getAbsolutePath());
                    if (System.getProperty("tmpdir") == null || !temp.exists()) {
                        log.debug("writing temp file to " + temp.getAbsolutePath());
                        Utils.write((File)temp, (byte[])this.bytes);
                    } else {
                        log.debug("temp file already exists");
                    }
                    String baseUrl = System.getProperty("tmpurl");
                    url = null;
                    if (baseUrl == null) {
                        try {
                            IAppConfig app = ((AppConfigLocator)Helper.getImpl(AppConfigLocator.class)).get();
                            if (app != null && !Strings.isNullOrEmpty((String)app.getBaseUrl())) {
                                url = new URL(app.getBaseUrl() + "/tmp/" + temp.getName());
                                break block11;
                            }
                            url = temp.toURI().toURL();
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                            url = temp.toURI().toURL();
                        }
                    } else {
                        url = new URL(baseUrl + "/" + temp.getName());
                    }
                }
                return new FileLocator(this.id, this.name, url.toString(), temp.getAbsolutePath().replaceAll("\\\\", "/"));
            }
            return new FileLocator(this.id, null, null);
        }
        return new FileLocator(this.id, this.name, this.url);
    }

    public void set(String fileName, String tmpPath) throws Exception {
        this.setName(fileName);
        this.setBytes(Utils.readBytes((String)tmpPath));
        this.setUrl(null);
        this.setType(FileType.BYTES);
    }

    public void set(String url) throws Exception {
        this.setName(!Strings.isNullOrEmpty((String)url) ? new URL(url).getFile().substring(new URL(url).getFile().lastIndexOf("/") + 1) : null);
        this.setBytes(null);
        this.setUrl(url);
        this.setType(FileType.URL);
    }

    public void dowload(URL url) throws Exception {
        this.setName(url.getFile());
        this.setBytes(Utils.readBytes((URL)url));
        this.setUrl(null);
        this.setType(FileType.BYTES);
    }

    public String toString() {
        String s = "Empty";
        if (this.getName() != null) {
            s = this.getName();
        }
        return s;
    }

    protected int get__version() {
        return this.__version;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public FileType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getUrl() {
        return this.url;
    }

    public void setType(FileType type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void set__version(int __version) {
        this.__version = __version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.id == 0L) {
            return false;
        }
        return Long.compare(this.id, other.id) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Resource;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

