/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.annotationProcessing;

import com.google.auto.service.AutoService;
import freemarker.template.TemplateException;
import io.mateu.mdd.annotationProcessing.Formatter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"io.mateu.mdd.core.annotations.MateuUI"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@AutoService(value={Processor.class})
public class MateuUIAnnotationProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(typeElement);
            for (Element element : annotatedElements) {
                String className = ((TypeElement)element).getQualifiedName().toString();
                String simpleClassName = element.getSimpleName().toString();
                System.out.println("MateuUIAnnotationProcessor running on " + simpleClassName);
                String generatedFullClassName = className + "Controller";
                String pkgName = generatedFullClassName.substring(0, generatedFullClassName.lastIndexOf("."));
                String generatedClassName = generatedFullClassName.substring(generatedFullClassName.lastIndexOf(".") + 1);
                try {
                    this.createController(generatedFullClassName, pkgName, className, simpleClassName, element, generatedClassName);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return true;
    }

    private void createController(String generatedFullClassName, String pkgName, String className, String simpleClassName, Element e, String generatedClassName) throws IOException {
        JavaFileObject builderFile = this.processingEnv.getFiler().createSourceFile(generatedFullClassName, new Element[0]);
        try (PrintWriter out = new PrintWriter(builderFile.openWriter());){
            Formatter formatter = new Formatter("controller.ftl", Map.of("pkgName", pkgName, "className", className, "simpleClassName", simpleClassName, "generatedClassName", generatedClassName, "generatedFullClassName", generatedFullClassName));
            try {
                out.println(formatter.apply());
            }
            catch (TemplateException ex) {
                ex.printStackTrace();
            }
        }
    }
}

