/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.annotationProcessing;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementScanner7;

public class ImportScanner
extends ElementScanner7<Void, Void> {
    private Set<String> types = new HashSet<String>();

    public Set<String> getImportedTypes() {
        return this.types;
    }

    @Override
    public Void visitType(TypeElement e, Void p) {
        for (TypeMirror typeMirror : e.getInterfaces()) {
            this.types.add(typeMirror.toString());
        }
        this.types.add(e.getSuperclass().toString());
        return (Void)super.visitType(e, p);
    }

    @Override
    public Void visitExecutable(ExecutableElement e, Void p) {
        if (e.getReturnType().getKind() == TypeKind.DECLARED) {
            this.types.add(e.getReturnType().toString());
        }
        this.visitAnnotatios(e, p);
        return (Void)super.visitExecutable(e, p);
    }

    @Override
    public Void visitTypeParameter(TypeParameterElement e, Void p) {
        if (e.asType().getKind() == TypeKind.DECLARED) {
            this.types.add(e.asType().toString());
            this.visitAnnotatios(e, p);
        }
        return (Void)super.visitTypeParameter(e, p);
    }

    @Override
    public Void visitVariable(VariableElement e, Void p) {
        if (e.asType().getKind() == TypeKind.DECLARED) {
            this.types.add(e.asType().toString());
            this.visitAnnotatios(e, p);
        }
        return (Void)super.visitVariable(e, p);
    }

    @Override
    public Void visitUnknown(Element e, Void aVoid) {
        return (Void)super.visitUnknown(e, aVoid);
    }

    private void visitAnnotatios(Element e, Void p) {
        e.getAnnotationMirrors().forEach(m -> {
            this.types.add(m.getAnnotationType().toString());
            for (ExecutableElement executableElement : m.getElementValues().keySet()) {
                AnnotationValue v;
                this.visit(executableElement, p);
                AnnotationValue value = m.getElementValues().get(executableElement);
                if (value == null || !value.getClass().getSimpleName().equals("Array") || !((v = value).getValue() instanceof Collection)) continue;
                Collection c = (Collection)v.getValue();
                for (Object o : c) {
                    this.types.add(o.toString().substring(0, o.toString().lastIndexOf(".")));
                }
            }
        });
    }
}

