/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.annotationProcessing;

import com.google.auto.service.AutoService;
import com.google.common.base.Strings;
import io.mateu.mdd.core.annotations.MateuUI;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"io.mateu.mdd.core.annotations.MateuUI"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@AutoService(value={Processor.class})
public class MateuUIAnnotationProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(typeElement);
            for (Element element : annotatedElements) {
                String className = ((TypeElement)element).getQualifiedName().toString();
                String simpleClassName = ((TypeElement)element).getSimpleName().toString();
                System.out.println("MateuUIAnnotationProcessor running on " + simpleClassName);
                String generatedFullClassName = className + "Servlet";
                String pkgName = generatedFullClassName.substring(0, generatedFullClassName.lastIndexOf("."));
                String generatedClassName = generatedFullClassName.substring(generatedFullClassName.lastIndexOf(".") + 1);
                JavaFileObject builderFile = null;
                try {
                    builderFile = this.processingEnv.getFiler().createSourceFile(pkgName + "." + simpleClassName + "UI", new Element[0]);
                    try (PrintWriter out = new PrintWriter(builderFile.openWriter());){
                        out.println("package " + pkgName + ";");
                        out.println("import " + className + ";");
                        out.println("import io.mateu.mdd.vaadin.MateuUI;");
                        out.println("import com.vaadin.annotations.*;");
                        out.println("import com.vaadin.annotations.JavaScript;");
                        out.println("import com.vaadin.navigator.PushStateNavigation;");
                        out.println("import lombok.extern.slf4j.Slf4j;");
                        out.println("");
                        out.println();
                        out.println("@Theme(\"" + element.getAnnotation(MateuUI.class).theme() + "\")\n@JavaScript({\"https://code.jquery.com/jquery-3.4.1.min.js\"})\n@StyleSheet(\"https://use.fontawesome.com/releases/v5.14.0/js/all.js\")\n@JavaScript({\"../../VAADIN/js/include.js\"})\n@Viewport(\"width=device-width, initial-scale=1\")\n@PushStateNavigation // para urls sin #!\n//@Push\n@Slf4j\n");
                        for (String s : element.getAnnotation(MateuUI.class).stylesheets()) {
                            if (!s.contains(":")) {
                                s = "../../VAADIN/" + s;
                            }
                            out.println("@StyleSheet(\"" + s + "\")");
                        }
                        for (String s : element.getAnnotation(MateuUI.class).scripts()) {
                            if (!s.contains(":")) {
                                s = "../../VAADIN/" + s;
                            }
                            out.println("@JavaScript(\"" + s + "\")");
                        }
                        out.println("public class " + simpleClassName + "UI extends MateuUI {");
                        out.println("");
                        out.println("}");
                    }
                    builderFile = this.processingEnv.getFiler().createSourceFile(generatedFullClassName, new Element[0]);
                    out = new PrintWriter(builderFile.openWriter());
                    try {
                        out.println("package " + pkgName + ";");
                        out.println("import " + className + ";");
                        out.println("import io.mateu.mdd.core.annotations.MateuUIServlet;");
                        out.println("import " + pkgName + "." + simpleClassName + "UI;");
                        out.println("import com.vaadin.annotations.VaadinServletConfiguration;");
                        out.println("import com.vaadin.server.DeploymentConfiguration;");
                        out.println("import com.vaadin.server.*;");
                        out.println("");
                        out.println("import javax.servlet.ServletConfig;");
                        out.println("import javax.servlet.ServletException;");
                        out.println("import javax.servlet.annotation.WebServlet;");
                        out.println("import java.util.Properties;");
                        out.println("import javax.servlet.annotation.WebInitParam;");
                        out.println();
                        out.println("@WebServlet(urlPatterns = {\"" + element.getAnnotation(MateuUI.class).path() + "\", \"" + ("/".equals(element.getAnnotation(MateuUI.class).path()) ? "" : element.getAnnotation(MateuUI.class).path()) + "/*\"}, name = \"" + className.replaceAll("\\.", "_") + "UIServlet\", asyncSupported = true, initParams = {\n        @WebInitParam(name = \"org.atmosphere.websocket.suppressJSR356\", value = \"true\")})");
                        out.println("@VaadinServletConfiguration(ui = " + simpleClassName + "UI.class, productionMode = false)");
                        out.println("@MateuUIServlet(path=\"" + element.getAnnotation(MateuUI.class).path() + "\")");
                        out.println("public class " + generatedClassName + " extends VaadinServlet implements SessionInitListener {");
                        out.println("");
                        out.println("    @Override");
                        out.println("    protected DeploymentConfiguration createDeploymentConfiguration(Properties initParameters) {");
                        out.println("        if (\"true\".equals(System.getProperty(\"productionMode\"))) initParameters.setProperty(\"productionMode\", Boolean.toString(true));");
                        out.println("        return super.createDeploymentConfiguration(initParameters);");
                        out.println("    }");
                        out.println("");
                        out.println("    @Override\n    public void init(ServletConfig servletConfig) throws ServletException {\n        servletConfig.getServletContext().setAttribute(\"" + ("".equals(element.getAnnotation(MateuUI.class).path()) ? "/" : element.getAnnotation(MateuUI.class).path()) + "_app\", " + className.substring(className.lastIndexOf(".") + 1) + ".class);\n        super.init(servletConfig);\n    }\n");
                        out.println("@Override\n       protected void servletInitialized() throws ServletException {\n           super.servletInitialized();\n           getService().addSessionInitListener(this);\n       }");
                        out.println("@Override\n    public void sessionInit(SessionInitEvent sessionInitEvent) throws ServiceException {\n");
                        if (!Strings.isNullOrEmpty((String)element.getAnnotation(MateuUI.class).favIcon())) {
                            String fi = element.getAnnotation(MateuUI.class).favIcon();
                            if (!fi.contains(":")) {
                                fi = "./VAADIN/" + fi;
                            }
                            out.println("sessionInitEvent.getSession().addBootstrapListener(new BootstrapListener() {\n\n        @Override\n        public void modifyBootstrapPage(BootstrapPageResponse response) {\n            response.getDocument().head()\n                    .getElementsByAttributeValue(\"rel\", \"shortcut icon\")\n                    .attr(\"href\", \"" + fi + "\");\n            response.getDocument().head()\n                    .getElementsByAttributeValue(\"rel\", \"icon\")\n                    .attr(\"href\", \"" + fi + "\");\n        }\n\n        @Override\n        public void modifyBootstrapFragment(BootstrapFragmentResponse response) {\n        }\n\n    });");
                        }
                        out.println("    }");
                        out.println("");
                        out.println("}");
                    }
                    finally {
                        out.close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return true;
    }
}

