/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.json;

import io.mateu.mdd.shared.data.ExternalReference;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.persistence.EntitySerializer;
import jakarta.persistence.CascadeType;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.springframework.stereotype.Service;

@Service
public class MateuEntitySerializer
implements EntitySerializer {
    final ReflectionHelper reflectionHelper;

    public Map<String, Object> toMap(Object entity) throws Exception {
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (FieldInterfaced field : this.reflectionHelper.getAllTransferrableFields(entity.getClass())) {
            this.addToData(data, field, entity);
        }
        return data;
    }

    private void addToData(Map<String, Object> data, FieldInterfaced field, Object entity) throws Exception {
        if (field.isAnnotationPresent(OneToMany.class) || field.isAnnotationPresent(ManyToMany.class)) {
            this.addXToMany(data, field, entity);
            return;
        }
        if (field.isAnnotationPresent(ManyToOne.class)) {
            this.addManyToOne(data, field, entity);
            return;
        }
        data.put(field.getId(), this.reflectionHelper.getValue(field, entity));
    }

    private void addManyToOne(Map<String, Object> data, FieldInterfaced field, Object entity) throws Exception {
        Object value = this.reflectionHelper.getValue(field, entity);
        if (value == null) {
            return;
        }
        data.put(field.getId(), new ExternalReference(this.reflectionHelper.getId(value), value.toString()));
    }

    private void addXToMany(Map<String, Object> data, FieldInterfaced field, Object entity) throws Exception {
        Collection list = (Collection)this.reflectionHelper.getValue(field, entity);
        if (list == null) {
            return;
        }
        if (this.getCascade(field).filter(c -> c.equals((Object)CascadeType.ALL)).count() > 0L) {
            ArrayList items = new ArrayList();
            list.forEach(value -> {
                try {
                    items.add(this.toMap(value));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            data.put(field.getId(), items);
        } else {
            ArrayList refs = new ArrayList();
            list.forEach(value -> refs.add(new ExternalReference(this.reflectionHelper.getId(value), value.toString())));
            data.put(field.getId(), refs);
        }
    }

    private Stream<CascadeType> getCascade(FieldInterfaced field) {
        if (field.isAnnotationPresent(OneToMany.class)) {
            return Arrays.stream(((OneToMany)field.getAnnotation(OneToMany.class)).cascade());
        }
        if (field.isAnnotationPresent(ManyToMany.class)) {
            return Arrays.stream(((ManyToMany)field.getAnnotation(ManyToMany.class)).cascade());
        }
        return null;
    }

    public MateuEntitySerializer(ReflectionHelper reflectionHelper) {
        this.reflectionHelper = reflectionHelper;
    }
}

