/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.ui.cruds.queries.sums;

import com.google.common.base.Strings;
import io.mateu.mdd.shared.annotations.Sum;
import io.mateu.mdd.shared.data.SumData;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.ui.cruds.queries.QueryHelper;
import io.mateu.mdd.ui.cruds.queries.sums.SumsQuery;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.Helper;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SumsQueryHandler {
    private static final Logger log = LoggerFactory.getLogger(SumsQueryHandler.class);
    @PersistenceContext
    private EntityManager em;
    @Autowired
    ReflectionHelper reflectionHelper;

    @Transactional
    public List<SumData> run(SumsQuery query) {
        ArrayList<SumData> sums = new ArrayList<SumData>();
        try {
            Query q = new QueryHelper(this.reflectionHelper).buildJpaQuery(query, this.em, query.getSelectColumnsForCount(), query.getFilters(), null, null, 0, 1000, false);
            log.debug(q.toString());
            Object r = q.getSingleResult();
            if (r instanceof Object[]) {
                Object[] v = (Object[])r;
                DecimalFormat nf = new DecimalFormat("#,###,###,###,###,###,###.00");
                int pos = 1;
                for (FieldInterfaced f : query.getSumFields()) {
                    Object x;
                    Object caption = Helper.capitalize((String)f.getName());
                    if (!((String)caption).startsWith("Total")) {
                        caption = "Total " + (String)caption;
                    }
                    if (!Strings.isNullOrEmpty((String)((Sum)f.getAnnotation(Sum.class)).caption())) {
                        caption = ((Sum)f.getAnnotation(Sum.class)).caption();
                    }
                    if ((x = v[pos++]) != null && x instanceof Double) {
                        x = (double)Math.round(100.0 * (Double)x) / 100.0;
                        x = nf.format(x);
                    }
                    sums.add(new SumData((String)caption, (String)(x != null ? "" + x : "---"), ""));
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return sums;
    }
}

