/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.ui.cruds;

import com.google.common.base.Strings;
import io.mateu.mdd.core.app.MDDOpenCRUDAction;
import io.mateu.mdd.core.interfaces.JpaRpcCrudFactory;
import io.mateu.mdd.core.views.ExtraFilters;
import io.mateu.mdd.shared.interfaces.JpaCrud;
import io.mateu.mdd.shared.interfaces.Listing;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.ui.cruds.JpaRpcCrudView;
import io.mateu.reflection.ReflectionHelper;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToMany;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service
@Primary
public class JpaRpcCrudViewFactory
implements JpaRpcCrudFactory {
    final ReflectionHelper reflectionHelper;

    public Listing create(Object parentEntity, FieldInterfaced field) throws Exception {
        MDDOpenCRUDAction action = new MDDOpenCRUDAction(field.getGenericClass());
        if (field.isAnnotationPresent(OneToMany.class) && !Strings.isNullOrEmpty((String)((OneToMany)field.getAnnotation(OneToMany.class)).mappedBy())) {
            action.setExtraFilters(new ExtraFilters("x." + ((OneToMany)field.getAnnotation(OneToMany.class)).mappedBy() + " = :p", new Object[]{"p", parentEntity}));
        } else if (field.isAnnotationPresent(ManyToMany.class) && !Strings.isNullOrEmpty((String)((ManyToMany)field.getAnnotation(ManyToMany.class)).mappedBy())) {
            action.setExtraFilters(new ExtraFilters("x." + ((ManyToMany)field.getAnnotation(ManyToMany.class)).mappedBy() + " = :p", new Object[]{"p", parentEntity}));
        } else {
            action.setExtraFilters(new ExtraFilters("x in :p", new Object[]{"p", this.reflectionHelper.getValue(field, parentEntity)}));
        }
        JpaRpcCrudView jpaRpcCrudView = (JpaRpcCrudView)this.reflectionHelper.newInstance(JpaRpcCrudView.class);
        jpaRpcCrudView.setAction(action);
        return jpaRpcCrudView;
    }

    public Listing create(JpaCrud v) throws Exception {
        MDDOpenCRUDAction a = new MDDOpenCRUDAction(v.getEntityClass());
        if (v != null && v.getColumnFields() != null) {
            a.setColumns(String.join((CharSequence)",", v.getColumnFields()));
        }
        if (v != null && v.getVisibleFields() != null) {
            a.setFields(String.join((CharSequence)",", v.getVisibleFields()));
        }
        if (v != null && v.getSearchFilterFields() != null) {
            a.setFilters(String.join((CharSequence)",", v.getSearchFilterFields()));
        }
        if (v != null && v.getReadOnlyFields() != null) {
            a.setReadOnlyFields(String.join((CharSequence)",", v.getReadOnlyFields()));
        }
        if (v != null) {
            a.setCanAdd(v.canAdd());
        }
        if (v != null) {
            a.setCanDelete(v.canDelete());
        }
        if (v != null) {
            a.setReadOnly(v.isReadOnly());
        }
        if (v != null && !Strings.isNullOrEmpty((String)v.getExtraWhereFilter())) {
            a.setQueryFilters(v.getExtraWhereFilter());
        }
        JpaRpcCrudView jpaRpcCrudView = (JpaRpcCrudView)this.reflectionHelper.newInstance(JpaRpcCrudView.class);
        jpaRpcCrudView.setAction(a);
        return jpaRpcCrudView;
    }

    public JpaRpcCrudViewFactory(ReflectionHelper reflectionHelper) {
        this.reflectionHelper = reflectionHelper;
    }
}

