/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.ui.cruds;

import io.mateu.mdd.shared.annotations.Caption;
import io.mateu.mdd.shared.annotations.Ignored;
import io.mateu.mdd.shared.annotations.MainAction;
import io.mateu.mdd.shared.annotations.ValuesProviderMethod;
import io.mateu.mdd.shared.data.Value;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.Helper;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Caption(value="What do you want to create?")
@Service
public class ChooseEntityClassForm {
    @Ignored
    private Map<String, String> subclasses;
    @Ignored
    @Autowired
    ReflectionHelper reflectionHelper;
    @NotNull
    @ValuesProviderMethod(value="getChoices")
    private String type;

    public ChooseEntityClassForm(Set<Class> subclasses) {
        this.subclasses = subclasses.stream().collect(Collectors.toMap(c -> c.getName(), c -> Helper.capitalize((String)c.getSimpleName())));
    }

    public List<Value> getChoices() {
        return this.subclasses.entrySet().stream().map(e -> new Value((String)e.getValue(), e.getKey())).collect(Collectors.toList());
    }

    @MainAction
    public Object create() throws Exception {
        return this.reflectionHelper.newInstance(Class.forName(this.type));
    }

    public Map<String, String> getSubclasses() {
        return this.subclasses;
    }

    public ReflectionHelper getReflectionHelper() {
        return this.reflectionHelper;
    }

    public String getType() {
        return this.type;
    }

    public void setSubclasses(Map<String, String> subclasses) {
        this.subclasses = subclasses;
    }

    public void setReflectionHelper(ReflectionHelper reflectionHelper) {
        this.reflectionHelper = reflectionHelper;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ChooseEntityClassForm() {
    }
}

