/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.json;

import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.Serializer;
import io.mateu.util.persistence.EntityDeserializer;
import jakarta.persistence.EntityManager;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class MateuEntityDeserializer
implements EntityDeserializer {
    final Serializer serializer;
    final ReflectionHelper reflectionHelper;

    public <T> T fromJson(EntityManager em, String json, Class<T> c) throws Exception {
        Map map = this.serializer.fromJson(json);
        Object instance = this.reflectionHelper.newInstance(c);
        this.reflectionHelper.getAllEditableFields(c).stream().filter(f -> !f.isAnnotationPresent(OneToOne.class) && !f.isAnnotationPresent(ManyToOne.class) && !f.isAnnotationPresent(OneToMany.class) && !f.isAnnotationPresent(ManyToMany.class)).forEach(f -> {
            try {
                this.reflectionHelper.setValue(f, instance, this.serializer.fromJson(this.serializer.toJson(map.get(f.getId())), f.getType()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.reflectionHelper.getAllEditableFields(c).stream().filter(f -> f.isAnnotationPresent(OneToOne.class) || f.isAnnotationPresent(ManyToOne.class)).forEach(f -> {
            try {
                this.reflectionHelper.setValue(f, instance, em.find(f.getType(), ((Map)map.get(f.getId())).get("value")));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.reflectionHelper.getAllEditableFields(c).stream().filter(f -> f.isAnnotationPresent(OneToMany.class) || f.isAnnotationPresent(ManyToMany.class)).forEach(f -> {
            try {
                this.reflectionHelper.setValue(f, instance, this.buildList((FieldInterfaced)f, em, map));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return (T)instance;
    }

    private Object buildList(FieldInterfaced f, EntityManager em, Map<String, Object> map) {
        List data = (List)map.get(f.getId());
        ArrayList value = new ArrayList();
        if (data != null) {
            value.addAll(data.stream().map(m -> em.find(f.getGenericClass(), m.get("value"))).collect(Collectors.toList()));
        }
        return value;
    }

    public MateuEntityDeserializer(Serializer serializer, ReflectionHelper reflectionHelper) {
        this.serializer = serializer;
        this.reflectionHelper = reflectionHelper;
    }
}

