/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.ui.cruds;

import com.google.common.base.Strings;
import io.mateu.mdd.core.app.MDDOpenCRUDAction;
import io.mateu.mdd.core.interfaces.JpaRpcCrudFactory;
import io.mateu.mdd.core.views.ExtraFilters;
import io.mateu.mdd.shared.interfaces.Listing;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.ui.cruds.JpaRpcCrudView;
import io.mateu.reflection.ReflectionHelper;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToMany;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service
@Primary
public class JpaRpcCrudViewFactory
implements JpaRpcCrudFactory {
    public Listing create(Object parentEntity, FieldInterfaced field) throws Exception {
        MDDOpenCRUDAction action = new MDDOpenCRUDAction(field.getGenericClass());
        if (field.isAnnotationPresent(OneToMany.class) && !Strings.isNullOrEmpty((String)((OneToMany)field.getAnnotation(OneToMany.class)).mappedBy())) {
            action.setExtraFilters(new ExtraFilters("x." + ((OneToMany)field.getAnnotation(OneToMany.class)).mappedBy() + " = :p", new Object[]{"p", parentEntity}));
        } else if (field.isAnnotationPresent(ManyToMany.class) && !Strings.isNullOrEmpty((String)((ManyToMany)field.getAnnotation(ManyToMany.class)).mappedBy())) {
            action.setExtraFilters(new ExtraFilters("x." + ((ManyToMany)field.getAnnotation(ManyToMany.class)).mappedBy() + " = :p", new Object[]{"p", parentEntity}));
        } else {
            action.setExtraFilters(new ExtraFilters("x in :p", new Object[]{"p", ReflectionHelper.getValue((FieldInterfaced)field, (Object)parentEntity)}));
        }
        return new JpaRpcCrudView(action);
    }
}

