/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.embeddedfront.application;

import io.mateu.core.domain.util.Helper;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mateu"})
public class MateuController {
    private static final Logger log = LoggerFactory.getLogger(MateuController.class);

    @GetMapping(value={"/assets/**"})
    public ResponseEntity<String> getAssets(ServerHttpRequest request) {
        return this.getFromClasspath(request.getURI().toString(), "assets", "/npm/mateu/assets/");
    }

    private ResponseEntity<String> getFromClasspath(String uri, String key, String pkg) {
        String[] tokens = uri.split("/" + key);
        String path = tokens.length > 1 ? tokens[1] : "";
        String suffix = path.contains(".") ? path.substring(path.lastIndexOf(46)).replaceAll("\\.", "") : "";
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("Content-Type", Map.of("js", "application/javascript", "css", "text/css").getOrDefault(suffix, "text/plain".toString()));
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String html = Helper.leerFichero(this.getClass(), (String)(pkg + path));
        return new ResponseEntity((Object)html, (MultiValueMap)httpHeaders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/dist/**"})
    public ResponseEntity<String> getDist(ServerHttpRequest request) {
        return this.getFromClasspath(request.getURI().toString(), "dist", "/npm/mateu/dist/");
    }
}

