/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.i18n;

import io.mateu.i18n.Translator;
import java.util.Locale;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ResourceBundleTranslator
implements Translator {
    private static final Logger log = LoggerFactory.getLogger(ResourceBundleTranslator.class);
    ResourceBundle es;
    ResourceBundle en;
    ResourceBundle it;
    ResourceBundle de;
    ResourceBundle fr;
    ResourceBundle ru;
    ResourceBundle ar;
    ResourceBundle cz;

    public ResourceBundleTranslator() {
        try {
            this.es = ResourceBundle.getBundle("messages", new Locale("es"));
            this.en = ResourceBundle.getBundle("messages", new Locale("en"));
            this.it = ResourceBundle.getBundle("messages", new Locale("it"));
            this.de = ResourceBundle.getBundle("messages", new Locale("de"));
            this.fr = ResourceBundle.getBundle("messages", new Locale("fr"));
            this.ru = ResourceBundle.getBundle("messages", new Locale("ru"));
            this.ar = ResourceBundle.getBundle("messages", new Locale("ar"));
            this.cz = ResourceBundle.getBundle("messages", new Locale("cz"));
        }
        catch (Exception e) {
            log.warn("Translations not available: " + e.getMessage());
        }
    }

    @Override
    public String translate(String text) {
        String l = null;
        String traduccion = text;
        if (l == null) {
            l = Locale.getDefault().getLanguage();
        }
        ResourceBundle traducciones = null;
        if ("es".equals(l)) {
            traducciones = this.es;
        }
        if ("en".equals(l)) {
            traducciones = this.en;
        }
        if ("it".equals(l)) {
            traducciones = this.it;
        }
        if ("de".equals(l)) {
            traducciones = this.de;
        }
        if ("fr".equals(l)) {
            traducciones = this.fr;
        }
        if ("ru".equals(l)) {
            traducciones = this.ru;
        }
        if ("ar".equals(l)) {
            traducciones = this.ar;
        }
        if ("cz".equals(l)) {
            traducciones = this.cz;
        }
        if (traducciones != null && traducciones.containsKey(text)) {
            traduccion = traducciones.getString(text);
        }
        return traduccion != null ? traduccion : text;
    }
}

