/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.queries.getListCount;

import com.google.common.base.Strings;
import io.mateu.core.domain.apiClients.MateuRemoteClient;
import io.mateu.core.domain.model.store.JourneyContainer;
import io.mateu.core.domain.model.store.JourneyStoreService;
import io.mateu.core.domain.queries.FiltersDeserializer;
import io.mateu.core.domain.queries.getListCount.GetListCountQuery;
import io.mateu.mdd.shared.interfaces.Listing;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class GetListCountQueryHandler {
    private static final Logger log = LoggerFactory.getLogger(GetListCountQueryHandler.class);
    @Autowired
    JourneyStoreService store;
    @Autowired
    MateuRemoteClient mateuRemoteClient;
    @Autowired
    ReflectionHelper reflectionHelper;
    @Autowired
    Serializer serializer;

    public Mono<Long> run(GetListCountQuery query) throws Throwable {
        JourneyContainer journeyContainer = this.store.findJourneyById(query.getJourneyId()).orElse(null);
        if (journeyContainer == null) {
            throw new Exception("No journey with id " + query.getJourneyId());
        }
        if (!Strings.isNullOrEmpty((String)journeyContainer.getRemoteJourneyTypeId())) {
            return this.mateuRemoteClient.getListCount(journeyContainer.getRemoteBaseUrl(), journeyContainer.getRemoteJourneyTypeId(), journeyContainer.getJourneyId(), query.getStepId(), query.getListId(), query.getFilters(), query.getServerHttpRequest());
        }
        Object filtersDeserialized = new FiltersDeserializer(query.getJourneyId(), query.getStepId(), query.getListId(), query.getFilters(), query.getServerHttpRequest(), this.reflectionHelper, this.serializer).deserialize(this.store);
        Listing rpcView = this.store.getRpcViewInstance(query.getJourneyId(), query.getStepId(), query.getListId(), query.getServerHttpRequest());
        if (rpcView == null) {
            return Mono.just((Object)0L);
        }
        return rpcView.fetchCount(filtersDeserialized);
    }
}

