/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.reflection;

import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.reflection.ReflectionHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class FieldInterfacedFromPath
implements FieldInterfaced {
    private final Field f;
    private final FieldInterfaced ff;
    private final Class sourceType;
    private final String path;
    private List<Annotation> extraAnnotations = new ArrayList<Annotation>();
    private final ReflectionHelper reflectionHelper;

    public FieldInterfacedFromPath(Class type, String path, Annotation a, ReflectionHelper reflectionHelper) {
        this(type, path, reflectionHelper);
        this.extraAnnotations.add(a);
    }

    @Override
    public Field getField() {
        return this.f;
    }

    @Override
    public <T extends Annotation> T[] getDeclaredAnnotationsByType(Class<T> annotationClass) {
        return this.ff != null ? this.ff.getDeclaredAnnotationsByType(annotationClass) : this.f.getDeclaredAnnotationsByType(annotationClass);
    }

    public FieldInterfacedFromPath(Class sourceType, String path, ReflectionHelper reflectionHelper) {
        this.sourceType = sourceType;
        this.path = path;
        this.ff = reflectionHelper.getFieldByName(sourceType, path);
        this.f = this.ff.getField();
        this.reflectionHelper = reflectionHelper;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        if (this.extraAnnotations.size() > 0) {
            for (Annotation a : this.extraAnnotations) {
                if (!a.getClass().equals(annotationClass)) continue;
                return true;
            }
        }
        return this.ff != null ? this.ff.isAnnotationPresent(annotationClass) : this.f.isAnnotationPresent(annotationClass);
    }

    @Override
    public Class<?> getType() {
        return this.ff != null ? this.ff.getType() : this.f.getType();
    }

    @Override
    public AnnotatedType getAnnotatedType() {
        return this.ff != null ? this.ff.getAnnotatedType() : this.f.getAnnotatedType();
    }

    @Override
    public Class<?> getGenericClass() {
        if (this.ff != null) {
            return this.ff.getGenericClass();
        }
        if (this.f.getGenericType() != null && this.f.getGenericType() instanceof ParameterizedType) {
            ParameterizedType genericType = (ParameterizedType)this.f.getGenericType();
            if (genericType != null && genericType.getActualTypeArguments().length > 0) {
                Type ata0 = genericType.getActualTypeArguments()[0];
                if (ata0 instanceof Class) {
                    Class genericClass = (Class)ata0;
                    return genericClass;
                }
                return null;
            }
            return null;
        }
        if (this.f.getGenericType() != null) {
            return (Class)this.f.getGenericType();
        }
        return null;
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.ff != null ? this.ff.getDeclaringClass() : this.f.getDeclaringClass();
    }

    @Override
    public Type getGenericType() {
        return this.ff != null ? this.ff.getGenericType() : this.f.getGenericType();
    }

    @Override
    public String getName() {
        if (!this.path.contains(".")) {
            return this.path;
        }
        String n = this.path.substring(this.path.indexOf(".") + 1);
        if ("name".equalsIgnoreCase(n) || "nombre".equalsIgnoreCase(n) || "id".equalsIgnoreCase(n)) {
            n = this.path.substring(0, this.path.indexOf("."));
        }
        return n;
    }

    @Override
    public String getId() {
        return this.path;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        if (this.extraAnnotations.size() > 0) {
            for (Annotation a : this.extraAnnotations) {
                if (!a.getClass().equals(annotationClass)) continue;
                return (T)a;
            }
        }
        return this.ff != null ? this.ff.getAnnotation(annotationClass) : this.f.getAnnotation(annotationClass);
    }

    @Override
    public Object getValue(Object o) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return this.reflectionHelper.getValue(this, o);
    }

    @Override
    public void setValue(Object o, Object v) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        this.reflectionHelper.setValue(this, o, v);
    }

    @Override
    public int getModifiers() {
        return this.f.getModifiers();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.ff != null ? this.ff.getDeclaredAnnotations() : this.f.getDeclaredAnnotations();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return (this.getField().getDeclaringClass().getName() + "/" + this.getField().getName()).hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.hashCode() == obj.hashCode();
    }
}

