/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.metadataBuilders;

import io.mateu.core.domain.model.editors.MethodParametersEditor;
import io.mateu.core.domain.model.metadataBuilders.FieldMetadataBuilder;
import io.mateu.mdd.shared.annotations.FieldGroup;
import io.mateu.mdd.shared.annotations.SameLine;
import io.mateu.mdd.shared.annotations.Section;
import io.mateu.mdd.shared.annotations.UseCrud;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.remote.dtos.Action;
import io.mateu.remote.dtos.ActionType;
import io.mateu.remote.dtos.Field;
import io.mateu.remote.dtos.FieldGroupLine;
import io.mateu.remote.dtos.Form;
import io.mateu.remote.dtos.SectionType;
import io.mateu.util.Helper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;

@Service
public class MethodParametersEditorMetadataBuilder {
    final FieldMetadataBuilder fieldMetadataBuilder;
    final ReflectionHelper reflectionHelper;

    public Form build(String stepId, MethodParametersEditor uiInstance) {
        Form form = Form.builder().title(this.getCaption(uiInstance)).subtitle(this.getSubtitle(uiInstance)).status(null).readOnly(false).badges(List.of()).tabs(List.of()).sections(this.getSections(stepId, uiInstance)).actions(List.of()).mainActions(this.getMainActions(stepId, uiInstance)).build();
        return form;
    }

    private String getSubtitle(Object uiInstance) {
        return null;
    }

    private List<Action> getMainActions(String stepId, Object uiInstance) {
        ArrayList<Action> actions = new ArrayList<Action>();
        Action action = Action.builder().id("run").caption("Run").type(ActionType.Primary).validationRequired(true).visible(true).build();
        actions.add(action);
        return actions;
    }

    private List<io.mateu.remote.dtos.Section> getSections(String stepId, MethodParametersEditor methodParametersEditor) {
        ArrayList<io.mateu.remote.dtos.Section> sections = new ArrayList<io.mateu.remote.dtos.Section>();
        io.mateu.remote.dtos.Section section = null;
        io.mateu.remote.dtos.FieldGroup fieldGroup = null;
        FieldGroupLine fieldGroupLine = null;
        Method m = this.reflectionHelper.getMethod(methodParametersEditor.getType(), methodParametersEditor.getMethodId());
        List allEditableFields = this.reflectionHelper.getAllFields(m).stream().filter(f -> !f.isAnnotationPresent(UseCrud.class)).filter(f -> !ServerHttpRequest.class.isAssignableFrom(f.getType())).collect(Collectors.toList());
        boolean paramPos = false;
        for (FieldInterfaced fieldInterfaced : allEditableFields) {
            String caption;
            if (section == null || fieldInterfaced.isAnnotationPresent(Section.class)) {
                caption = "";
                boolean card = true;
                if (fieldInterfaced.isAnnotationPresent(Section.class)) {
                    Section annotation = fieldInterfaced.getAnnotation(Section.class);
                    caption = annotation.value();
                    card = annotation.card();
                }
                section = io.mateu.remote.dtos.Section.builder().caption(caption).readOnly(false).fieldGroups(new ArrayList()).type(card ? SectionType.Card : SectionType.Transparent).build();
                sections.add(section);
                fieldGroup = null;
            }
            if (fieldGroup == null || fieldInterfaced.isAnnotationPresent(FieldGroup.class)) {
                caption = "";
                if (fieldInterfaced.isAnnotationPresent(FieldGroup.class)) {
                    caption = fieldInterfaced.getAnnotation(FieldGroup.class).value();
                }
                fieldGroup = io.mateu.remote.dtos.FieldGroup.builder().caption(caption).lines(new ArrayList()).build();
                section.getFieldGroups().add(fieldGroup);
            }
            if (fieldGroupLine == null || !fieldInterfaced.isAnnotationPresent(SameLine.class)) {
                fieldGroupLine = FieldGroupLine.builder().fields(new ArrayList()).build();
                fieldGroup.getLines().add(fieldGroupLine);
            }
            fieldGroupLine.getFields().add(this.fieldMetadataBuilder.getField(methodParametersEditor, fieldInterfaced));
        }
        this.fillSectionIds(sections);
        return sections;
    }

    private void fillSectionIds(List<io.mateu.remote.dtos.Section> sections) {
        int fieldPos = 0;
        int i = 0;
        for (io.mateu.remote.dtos.Section s : sections) {
            s.setId("section_" + i++);
            int j = 0;
            for (io.mateu.remote.dtos.FieldGroup g : s.getFieldGroups()) {
                g.setId("fieldgroup_" + i + "_" + j++);
                for (FieldGroupLine l : g.getLines()) {
                    for (Field f : l.getFields()) {
                        f.setId("param_" + fieldPos++);
                    }
                }
            }
        }
    }

    private String getCaption(MethodParametersEditor methodParametersEditor) {
        return Helper.capitalize(methodParametersEditor.getMethodId());
    }

    public MethodParametersEditorMetadataBuilder(FieldMetadataBuilder fieldMetadataBuilder, ReflectionHelper reflectionHelper) {
        this.fieldMetadataBuilder = fieldMetadataBuilder;
        this.reflectionHelper = reflectionHelper;
    }
}

