/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.metadataBuilders;

import io.mateu.core.domain.model.metadataBuilders.fields.FieldAttributeBuilder;
import io.mateu.core.domain.model.metadataBuilders.fields.FieldStereotypeMapper;
import io.mateu.core.domain.model.metadataBuilders.fields.FieldTypeMapper;
import io.mateu.mdd.shared.annotations.CallActionOnChange;
import io.mateu.mdd.shared.annotations.Help;
import io.mateu.mdd.shared.annotations.Placeholder;
import io.mateu.mdd.shared.annotations.StyleClassNames;
import io.mateu.mdd.shared.data.BadgeIconPosition;
import io.mateu.mdd.shared.interfaces.HasBadgesOnFields;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.remote.dtos.Badge;
import io.mateu.remote.dtos.BadgeStyle;
import io.mateu.remote.dtos.BadgeTheme;
import io.mateu.remote.dtos.Field;
import io.mateu.remote.dtos.Validation;
import io.mateu.remote.dtos.ValidationType;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class FieldMetadataBuilder {
    final FieldAttributeBuilder fieldAttributeBuilder;
    final FieldTypeMapper fieldTypeMapper;
    final FieldStereotypeMapper fieldStereotypeMapper;
    final ReflectionHelper reflectionHelper;

    protected Field getField(Object view, FieldInterfaced fieldInterfaced) {
        Field field = Field.builder().id(fieldInterfaced.getId()).caption(this.reflectionHelper.getCaption(fieldInterfaced)).placeholder(this.getPlaceholder(fieldInterfaced)).description(this.getDescription(fieldInterfaced)).cssClasses(this.getCssClassNames(fieldInterfaced)).type(this.fieldTypeMapper.mapFieldType(fieldInterfaced)).stereotype(this.fieldStereotypeMapper.mapStereotype(view, fieldInterfaced)).observed(this.isObserved(fieldInterfaced)).attributes(this.fieldAttributeBuilder.buildAttributes(view, fieldInterfaced)).badges(this.getBadges(view, fieldInterfaced)).build();
        this.addValidations(field, fieldInterfaced);
        return field;
    }

    private List<Badge> getBadges(Object view, FieldInterfaced fieldInterfaced) {
        if (!(view instanceof HasBadgesOnFields)) {
            return List.of();
        }
        return ((HasBadgesOnFields)view).getBadgesOnField(fieldInterfaced.getId()).stream().map(b -> new Badge(this.mapBadgeTheme(b.getTheme()), b.getLabel(), b.getIcon(), this.mapBadgeStyle(b.getBadgeStyle()), this.mapBadgePosition(b.getIconPosition()))).collect(Collectors.toList());
    }

    private BadgeTheme mapBadgeTheme(io.mateu.mdd.shared.data.BadgeTheme theme) {
        return BadgeTheme.valueOf((String)theme.toString());
    }

    private BadgeStyle mapBadgeStyle(io.mateu.mdd.shared.data.BadgeStyle badgeStyle) {
        return BadgeStyle.valueOf((String)badgeStyle.toString());
    }

    private io.mateu.remote.dtos.BadgeIconPosition mapBadgePosition(BadgeIconPosition iconPosition) {
        return io.mateu.remote.dtos.BadgeIconPosition.valueOf((String)iconPosition.toString());
    }

    private boolean isObserved(FieldInterfaced fieldInterfaced) {
        return fieldInterfaced.isAnnotationPresent(CallActionOnChange.class);
    }

    private String getCssClassNames(FieldInterfaced fieldInterfaced) {
        if (fieldInterfaced.isAnnotationPresent(StyleClassNames.class)) {
            return String.join((CharSequence)" ", fieldInterfaced.getAnnotation(StyleClassNames.class).value());
        }
        return null;
    }

    private String getPlaceholder(FieldInterfaced fieldInterfaced) {
        if (fieldInterfaced.isAnnotationPresent(Placeholder.class)) {
            return fieldInterfaced.getAnnotation(Placeholder.class).value();
        }
        return null;
    }

    private void addValidations(Field field, FieldInterfaced fieldInterfaced) {
        ArrayList<Validation> validations = new ArrayList<Validation>();
        this.addRequiredValidation(fieldInterfaced, validations);
        this.addPatternValidation(fieldInterfaced, validations);
        this.addMinValidation(fieldInterfaced, validations);
        this.addMaxValidation(fieldInterfaced, validations);
        field.setValidations(validations);
    }

    private void addMinValidation(FieldInterfaced field, List<Validation> validations) {
        if (field.isAnnotationPresent(Min.class)) {
            validations.add(Validation.builder().type(ValidationType.Min).data((Object)field.getAnnotation(Min.class).value()).message(field.getAnnotation(Min.class).message()).build());
        }
    }

    private void addMaxValidation(FieldInterfaced field, List<Validation> validations) {
        if (field.isAnnotationPresent(Max.class)) {
            validations.add(Validation.builder().type(ValidationType.Max).data((Object)field.getAnnotation(Max.class).value()).message(field.getAnnotation(Max.class).message()).build());
        }
    }

    private void addRequiredValidation(FieldInterfaced field, List<Validation> validations) {
        if (field.isAnnotationPresent(NotEmpty.class) || field.isAnnotationPresent(NotNull.class) || field.isAnnotationPresent(NotBlank.class)) {
            validations.add(Validation.builder().type(ValidationType.NotEmpty).data(null).message("Required field").build());
        }
    }

    private void addPatternValidation(FieldInterfaced field, List<Validation> validations) {
        if (field.isAnnotationPresent(Pattern.class)) {
            validations.add(Validation.builder().type(ValidationType.Pattern).data((Object)field.getAnnotation(Pattern.class).regexp()).message(field.getAnnotation(Pattern.class).message()).build());
        }
    }

    private String getDescription(FieldInterfaced fieldInterfaced) {
        String description = null;
        if (fieldInterfaced.isAnnotationPresent(Help.class)) {
            description = fieldInterfaced.getAnnotation(Help.class).value();
        }
        return description;
    }

    public FieldMetadataBuilder(FieldAttributeBuilder fieldAttributeBuilder, FieldTypeMapper fieldTypeMapper, FieldStereotypeMapper fieldStereotypeMapper, ReflectionHelper reflectionHelper) {
        this.fieldAttributeBuilder = fieldAttributeBuilder;
        this.fieldTypeMapper = fieldTypeMapper;
        this.fieldStereotypeMapper = fieldStereotypeMapper;
        this.reflectionHelper = reflectionHelper;
    }
}

