/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.commands.runStepAction.concreteStepActionRunners.listActionRunners;

import io.mateu.core.domain.commands.runStepAction.concreteStepActionRunners.ListActionRunner;
import io.mateu.core.domain.model.store.JourneyStoreService;
import io.mateu.mdd.core.interfaces.Crud;
import io.mateu.mdd.shared.data.Destination;
import io.mateu.mdd.shared.data.DestinationType;
import io.mateu.mdd.shared.data.Result;
import io.mateu.mdd.shared.data.ResultType;
import io.mateu.util.Serializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class CrudDeleteActionRunner
implements ListActionRunner {
    @Autowired
    JourneyStoreService store;
    @Autowired
    Serializer serializer;

    @Override
    public boolean applies(Crud crud, String actionId) {
        return "delete".equals(actionId);
    }

    @Override
    public Mono<Void> run(Crud crud, String journeyId, String stepId, String listId, String actionId, Map<String, Object> data, ServerHttpRequest serverHttpRequest) throws Throwable {
        List selectedRows = (List)data.get("_selectedRows");
        if (selectedRows == null) {
            throw new Exception("No row selected");
        }
        try {
            ArrayList targetSet = new ArrayList(selectedRows.stream().map(m -> {
                try {
                    return crud.getRow((Map)m, this.serializer);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    return null;
                }
            }).collect(Collectors.toList()));
            crud.delete(targetSet);
            Result whatToShow = new Result(ResultType.Success, selectedRows + " elements have been deleted", List.of(), new Destination(DestinationType.ActionId, "Back to " + this.store.getInitialStep(journeyId).getName(), this.store.getInitialStep(journeyId).getId()), null);
            String newStepId = "result_" + UUID.randomUUID().toString();
            this.store.setStep(journeyId, newStepId, whatToShow, serverHttpRequest);
        }
        catch (Throwable e) {
            throw new Exception("Crud delete thrown " + e.getClass().getSimpleName() + ": " + e.getMessage());
        }
        return Mono.empty();
    }
}

