/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.queries.getItemsCount;

import io.mateu.core.domain.queries.EntitiesFinder;
import io.mateu.core.domain.queries.getItemsCount.GetItemsCountQuery;
import io.mateu.mdd.shared.data.ItemsListProvider;
import io.mateu.reflection.ReflectionHelper;
import jakarta.persistence.Entity;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GetItemsCountQueryHandler {
    private static final Logger log = LoggerFactory.getLogger(GetItemsCountQueryHandler.class);
    final ReflectionHelper reflectionHelper;

    public int run(GetItemsCountQuery query) throws Throwable {
        String itemsProviderId = query.getItemsProviderId();
        String searchText = query.getSearchText();
        Class<?> type = Class.forName(itemsProviderId);
        if (ItemsListProvider.class.isAssignableFrom(type)) {
            return ((ItemsListProvider)this.reflectionHelper.newInstance(type)).count(searchText);
        }
        if (type.isAnnotationPresent(Entity.class)) {
            return this.countEntities(type, searchText);
        }
        throw new Exception("No item provider with id " + itemsProviderId);
    }

    private int countEntities(Class entityClass, String searchText) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, InstantiationException {
        return this.reflectionHelper.newInstance(EntitiesFinder.class).countEntities(entityClass, searchText);
    }

    public GetItemsCountQueryHandler(ReflectionHelper reflectionHelper) {
        this.reflectionHelper = reflectionHelper;
    }
}

