/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.commands.runStepAction.concreteStepActionRunners;

import io.mateu.core.domain.commands.runStepAction.ActionRunner;
import io.mateu.core.domain.model.store.JourneyStoreService;
import io.mateu.mdd.shared.interfaces.PartialForm;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.remote.dtos.Action;
import io.mateu.remote.dtos.ActionType;
import io.mateu.remote.dtos.Component;
import io.mateu.remote.dtos.Form;
import io.mateu.remote.dtos.Section;
import io.mateu.remote.dtos.Step;
import io.mateu.remote.dtos.ViewMetadata;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class SavePartialFormActionRunner
implements ActionRunner {
    public static final String SAVE_PARTIAL_FORM_IDENTIFIER = "savePartialForm__";
    public static final String EDIT_PARTIAL_FORM_IDENTIFIER = "editPartialForm__";
    final JourneyStoreService store;
    final ReflectionHelper reflectionHelper;

    @Override
    public boolean applies(Object viewInstance, String actionId) {
        return actionId.startsWith(SAVE_PARTIAL_FORM_IDENTIFIER);
    }

    @Override
    public Mono<Void> run(Object form, String journeyId, String stepId, String actionId, Map<String, Object> data, ServerHttpRequest serverHttpRequest) throws Throwable {
        Step step = this.store.getStep(journeyId, stepId);
        ViewMetadata metadata = ((Component)step.getView().getMain().getComponents().get(0)).getMetadata();
        List sections = ((Form)metadata).getSections();
        String sectionId = actionId.substring(SAVE_PARTIAL_FORM_IDENTIFIER.length());
        PartialForm partialForm = this.getOrInitializeIfNotPresent(form, sectionId);
        this.updateSectionToReadOnly(sections, sectionId);
        partialForm.save();
        this.store.updateStep(journeyId, stepId, step);
        return Mono.empty();
    }

    private PartialForm getOrInitializeIfNotPresent(Object form, String sectionId) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        FieldInterfaced partialFormField = this.reflectionHelper.getFieldByName(form.getClass(), sectionId);
        PartialForm partialForm = (PartialForm)this.reflectionHelper.getValue(partialFormField, form);
        if (partialForm == null) {
            partialForm = (PartialForm)this.reflectionHelper.newInstance(partialFormField.getType());
            this.reflectionHelper.setValue(partialFormField, form, (Object)partialForm);
        }
        return partialForm;
    }

    private void updateSectionToReadOnly(List<Section> sections, String sectionId) {
        ArrayList<Action> actions = new ArrayList<Action>();
        Action actionEdit = Action.builder().id(EDIT_PARTIAL_FORM_IDENTIFIER + sectionId).caption("Edit").type(ActionType.Secondary).validationRequired(false).visible(true).build();
        actions.add(actionEdit);
        for (Section section : sections) {
            if (!section.getId().equals(sectionId) || section.isReadOnly()) continue;
            section.setReadOnly(true);
            section.setActions(List.of(actionEdit));
        }
    }

    public SavePartialFormActionRunner(JourneyStoreService store, ReflectionHelper reflectionHelper) {
        this.store = store;
        this.reflectionHelper = reflectionHelper;
    }
}

