/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.metadataBuilders;

import io.mateu.core.domain.model.metadataBuilders.FieldMetadataBuilder;
import io.mateu.mdd.core.interfaces.HasIcon;
import io.mateu.mdd.core.interfaces.HasInfo;
import io.mateu.mdd.core.interfaces.HasSubtitle;
import io.mateu.mdd.core.interfaces.HasTitle;
import io.mateu.mdd.core.interfaces.HasTotal;
import io.mateu.mdd.core.interfaces.PersistentPojo;
import io.mateu.mdd.core.interfaces.ReadOnlyPojo;
import io.mateu.mdd.shared.annotations.Caption;
import io.mateu.mdd.shared.annotations.FieldGroup;
import io.mateu.mdd.shared.annotations.SameLine;
import io.mateu.mdd.shared.annotations.UseCrud;
import io.mateu.mdd.shared.data.StatusType;
import io.mateu.mdd.shared.interfaces.HasBadges;
import io.mateu.mdd.shared.interfaces.HasStatus;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.remote.dtos.Badge;
import io.mateu.remote.dtos.BadgeType;
import io.mateu.remote.dtos.Card;
import io.mateu.remote.dtos.FieldGroupLine;
import io.mateu.remote.dtos.Status;
import io.mateu.util.Helper;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToMany;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class CardMetadataBuilder {
    final FieldMetadataBuilder fieldMetadataBuilder;
    final ReflectionHelper reflectionHelper;

    public Card build(String stepId, Object uiInstance, List<FieldInterfaced> slotFields) {
        Card card = Card.builder().title(this.getCaption(uiInstance)).subtitle(this.getSubtitle(uiInstance)).fieldGroups(this.getFieldGroups(stepId, uiInstance, slotFields)).icon(this.getIcon(uiInstance)).info(this.getInfo(uiInstance)).total(this.getTotal(uiInstance)).build();
        return card;
    }

    private String getIcon(Object uiInstance) {
        if (uiInstance instanceof HasIcon) {
            return ((HasIcon)uiInstance).getIcon();
        }
        return null;
    }

    private String getInfo(Object uiInstance) {
        if (uiInstance instanceof HasInfo) {
            return ((HasInfo)uiInstance).getInfo();
        }
        return null;
    }

    private String getTotal(Object uiInstance) {
        if (uiInstance instanceof HasTotal) {
            return ((HasTotal)uiInstance).getTotal();
        }
        return null;
    }

    private String getSubtitle(Object uiInstance) {
        if (uiInstance instanceof HasSubtitle) {
            return ((HasSubtitle)uiInstance).getSubtitle();
        }
        return null;
    }

    private Status getStatus(Object uiInstance) {
        if (!(uiInstance instanceof HasStatus)) {
            return null;
        }
        HasStatus hasStatus = (HasStatus)uiInstance;
        if (hasStatus.getStatus() == null) {
            return null;
        }
        return new Status(this.mapStatusType(hasStatus.getStatus().getType()), hasStatus.getStatus().getMessage());
    }

    private io.mateu.remote.dtos.StatusType mapStatusType(StatusType type) {
        return io.mateu.remote.dtos.StatusType.valueOf((String)type.toString());
    }

    private List<Badge> getBadges(Object uiInstance) {
        if (!(uiInstance instanceof HasBadges)) {
            return List.of();
        }
        return ((HasBadges)uiInstance).getBadges().stream().map(b -> new Badge(this.mapBadgeType(b.getType()), b.getMessage())).collect(Collectors.toList());
    }

    private BadgeType mapBadgeType(io.mateu.mdd.shared.data.BadgeType type) {
        return BadgeType.valueOf((String)type.toString());
    }

    private List<io.mateu.remote.dtos.FieldGroup> getFieldGroups(String stepId, Object uiInstance, List<FieldInterfaced> slotFields) {
        ArrayList<io.mateu.remote.dtos.FieldGroup> fieldGroups = new ArrayList<io.mateu.remote.dtos.FieldGroup>();
        io.mateu.remote.dtos.FieldGroup fieldGroup = null;
        FieldGroupLine fieldGroupLine = null;
        List allEditableFields = this.reflectionHelper.getAllEditableFields(uiInstance.getClass()).stream().filter(f -> !f.isAnnotationPresent(OneToMany.class) && !f.isAnnotationPresent(ManyToMany.class) || !f.isAnnotationPresent(UseCrud.class)).filter(f -> slotFields.contains(f)).filter(f -> !(uiInstance instanceof HasTotal) || !f.getName().equals("total")).collect(Collectors.toList());
        for (FieldInterfaced fieldInterfaced : allEditableFields) {
            if (fieldGroup == null || fieldInterfaced.isAnnotationPresent(FieldGroup.class)) {
                String caption = "";
                if (fieldInterfaced.isAnnotationPresent(FieldGroup.class)) {
                    caption = fieldInterfaced.getAnnotation(FieldGroup.class).value();
                }
                fieldGroup = io.mateu.remote.dtos.FieldGroup.builder().caption(caption).lines(new ArrayList()).build();
                fieldGroups.add(fieldGroup);
            }
            if (fieldGroupLine == null || !fieldInterfaced.isAnnotationPresent(SameLine.class)) {
                fieldGroupLine = FieldGroupLine.builder().fields(new ArrayList()).build();
                fieldGroup.getLines().add(fieldGroupLine);
            }
            fieldGroupLine.getFields().add(this.fieldMetadataBuilder.getField(uiInstance, fieldInterfaced));
        }
        this.fillGroupIds(fieldGroups);
        return fieldGroups;
    }

    private void fillGroupIds(List<io.mateu.remote.dtos.FieldGroup> fieldGroups) {
        int j = 0;
        for (io.mateu.remote.dtos.FieldGroup g : fieldGroups) {
            g.setId("fieldgroup_" + j++);
        }
    }

    private String getCaption(Object uiInstance) {
        if (uiInstance instanceof HasTitle) {
            return ((HasTitle)uiInstance).getTitle();
        }
        Class<?> modelType = uiInstance.getClass();
        if (modelType.isAnnotationPresent(Caption.class)) {
            return modelType.getAnnotation(Caption.class).value();
        }
        String viewTitle = "";
        if (uiInstance != null && uiInstance instanceof ReadOnlyPojo) {
            viewTitle = ((ReadOnlyPojo)uiInstance).retrieveEntityName();
        }
        if (uiInstance != null && uiInstance instanceof PersistentPojo) {
            viewTitle = ((PersistentPojo)uiInstance).retrieveEntityName();
            if (((PersistentPojo)uiInstance).isNewRecord()) {
                return "New " + viewTitle;
            }
        }
        Object prefix = "";
        if (!"".equals(viewTitle)) {
            prefix = viewTitle + " ";
        }
        try {
            if (Object.class.equals(modelType.getMethod("toString", new Class[0]).getDeclaringClass())) {
                return Helper.capitalize(modelType.getSimpleName());
            }
            return Helper.capitalize(uiInstance.toString());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return (String)prefix + uiInstance;
        }
    }

    public CardMetadataBuilder(FieldMetadataBuilder fieldMetadataBuilder, ReflectionHelper reflectionHelper) {
        this.fieldMetadataBuilder = fieldMetadataBuilder;
        this.reflectionHelper = reflectionHelper;
    }
}

