/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.store;

import io.mateu.core.domain.commands.runStepAction.ActualValueExtractor;
import io.mateu.core.domain.model.editors.EntityEditor;
import io.mateu.core.domain.model.editors.FieldEditor;
import io.mateu.core.domain.model.editors.ObjectEditor;
import io.mateu.core.domain.model.modelToDtoMappers.StepMapper;
import io.mateu.core.domain.model.modelToDtoMappers.UIMapper;
import io.mateu.core.domain.model.persistence.Merger;
import io.mateu.core.domain.model.store.JourneyContainer;
import io.mateu.core.domain.model.store.JourneyRepository;
import io.mateu.core.domain.model.store.MenuToBeanMapping;
import io.mateu.core.domain.model.store.MenuToBeanMappingRepository;
import io.mateu.mdd.core.app.MDDOpenCRUDAction;
import io.mateu.mdd.core.app.MDDOpenCRUDActionViewBuilder;
import io.mateu.mdd.core.app.MDDOpenEditorAction;
import io.mateu.mdd.core.app.MDDOpenListViewAction;
import io.mateu.mdd.core.app.MDDOpenRemoteJourneyAction;
import io.mateu.mdd.core.interfaces.HasInitMethod;
import io.mateu.mdd.core.interfaces.JpaRpcCrudFactory;
import io.mateu.mdd.shared.interfaces.Listing;
import io.mateu.mdd.shared.interfaces.SortCriteria;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.remote.dtos.Journey;
import io.mateu.remote.dtos.Step;
import io.mateu.util.Serializer;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class JourneyStoreService {
    private static final Logger log = LoggerFactory.getLogger(JourneyStoreService.class);
    private final StepMapper stepMapper;
    private final UIMapper uiMapper;
    private final JourneyRepository journeyRepo;
    private final ActualValueExtractor actualValueExtractor;
    private final ApplicationContext applicationContext;
    private final Merger merger;
    private final JpaRpcCrudFactory jpaRpcCrudFactory;
    private final ReflectionHelper reflectionHelper;
    private final Serializer serializer;
    private final MDDOpenCRUDActionViewBuilder mddOpenCRUDActionViewBuilder;
    @Autowired
    private MenuToBeanMappingRepository menuMappingRepo;

    public Object getViewInstance(String journeyId, String stepId, ServerHttpRequest serverHttpRequest) throws Exception {
        Optional<JourneyContainer> container = this.journeyRepo.findById(journeyId);
        if (!container.isPresent()) {
            throw new Exception("No journey with id " + journeyId + " found");
        }
        Step step = container.get().getSteps().get(stepId);
        if (step == null) {
            throw new Exception("No step with id " + stepId + " for journey with id " + journeyId + " found");
        }
        Object viewInstance = this.reflectionHelper.newInstance(Class.forName(step.getType()));
        Map data = step.getData();
        if (viewInstance instanceof EntityEditor) {
            ((EntityEditor)viewInstance).setEntityClass(Class.forName((String)data.get("__entityClassName__")));
            ((EntityEditor)viewInstance).setData(data);
        } else if (viewInstance instanceof ObjectEditor) {
            ((ObjectEditor)viewInstance).setType(Class.forName((String)data.get("__entityClassName__")));
            ((ObjectEditor)viewInstance).setData(data);
        } else if (viewInstance instanceof FieldEditor) {
            ((FieldEditor)viewInstance).setType(Class.forName((String)data.get("__type__")));
            ((FieldEditor)viewInstance).setFieldId((String)data.get("__fieldId__"));
            ((FieldEditor)viewInstance).setInitialStep((String)data.get("__initialStep__"));
            ((FieldEditor)viewInstance).setData(data);
        } else {
            data.entrySet().forEach(entry -> {
                try {
                    Object actualValue = this.actualValueExtractor.getActualValue((Map.Entry<String, Object>)entry, viewInstance);
                    this.reflectionHelper.setValue((String)entry.getKey(), viewInstance, actualValue);
                }
                catch (Exception ex) {
                    System.out.println(ex.getClass().getSimpleName() + ": " + ex.getMessage());
                }
            });
        }
        return viewInstance;
    }

    @Transactional
    public Listing getRpcViewInstance(String journeyId, String stepId, String listId, ServerHttpRequest serverHttpRequest) throws Exception {
        try {
            FieldInterfaced listField;
            Object viewInstance = this.getViewInstance(journeyId, stepId, serverHttpRequest);
            if (viewInstance instanceof Listing) {
                return (Listing)viewInstance;
            }
            Object actualInstance = viewInstance;
            Listing rpcView = null;
            if (actualInstance instanceof EntityEditor) {
                EntityEditor entityEditor = (EntityEditor)actualInstance;
                FieldInterfaced listField2 = this.reflectionHelper.getFieldByName((actualInstance = this.merger.loadEntity(entityEditor.getData(), entityEditor.getEntityClass())).getClass(), listId);
                if (listField2 != null) {
                    return this.jpaRpcCrudFactory.create(actualInstance, listField2);
                }
            } else if (actualInstance instanceof ObjectEditor) {
                ObjectEditor objectEditor = (ObjectEditor)actualInstance;
                Object instanceFromSpringContext = this.reflectionHelper.newInstance(objectEditor.getType());
                Object instanceWithDeserializedValues = this.serializer.fromJson(this.serializer.toJson(objectEditor.getData()), objectEditor.getType());
                this.reflectionHelper.copy(instanceWithDeserializedValues, instanceFromSpringContext);
                FieldInterfaced listField3 = this.reflectionHelper.getFieldByName(instanceFromSpringContext.getClass(), listId);
                if (listField3 != null) {
                    return (Listing)this.reflectionHelper.getValue(listField3, instanceFromSpringContext);
                }
            } else {
                return (Listing)this.reflectionHelper.getValue(listId, actualInstance);
            }
            if ((listField = this.reflectionHelper.getFieldByName(actualInstance.getClass(), listId)) != null) {
                rpcView = (Listing)this.reflectionHelper.newInstance(listField.getType());
                this.reflectionHelper.setValue(listId, actualInstance, (Object)rpcView);
            }
            return rpcView;
        }
        catch (Exception e) {
            log.warn("on getRpcViewInstance for " + journeyId + " " + stepId + " " + listId, (Throwable)e);
            return null;
        }
    }

    public Optional<JourneyContainer> findJourneyById(String journeyId) {
        return this.journeyRepo.findById(journeyId);
    }

    public void save(JourneyContainer journeyContainer) {
        journeyContainer.setLastAccess(LocalDateTime.now());
        this.journeyRepo.save(journeyContainer);
    }

    public void updateStep(String journeyId, String stepId, Object editor, ServerHttpRequest serverHttpRequest) throws Throwable {
        Optional<JourneyContainer> container = this.journeyRepo.findById(journeyId);
        if (!container.isPresent()) {
            throw new Exception("No journey with id " + journeyId + " found");
        }
        Step oldStep = container.get().getSteps().get(stepId);
        Step step = this.stepMapper.map(container.get(), stepId, oldStep.getPreviousStepId(), editor, serverHttpRequest);
        if (oldStep != null) {
            Map data = oldStep.getData();
            data.putAll(step.getData());
            step.setData(data);
        }
        if (!container.get().getSteps().containsKey(stepId)) {
            container.get().setSteps(this.extendMap(container.get().getSteps(), stepId, step));
        } else {
            HashMap<String, Step> modifiableMap = new HashMap<String, Step>(container.get().getSteps());
            modifiableMap.put(stepId, step);
            container.get().setSteps(modifiableMap);
        }
        container.get().setLastAccess(LocalDateTime.now());
        this.journeyRepo.save(container.get());
    }

    public void updateStep(String journeyId, Object editor, ServerHttpRequest serverHttpRequest) throws Throwable {
        Optional<JourneyContainer> container = this.journeyRepo.findById(journeyId);
        if (!container.isPresent()) {
            throw new Exception("No journey with id " + journeyId + " found");
        }
        String stepId = container.get().getJourney().getCurrentStepId();
        this.updateStep(journeyId, stepId, editor, serverHttpRequest);
    }

    public void updateStep(String journeyId, String stepId, Step step) throws Throwable {
        Optional<JourneyContainer> container = this.journeyRepo.findById(journeyId);
        if (!container.isPresent()) {
            throw new Exception("No journey with id " + journeyId + " found");
        }
        if (!container.get().getSteps().containsKey(stepId)) {
            container.get().setSteps(this.extendMap(container.get().getSteps(), stepId, step));
        } else {
            HashMap<String, Step> modifiableMap = new HashMap<String, Step>(container.get().getSteps());
            modifiableMap.put(stepId, step);
            container.get().setSteps(modifiableMap);
        }
        container.get().setLastAccess(LocalDateTime.now());
        this.journeyRepo.save(container.get());
    }

    public void setStep(String journeyId, String stepId, Object editor, ServerHttpRequest serverHttpRequest) throws Throwable {
        Optional<JourneyContainer> container = this.journeyRepo.findById(journeyId);
        if (!container.isPresent()) {
            throw new Exception("No journey with id " + journeyId + " found");
        }
        Object stepIdPrefix = container.get().getJourney().getCurrentStepId();
        stepIdPrefix = stepIdPrefix == null ? "" : (String)stepIdPrefix + "_";
        if (((String)stepIdPrefix).endsWith("view_")) {
            stepIdPrefix = ((String)stepIdPrefix).substring(0, "view_".length());
        }
        if (((String)stepIdPrefix).endsWith("edit_")) {
            stepIdPrefix = ((String)stepIdPrefix).substring(0, "edit_".length());
        }
        String newStepId = (String)stepIdPrefix + stepId;
        Step step = this.stepMapper.map(container.get(), newStepId, this.getPreviousStepId(newStepId, container), editor, serverHttpRequest);
        if (!container.get().getSteps().containsKey(newStepId)) {
            container.get().setSteps(this.extendMap(container.get().getSteps(), newStepId, step));
        } else {
            HashMap<String, Step> modifiableMap = new HashMap<String, Step>(container.get().getSteps());
            modifiableMap.put(newStepId, step);
            container.get().setSteps(modifiableMap);
        }
        container.get().getJourney().setCurrentStepId(newStepId);
        container.get().getJourney().setCurrentStepDefinitionId(editor.getClass().getName());
        container.get().setLastAccess(LocalDateTime.now());
        this.journeyRepo.save(container.get());
    }

    private String getPreviousStepId(String targetStepId, Optional<JourneyContainer> container) {
        if (container.isEmpty()) {
            return null;
        }
        String currentStepId = container.get().getJourney().getCurrentStepId();
        if (targetStepId.equals(currentStepId)) {
            return container.get().getSteps().get(currentStepId).getPreviousStepId();
        }
        return currentStepId;
    }

    private String getCurrentStepId(Optional<JourneyContainer> container) {
        if (container.isEmpty()) {
            return null;
        }
        return container.get().getJourney().getCurrentStepId();
    }

    private Map<String, Step> extendMap(Map<String, Step> steps, String stepId, Step step) {
        HashMap<String, Step> extended = new HashMap<String, Step>();
        extended.putAll(steps);
        extended.put(stepId, step);
        return extended;
    }

    public Journey getJourney(String journeyId) throws Exception {
        Optional<JourneyContainer> container = this.findJourneyById(journeyId);
        if (!container.isPresent()) {
            throw new Exception("No journey with id " + journeyId + " found");
        }
        return container.get().getJourney();
    }

    public void backToStep(String journeyId, String stepId) throws Exception {
        Optional<JourneyContainer> container = this.findJourneyById(journeyId);
        if (!container.isPresent()) {
            throw new Exception("No journey with id " + journeyId + " found");
        }
        Step step = container.get().getSteps().get(stepId);
        if (step == null) {
            throw new Exception("No step with id " + stepId + " for journey with id " + journeyId + " found");
        }
        container.get().getJourney().setCurrentStepId(stepId);
        container.get().getJourney().setCurrentStepDefinitionId(step.getType());
        container.get().setLastAccess(LocalDateTime.now());
        this.journeyRepo.save(container.get());
    }

    public boolean isCrud(String journeyId) throws Exception {
        Optional<JourneyContainer> container = this.findJourneyById(journeyId);
        if (!container.isPresent()) {
            throw new Exception("No journey with id " + journeyId + " found");
        }
        return "list".equals(container.get().getInitialStep());
    }

    public Step getStepAndSetAsCurrent(String journeyId, String stepId) throws Exception {
        Optional<JourneyContainer> container = this.findJourneyById(journeyId);
        if (!container.isPresent()) {
            throw new Exception("No journey with id " + journeyId + " found");
        }
        Step step = container.get().getSteps().get(stepId);
        if (step == null) {
            throw new Exception("No step with id " + journeyId + " found for journey " + journeyId);
        }
        container.get().getJourney().setCurrentStepDefinitionId(step.getType());
        container.get().getJourney().setCurrentStepId(stepId);
        container.get().setLastAccess(LocalDateTime.now());
        this.journeyRepo.save(container.get());
        return step;
    }

    public Step readStep(String journeyId, String stepId) throws Exception {
        Optional<JourneyContainer> container = this.findJourneyById(journeyId);
        if (!container.isPresent()) {
            throw new Exception("No journey with id " + journeyId + " found");
        }
        Step step = container.get().getSteps().get(stepId);
        if (step == null) {
            throw new Exception("No step with id " + journeyId + " found for journey " + journeyId);
        }
        return step;
    }

    public Step getInitialStep(String journeyId) throws Exception {
        Optional<JourneyContainer> container = this.findJourneyById(journeyId);
        if (!container.isPresent()) {
            throw new Exception("No journey with id " + journeyId + " found");
        }
        return container.get().getInitialStep();
    }

    public Step getCurrentStep(String journeyId) throws Exception {
        Optional<JourneyContainer> container = this.findJourneyById(journeyId);
        if (!container.isPresent()) {
            throw new Exception("No journey with id " + journeyId + " found");
        }
        String currentStepId = container.get().getJourney().getCurrentStepId();
        return container.get().getSteps().get(currentStepId);
    }

    public void storeMenuAction(String actionId, Object bean) {
        this.menuMappingRepo.save(MenuToBeanMapping.builder().actionId(actionId).bean(bean).build());
    }

    public MenuToBeanMapping getMenuMapping(String actionId, ServerHttpRequest serverHttpRequest) {
        Optional<MenuToBeanMapping> menuToBeanMapping = this.menuMappingRepo.findById(actionId);
        if (menuToBeanMapping.isEmpty()) {
            if (actionId.contains("_")) {
                String uiClassName = actionId.split("_")[1];
                Object uiInstance = null;
                try {
                    uiInstance = this.reflectionHelper.newInstance(Class.forName(uiClassName));
                    if (uiInstance instanceof HasInitMethod) {
                        ((HasInitMethod)uiInstance).init(serverHttpRequest);
                    }
                    this.uiMapper.map(uiInstance, serverHttpRequest);
                    menuToBeanMapping = this.menuMappingRepo.findById(actionId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                String uiClassName = actionId;
                Object uiInstance = null;
                try {
                    uiInstance = this.reflectionHelper.newInstance(Class.forName(uiClassName));
                    if (uiInstance instanceof HasInitMethod) {
                        ((HasInitMethod)uiInstance).init(serverHttpRequest);
                    }
                    this.uiMapper.map(uiInstance, serverHttpRequest);
                    Object finalUiInstance = uiInstance;
                    this.storeMenuAction(actionId, new MDDOpenEditorAction("", () -> finalUiInstance));
                    menuToBeanMapping = this.menuMappingRepo.findById(actionId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return menuToBeanMapping.orElse(null);
    }

    public Object createInstanceFromJourneyTypeId(String journeyTypeId, ServerHttpRequest serverHttpRequest) {
        MenuToBeanMapping menuMapping = this.getMenuMapping(journeyTypeId, serverHttpRequest);
        Object formInstance = null;
        try {
            formInstance = this.createInstanceFromMenuMapping(menuMapping.getBean());
            if (formInstance instanceof HasInitMethod) {
                ((HasInitMethod)formInstance).init(serverHttpRequest);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return formInstance;
    }

    private Object createInstanceFromMenuMapping(Object menuEntry) throws Exception {
        if (menuEntry instanceof MDDOpenRemoteJourneyAction) {
            MDDOpenRemoteJourneyAction action = (MDDOpenRemoteJourneyAction)menuEntry;
            return action.getRemoteJourney();
        }
        if (menuEntry instanceof MDDOpenEditorAction) {
            MDDOpenEditorAction action = (MDDOpenEditorAction)menuEntry;
            return this.reflectionHelper.newInstance(action.getViewClass());
        }
        if (menuEntry instanceof MDDOpenCRUDAction) {
            MDDOpenCRUDAction action = (MDDOpenCRUDAction)menuEntry;
            return this.mddOpenCRUDActionViewBuilder.buildView(action);
        }
        if (menuEntry instanceof MDDOpenListViewAction) {
            MDDOpenListViewAction action = (MDDOpenListViewAction)menuEntry;
            return this.reflectionHelper.newInstance(action.getListViewClass());
        }
        return null;
    }

    public StepMapper getStepMapper() {
        return this.stepMapper;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Object getLastUsedFilters(String journeyId, String stepId, String listId) {
        JourneyContainer journeyContainer = this.journeyRepo.findById(journeyId).get();
        return journeyContainer.getLastUsedFilters().get(stepId + "#" + listId);
    }

    public List<SortCriteria> getLastUsedOrders(String journeyId, String stepId, String listId) {
        JourneyContainer journeyContainer = this.journeyRepo.findById(journeyId).get();
        return journeyContainer.getLastUsedSorting().get(stepId + "#" + listId);
    }

    public void saveFilters(String journeyId, String stepId, String listId, Object filters) {
        JourneyContainer journeyContainer = this.journeyRepo.findById(journeyId).get();
        journeyContainer.getLastUsedFilters().put(stepId + "#" + listId, filters);
        this.journeyRepo.save(journeyContainer);
    }

    public void saveOrders(String journeyId, String stepId, String listId, List<SortCriteria> sorting) {
        JourneyContainer journeyContainer = this.journeyRepo.findById(journeyId).get();
        journeyContainer.getLastUsedSorting().put(stepId + "#" + listId, sorting);
        this.journeyRepo.save(journeyContainer);
    }

    public JourneyStoreService(StepMapper stepMapper, UIMapper uiMapper, JourneyRepository journeyRepo, ActualValueExtractor actualValueExtractor, ApplicationContext applicationContext, Merger merger, JpaRpcCrudFactory jpaRpcCrudFactory, ReflectionHelper reflectionHelper, Serializer serializer, MDDOpenCRUDActionViewBuilder mddOpenCRUDActionViewBuilder) {
        this.stepMapper = stepMapper;
        this.uiMapper = uiMapper;
        this.journeyRepo = journeyRepo;
        this.actualValueExtractor = actualValueExtractor;
        this.applicationContext = applicationContext;
        this.merger = merger;
        this.jpaRpcCrudFactory = jpaRpcCrudFactory;
        this.reflectionHelper = reflectionHelper;
        this.serializer = serializer;
        this.mddOpenCRUDActionViewBuilder = mddOpenCRUDActionViewBuilder;
    }
}

