/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.metadataBuilders;

import com.google.common.base.Strings;
import io.mateu.mdd.core.interfaces.Crud;
import io.mateu.mdd.core.interfaces.HasActions;
import io.mateu.mdd.core.interfaces.PersistentPojo;
import io.mateu.mdd.core.interfaces.ReadOnlyPojo;
import io.mateu.mdd.core.interfaces.RpcCrudViewExtended;
import io.mateu.mdd.shared.annotations.Action;
import io.mateu.mdd.shared.annotations.MainAction;
import io.mateu.mdd.shared.interfaces.Listing;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.remote.dtos.ActionTarget;
import io.mateu.remote.dtos.ActionType;
import io.mateu.remote.dtos.ConfirmationTexts;
import jakarta.persistence.Entity;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class ActionMetadataBuilder {
    final ReflectionHelper reflectionHelper;

    protected io.mateu.remote.dtos.Action getAction(Method m) {
        io.mateu.remote.dtos.Action action = io.mateu.remote.dtos.Action.builder().id(m.getName()).caption(this.reflectionHelper.getCaption(m)).type(this.getActionType(m)).target(this.getTarget(m)).modalWidth(this.getModalWidth(m)).modalHeight(this.getModalHeight(m)).visible(this.isVisible(m)).validationRequired(this.getValidationRequired(m)).confirmationRequired(this.getConfirmationRequired(m)).confirmationTexts(this.getConfirmationTexts(m)).build();
        return action;
    }

    private String getModalHeight(Method m) {
        if (m.isAnnotationPresent(Action.class)) {
            Action action = m.getAnnotation(Action.class);
            return action.modalHeight();
        }
        if (m.isAnnotationPresent(MainAction.class)) {
            MainAction action = m.getAnnotation(MainAction.class);
            return action.modalHeight();
        }
        return "";
    }

    private String getModalWidth(Method m) {
        if (m.isAnnotationPresent(Action.class)) {
            Action action = m.getAnnotation(Action.class);
            return action.modalWidth();
        }
        if (m.isAnnotationPresent(MainAction.class)) {
            MainAction action = m.getAnnotation(MainAction.class);
            return action.modalWidth();
        }
        return "";
    }

    private ActionTarget getTarget(Method m) {
        if (m.isAnnotationPresent(Action.class)) {
            Action action = m.getAnnotation(Action.class);
            return ActionTarget.valueOf((String)action.target().name());
        }
        if (m.isAnnotationPresent(MainAction.class)) {
            MainAction action = m.getAnnotation(MainAction.class);
            return ActionTarget.valueOf((String)action.target().name());
        }
        return ActionTarget.SameLane;
    }

    private boolean isVisible(Method m) {
        if (m.isAnnotationPresent(Action.class)) {
            Action action = m.getAnnotation(Action.class);
            return action.visible();
        }
        return true;
    }

    private ActionType getActionType(Method m) {
        if (m.isAnnotationPresent(Action.class)) {
            Action action = m.getAnnotation(Action.class);
            return ActionType.valueOf((String)action.type().name());
        }
        if (m.isAnnotationPresent(MainAction.class)) {
            MainAction action = m.getAnnotation(MainAction.class);
            return ActionType.valueOf((String)action.type().name());
        }
        return ActionType.Primary;
    }

    private ConfirmationTexts getConfirmationTexts(Method m) {
        if (m.isAnnotationPresent(Action.class)) {
            Action action = m.getAnnotation(Action.class);
            return ConfirmationTexts.builder().title(this.getConfirmationTitle(action.confirmationTitle(), m)).message(action.confirmationMessage()).action(this.getConfirmationAction(action.confirmationAction(), m)).build();
        }
        if (m.isAnnotationPresent(MainAction.class)) {
            MainAction action = m.getAnnotation(MainAction.class);
            return ConfirmationTexts.builder().title(this.getConfirmationTitle(action.confirmationTitle(), m)).message(action.confirmationMessage()).action(this.getConfirmationAction(action.confirmationAction(), m)).build();
        }
        return null;
    }

    private String getConfirmationAction(String action, Method m) {
        if (Strings.isNullOrEmpty((String)action)) {
            return this.reflectionHelper.getCaption(m);
        }
        return action;
    }

    private String getConfirmationTitle(String title, Method m) {
        if (Strings.isNullOrEmpty((String)title)) {
            return "Please confirm";
        }
        return title;
    }

    private boolean getConfirmationRequired(Method m) {
        if (m.isAnnotationPresent(Action.class)) {
            return !Strings.isNullOrEmpty((String)m.getAnnotation(Action.class).confirmationMessage());
        }
        if (m.isAnnotationPresent(MainAction.class)) {
            return !Strings.isNullOrEmpty((String)m.getAnnotation(MainAction.class).confirmationMessage());
        }
        return false;
    }

    private boolean getValidationRequired(Method m) {
        if (m.isAnnotationPresent(Action.class)) {
            return m.getAnnotation(Action.class).validateBefore();
        }
        if (m.isAnnotationPresent(MainAction.class)) {
            return m.getAnnotation(MainAction.class).validateBefore();
        }
        return true;
    }

    protected List<io.mateu.remote.dtos.Action> getActions(String stepId, String listId, Object uiInstance) {
        io.mateu.remote.dtos.Action action;
        List<Method> allMethods = this.reflectionHelper.getAllMethods(uiInstance.getClass());
        List<io.mateu.remote.dtos.Action> actions = allMethods.stream().filter(m -> m.isAnnotationPresent(Action.class)).filter(m -> !"JpaRpcCrudView".equals(uiInstance.getClass().getSimpleName()) || Modifier.isStatic(m.getModifiers())).sorted(Comparator.comparingInt(m -> m.getAnnotation(Action.class).order())).map(m -> this.getAction((Method)m)).collect(Collectors.toList());
        if (uiInstance instanceof HasActions) {
            actions.addAll(((HasActions)uiInstance).getActionMethods().stream().map(m -> this.getAction((Method)m)).collect(Collectors.toList()));
        }
        if (!Strings.isNullOrEmpty((String)listId)) {
            actions.forEach(a -> a.setId("__list__" + listId + "__" + a.getId()));
        }
        if (this.canAdd(uiInstance)) {
            action = io.mateu.remote.dtos.Action.builder().id("__list__" + listId + "__new").caption(this.getCaptionForNew(uiInstance)).type(ActionType.Primary).visible(true).build();
            actions.add(action);
        }
        if (this.canDelete(uiInstance)) {
            action = io.mateu.remote.dtos.Action.builder().id("__list__" + listId + "__delete").caption(this.getCaptionForDelete(uiInstance)).type(ActionType.Primary).confirmationRequired(true).confirmationTexts(ConfirmationTexts.builder().title("Please confirm").message("Are you sure you want to delete the selected rows").action("Yes, delete them").build()).visible(true).build();
            actions.add(action);
        }
        if ("view".equals(stepId) && uiInstance.getClass().isAnnotationPresent(Entity.class) || uiInstance instanceof ReadOnlyPojo && !(uiInstance instanceof PersistentPojo)) {
            action = io.mateu.remote.dtos.Action.builder().id("edit").caption(this.getCaptionForEdit(uiInstance)).type(ActionType.Primary).visible(true).build();
            actions.add(action);
        }
        return actions;
    }

    private String getCaptionForNew(Object uiInstance) {
        if (uiInstance != null && uiInstance instanceof Crud) {
            return ((Crud)uiInstance).getCaptionForNew();
        }
        return "New";
    }

    private String getCaptionForDelete(Object uiInstance) {
        if (uiInstance != null && uiInstance instanceof Crud) {
            return ((Crud)uiInstance).getCaptionForDelete();
        }
        return "Delete";
    }

    private String getCaptionForEdit(Object uiInstance) {
        if (uiInstance != null && uiInstance instanceof Listing) {
            return ((Listing)uiInstance).getCaptionForEdit();
        }
        return "Edit";
    }

    private boolean canAdd(Object uiInstance) {
        if (uiInstance instanceof RpcCrudViewExtended) {
            return ((RpcCrudViewExtended)uiInstance).isAddEnabled();
        }
        if (uiInstance instanceof Crud) {
            return this.reflectionHelper.isOverridden(uiInstance, "getNewRecordForm");
        }
        return false;
    }

    private boolean canDelete(Object uiInstance) {
        if (uiInstance instanceof RpcCrudViewExtended) {
            return ((RpcCrudViewExtended)uiInstance).isDeleteEnabled();
        }
        if (uiInstance instanceof Crud) {
            return this.reflectionHelper.isOverridden(uiInstance, "delete");
        }
        return false;
    }

    public ActionMetadataBuilder(ReflectionHelper reflectionHelper) {
        this.reflectionHelper = reflectionHelper;
    }
}

