/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain;

import com.opencsv.CSVWriter;
import io.mateu.core.application.OrderingDeserializer;
import io.mateu.core.domain.UploadService;
import io.mateu.core.domain.commands.runStepAction.RunStepActionCommand;
import io.mateu.core.domain.commands.runStepAction.RunStepActionCommandHandler;
import io.mateu.core.domain.commands.startJourney.StartJourneyCommand;
import io.mateu.core.domain.commands.startJourney.StartJourneyCommandHandler;
import io.mateu.core.domain.model.store.JourneyContainer;
import io.mateu.core.domain.model.store.JourneyStoreService;
import io.mateu.core.domain.queries.getItemsCount.GetItemsCountQuery;
import io.mateu.core.domain.queries.getItemsCount.GetItemsCountQueryHandler;
import io.mateu.core.domain.queries.getItemsRows.GetItemsRowsQuery;
import io.mateu.core.domain.queries.getItemsRows.GetItemsRowsQueryHandler;
import io.mateu.core.domain.queries.getJourney.GetJourneyQuery;
import io.mateu.core.domain.queries.getJourney.GetJourneyQueryHandler;
import io.mateu.core.domain.queries.getJourneyTypes.GetJourneyTypesQuery;
import io.mateu.core.domain.queries.getJourneyTypes.GetJourneyTypesQueryHandler;
import io.mateu.core.domain.queries.getListCount.GetListCountQuery;
import io.mateu.core.domain.queries.getListCount.GetListCountQueryHandler;
import io.mateu.core.domain.queries.getListRows.GetListRowsQuery;
import io.mateu.core.domain.queries.getListRows.GetListRowsQueryHandler;
import io.mateu.core.domain.queries.getStep.GetStepQuery;
import io.mateu.core.domain.queries.getStep.GetStepQueryHandler;
import io.mateu.core.domain.queries.getUI.GetUIQuery;
import io.mateu.core.domain.queries.getUI.GetUIQueryHandler;
import io.mateu.core.infra.csv.ByteArrayInOutStream;
import io.mateu.mdd.shared.data.Value;
import io.mateu.remote.dtos.Journey;
import io.mateu.remote.dtos.JourneyCreationRq;
import io.mateu.remote.dtos.JourneyType;
import io.mateu.remote.dtos.RunActionRq;
import io.mateu.remote.dtos.Step;
import io.mateu.remote.dtos.StepWrapper;
import io.mateu.remote.dtos.UI;
import io.mateu.util.Serializer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.naming.AuthenticationException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Service
public class MateuService {
    private static final Logger log = LoggerFactory.getLogger(MateuService.class);
    @Autowired
    JourneyStoreService store;
    @Autowired
    StartJourneyCommandHandler startJourneyCommandHandler;
    @Autowired
    RunStepActionCommandHandler runStepActionCommandHandler;
    @Autowired
    GetUIQueryHandler getUIQueryHandler;
    @Autowired
    GetJourneyQueryHandler getJourneyQueryHandler;
    @Autowired
    GetStepQueryHandler getStepQueryHandler;
    @Autowired
    GetJourneyTypesQueryHandler getJourneyTypesQueryHandler;
    @Autowired
    GetListRowsQueryHandler getListRowsQueryHandler;
    @Autowired
    GetListCountQueryHandler getListCountQueryHandler;
    @Autowired
    GetItemsCountQueryHandler getItemsCountQueryHandler;
    @Autowired
    GetItemsRowsQueryHandler getItemsRowsQueryHandler;
    @Autowired
    UploadService uploadService;
    @Autowired
    Serializer serializer;

    public Mono<UI> getUI(String uiId, ServerHttpRequest serverHttpRequest) throws Exception {
        return Mono.just((Object)this.getUIQueryHandler.run(GetUIQuery.builder().uiId(uiId).build(), serverHttpRequest));
    }

    public Flux<JourneyType> getJourneyTypes(ServerHttpRequest serverHttpRequest) throws Exception {
        return Flux.fromStream(this.getJourneyTypesQueryHandler.run(GetJourneyTypesQuery.builder().build(), serverHttpRequest).stream());
    }

    public Mono<Void> createJourney(String journeyTypeId, String journeyId, JourneyCreationRq rq, ServerHttpRequest serverHttpRequest) throws Throwable {
        log.info("creating journey " + journeyTypeId + "/" + journeyId);
        return this.startJourneyCommandHandler.handle(StartJourneyCommand.builder().journeyId(journeyId).journeyTypeId(journeyTypeId).serverHttpRequest(serverHttpRequest).build());
    }

    public Mono<Journey> getJourney(String journeyTypeId, String journeyId, ServerHttpRequest serverHttpRequest) throws Exception {
        log.info("getting journey " + journeyTypeId + "/" + journeyId);
        return this.getJourneyQueryHandler.run(GetJourneyQuery.builder().journeyTypeId(journeyTypeId).journeyId(journeyId).serverHttpRequest(serverHttpRequest).build());
    }

    public Mono<Step> getStep(String journeyTypeId, String journeyId, String stepId, ServerHttpRequest serverHttpRequest) throws Exception {
        log.info("getting step " + journeyTypeId + "/" + journeyId + "/" + stepId);
        return this.getStepQueryHandler.run(GetStepQuery.builder().journeyTypeId(journeyTypeId).journeyId(journeyId).stepId(stepId).serverHttpRequest(serverHttpRequest).build());
    }

    public Mono<Void> runStep(String journeyTypeId, String journeyId, String stepId, String actionId, RunActionRq rq, ServerHttpRequest serverHttpRequest) throws Throwable {
        log.info("running action " + journeyTypeId + "/" + journeyId + "/" + stepId + "/" + actionId);
        if (rq.getJourney() != null) {
            JourneyContainer journey = this.serializer.fromJson(this.serializer.toJson(rq.getJourney()), JourneyContainer.class);
            this.store.save(journey);
        }
        return this.runStepActionCommandHandler.handle(RunStepActionCommand.builder().journeyTypeId(journeyTypeId).journeyId(journeyId).stepId(stepId).actionId(actionId).data(rq.getData()).serverHttpRequest(serverHttpRequest).build());
    }

    public Mono<StepWrapper> createJourneyAndReturn(String journeyTypeId, String journeyId, JourneyCreationRq rq, ServerHttpRequest serverHttpRequest) throws Throwable {
        return this.createJourney(journeyTypeId, journeyId, rq, serverHttpRequest).thenReturn((Object)StepWrapper.builder().journey(this.getJourneyFromStore(journeyId)).step(this.getStep(journeyId)).store(this.getJourneyContainer(journeyId)).build());
    }

    public Mono<StepWrapper> runStepAndReturn(String journeyTypeId, String journeyId, String stepId, String actionId, RunActionRq rq, ServerHttpRequest serverHttpRequest) throws Throwable {
        return this.runStep(journeyTypeId, journeyId, stepId, actionId, rq, serverHttpRequest).thenReturn((Object)StepWrapper.builder().journey(this.getJourneyFromStore(journeyId)).step(this.getStep(journeyId)).store(this.getJourneyContainer(journeyId)).build());
    }

    private Map<String, Object> getJourneyContainer(String journeyId) {
        try {
            return this.serializer.toMap(this.store.findJourneyById(journeyId).get());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Step getStep(String journeyId) {
        try {
            return this.store.getCurrentStep(journeyId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Journey getJourneyFromStore(String journeyId) {
        try {
            return this.store.getJourney(journeyId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Flux<Object> getListRows(String journeyTypeId, String journeyId, String stepId, String listId, int page, int page_size, Map<String, Object> filters, String ordering, Map<String, Object> journey, ServerHttpRequest serverHttpRequest) throws Throwable {
        if (journey != null) {
            JourneyContainer journeyContainer = this.serializer.fromJson(this.serializer.toJson(journey), JourneyContainer.class);
            this.store.save(journeyContainer);
        }
        return this.getListRowsQueryHandler.run(GetListRowsQuery.builder().journeyTypeId(journeyTypeId).journeyId(journeyId).stepId(stepId).listId(listId).page(page).pageSize(page_size).filters(filters).ordering(new OrderingDeserializer(ordering).deserialize(this.serializer)).serverHttpRequest(serverHttpRequest).build());
    }

    public Mono<Long> getListCount(String journeyTypeId, String journeyId, String stepId, String listId, Map<String, Object> filters, Map<String, Object> journey, ServerHttpRequest serverHttpRequest) throws Throwable {
        if (journey != null) {
            JourneyContainer journeyContainer = this.serializer.fromJson(this.serializer.toJson(journey), JourneyContainer.class);
            this.store.save(journeyContainer);
        }
        return this.getListCountQueryHandler.run(GetListCountQuery.builder().journeyTypeId(journeyTypeId).journeyId(journeyId).stepId(stepId).listId(listId).filters(filters).serverHttpRequest(serverHttpRequest).build());
    }

    public Flux<Value> getItems(String itemProviderId, int page, int page_size, String search_text) throws Throwable {
        return Flux.fromStream(this.getItemsRowsQueryHandler.run(GetItemsRowsQuery.builder().itemsProviderId(itemProviderId).page(page).pageSize(page_size).searchText(search_text).build()).stream());
    }

    public Mono<Integer> getItemCount(String itemProviderId, String search_text) throws Throwable {
        return Mono.just((Object)this.getItemsCountQueryHandler.run(GetItemsCountQuery.builder().itemsProviderId(itemProviderId).searchText(search_text).build()));
    }

    public ResponseEntity<Resource> serveFile(String fileId, String filename) throws AuthenticationException {
        return this.uploadService.serveFile(fileId, filename);
    }

    public String getFileUrl(String fileId, String fileName) throws AuthenticationException {
        return this.uploadService.getFileUrl(fileId, fileName);
    }

    public Mono<Void> handleFileUpload(String fileId, Mono<FilePart> file) throws AuthenticationException, ExecutionException, InterruptedException, TimeoutException {
        return this.uploadService.handleFileUpload(fileId, file);
    }

    public Mono<ByteArrayInputStream> generateCsv(String journeyTypeId, String journeyId, String stepId, String listId, Map<String, Object> filters, String ordering, Map<String, Object> journey, ServerHttpRequest serverHttpRequest) throws Throwable {
        return this.getListRows(journeyTypeId, journeyId, stepId, listId, 0, 500, filters, ordering, journey, serverHttpRequest).map(o -> this.toMap(o)).map(m -> m.values()).map(a -> a.stream().map(o -> "" + o).collect(Collectors.toList())).map(l -> l.toArray(new String[0])).collectList().map(list -> {
            try {
                ByteArrayInOutStream stream = new ByteArrayInOutStream();
                OutputStreamWriter streamWriter = new OutputStreamWriter(stream);
                CSVWriter writer = new CSVWriter((Writer)streamWriter);
                writer.writeAll(list);
                streamWriter.flush();
                return stream.getInputStream();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).subscribeOn(Schedulers.boundedElastic());
    }

    private Map<String, Object> toMap(Object o) {
        if (o instanceof Map) {
            return (Map)o;
        }
        try {
            return this.serializer.toMap(o);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Map.of();
        }
    }

    public Mono<ByteArrayInputStream> generateExcel(String journeyTypeId, String journeyId, String stepId, String listId, Map<String, Object> filters, String ordering, Map<String, Object> journey, ServerHttpRequest serverHttpRequest) throws Throwable {
        return this.getListRows(journeyTypeId, journeyId, stepId, listId, 0, 500, filters, ordering, journey, serverHttpRequest).map(o -> this.toMap(o)).map(m -> m.values()).map(a -> a.stream().map(o -> "" + o).collect(Collectors.toList())).map(l -> l.toArray(new String[0])).collectList().map(list -> {
            try {
                XSSFWorkbook workbook = new XSSFWorkbook();
                Sheet sheet = workbook.createSheet("All");
                ByteArrayInOutStream stream = new ByteArrayInOutStream();
                OutputStreamWriter streamWriter = new OutputStreamWriter(stream);
                CellStyle style = workbook.createCellStyle();
                style.setWrapText(true);
                for (int i = 0; i < list.size(); ++i) {
                    Row row = sheet.createRow(i + 1);
                    String[] data = (String[])list.get(i);
                    if (data == null) continue;
                    for (int col = 0; col < data.length; ++col) {
                        Cell cell = row.createCell(col);
                        cell.setCellValue((String)(data[col] != null ? data[col] : ""));
                        cell.setCellStyle(style);
                    }
                }
                workbook.write((OutputStream)stream);
                workbook.close();
                streamWriter.flush();
                return stream.getInputStream();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).subscribeOn(Schedulers.boundedElastic());
    }
}

