/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.infra.memory;

import io.mateu.core.domain.model.store.JourneyContainer;
import io.mateu.core.domain.model.store.JourneyRepository;
import jakarta.annotation.PostConstruct;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class MemoryJourneyRepository
implements JourneyRepository {
    private static final Logger log = LoggerFactory.getLogger(MemoryJourneyRepository.class);
    Map<String, JourneyContainer> containers = new HashMap<String, JourneyContainer>();

    @Override
    public Optional<JourneyContainer> findById(String journeyId) {
        return Optional.ofNullable(this.containers.get(journeyId));
    }

    @Override
    public void save(JourneyContainer journeyContainer) {
        this.containers.put(journeyContainer.getJourneyId(), journeyContainer);
    }

    @Override
    public Flux<JourneyContainer> findAll() {
        return Flux.fromStream(this.containers.values().stream());
    }

    @Override
    public Mono<Long> count() {
        return Mono.just((Object)this.containers.size());
    }

    @PostConstruct
    public void init() {
        new Thread(() -> {
            boolean loop = true;
            while (loop) {
                try {
                    ArrayList containersIdToRemove = new ArrayList();
                    LocalDateTime expiryTime = LocalDateTime.now().minusHours(1L);
                    this.containers.forEach((id, container) -> {
                        if (container.getLastAccess().isBefore(expiryTime)) {
                            log.info("will remove journey " + id + " due to inactivity");
                            containersIdToRemove.add(id);
                        }
                    });
                    containersIdToRemove.forEach(id -> this.containers.remove(id));
                }
                catch (Exception e) {
                    log.error("exception on journey store cleanup", (Throwable)e);
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    loop = false;
                }
            }
        }).start();
    }
}

