/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.commands.runStepAction.concreteStepActionRunners;

import io.mateu.core.domain.commands.runStepAction.ActionRunner;
import io.mateu.core.domain.model.editors.ObjectEditor;
import io.mateu.core.domain.model.store.JourneyStoreService;
import io.mateu.mdd.core.interfaces.ReadOnlyPojo;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.Serializer;
import java.util.Map;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class ObjectEditorEditActionRunner
implements ActionRunner {
    final JourneyStoreService store;
    final ReflectionHelper reflectionHelper;
    final Serializer serializer;

    @Override
    public boolean applies(Object viewInstance, String actionId) {
        return viewInstance instanceof ObjectEditor && "edit".equals(actionId);
    }

    @Override
    public Mono<Void> run(Object viewInstance, String journeyId, String stepId, String actionId, Map<String, Object> data, ServerHttpRequest serverHttpRequest) throws Throwable {
        this.store.setStep(journeyId, "edit", this.getEditor((ObjectEditor)viewInstance), serverHttpRequest);
        return Mono.empty();
    }

    private Object getEditor(ObjectEditor objectEditor) throws Throwable {
        Object object = this.reflectionHelper.newInstance(objectEditor.getType());
        Object filled = this.serializer.fromJson(this.serializer.toJson(objectEditor.getData()), objectEditor.getType());
        this.reflectionHelper.copy(filled, object);
        Object editor = object;
        if (object instanceof ReadOnlyPojo) {
            editor = ((ReadOnlyPojo)object).retrieveEditor();
        }
        return editor;
    }

    public ObjectEditorEditActionRunner(JourneyStoreService store, ReflectionHelper reflectionHelper, Serializer serializer) {
        this.store = store;
        this.reflectionHelper = reflectionHelper;
        this.serializer = serializer;
    }
}

