/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.modelToDtoMappers;

import com.google.common.base.Strings;
import io.mateu.core.domain.apiClients.MateuRemoteClient;
import io.mateu.mdd.core.app.AbstractMenu;
import io.mateu.mdd.core.app.MDDCallMethodAction;
import io.mateu.mdd.core.app.MDDOpenEditorAction;
import io.mateu.mdd.core.app.MDDOpenHtmlAction;
import io.mateu.mdd.core.app.MDDOpenListViewAction;
import io.mateu.mdd.core.app.MDDOpenRemoteJourneyAction;
import io.mateu.mdd.core.app.MDDOpenUrlAction;
import io.mateu.mdd.core.app.menuResolvers.MenuResolver;
import io.mateu.mdd.shared.annotations.Home;
import io.mateu.mdd.shared.annotations.MenuOption;
import io.mateu.mdd.shared.annotations.Private;
import io.mateu.mdd.shared.annotations.PrivateHome;
import io.mateu.mdd.shared.annotations.PublicHome;
import io.mateu.mdd.shared.annotations.Submenu;
import io.mateu.mdd.shared.interfaces.IncludesRemoteUIs;
import io.mateu.mdd.shared.interfaces.Listing;
import io.mateu.mdd.shared.interfaces.MateuSecurityManager;
import io.mateu.mdd.shared.interfaces.MenuEntry;
import io.mateu.mdd.shared.interfaces.RemoteJourney;
import io.mateu.mdd.shared.interfaces.RemoteSubmenu;
import io.mateu.mdd.shared.interfaces.RemoteUI;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.remote.dtos.Menu;
import io.mateu.remote.dtos.UI;
import io.mateu.util.Helper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;

@Service
public class MenuParser {
    private final MateuRemoteClient mateuRemoteClient;
    private final ReflectionHelper reflectionHelper;
    private final MenuResolver menuResolver;

    public List<MenuEntry> parse(Object uiInstance, ServerHttpRequest serverHttpRequest) {
        return this.buildMenu(uiInstance, serverHttpRequest, true, true);
    }

    private List<MenuEntry> buildMenu(Object uiInstance, ServerHttpRequest serverHttpRequest, boolean authenticationAgnostic, boolean publicAccess) {
        Private pa;
        boolean add;
        ArrayList<MenuEntry> l = new ArrayList<MenuEntry>();
        for (FieldInterfaced f : this.reflectionHelper.getAllFields(uiInstance.getClass())) {
            if (!Modifier.isPublic(f.getModifiers())) {
                f.getField().setAccessible(true);
            }
            add = false;
            if (publicAccess && !f.isAnnotationPresent(Private.class)) {
                add = true;
            }
            if (!publicAccess && f.isAnnotationPresent(Private.class)) {
                pa = f.getAnnotation(Private.class);
                add = pa != null ? authenticationAgnostic || this.check(pa) : true;
            }
            if (!add || !f.isAnnotationPresent(MenuOption.class) && !f.isAnnotationPresent(Submenu.class)) continue;
            this.addMenuEntry(uiInstance, l, f, authenticationAgnostic, publicAccess, serverHttpRequest);
        }
        for (Method m : this.getAllMenuMethods(uiInstance.getClass())) {
            if (!Modifier.isPublic(m.getModifiers())) {
                m.setAccessible(true);
            }
            add = false;
            if (authenticationAgnostic) {
                add = true;
            } else {
                if (publicAccess && !m.isAnnotationPresent(Private.class)) {
                    add = true;
                }
                if (!publicAccess && m.isAnnotationPresent(Private.class)) {
                    pa = m.getAnnotation(Private.class);
                    add = pa != null ? this.check(pa) : true;
                }
            }
            if (!add) continue;
            this.addMenuEntry(uiInstance, l, m, authenticationAgnostic, publicAccess, serverHttpRequest);
        }
        if (uiInstance instanceof IncludesRemoteUIs) {
            ((IncludesRemoteUIs)uiInstance).getRemoteUIs().forEach(remoteUI -> this.addMenuEntries((List<MenuEntry>)l, (RemoteUI)remoteUI, serverHttpRequest));
        }
        l.sort(Comparator.comparingInt(MenuEntry::getOrder));
        return l;
    }

    private MenuEntry toMenuEntry(String caption, final RemoteSubmenu remoteSubmenu, ServerHttpRequest serverHttpRequest) throws ExecutionException, InterruptedException {
        UI ui = this.mateuRemoteClient.getUi(remoteSubmenu.getBaseUrl(), remoteSubmenu.getUiId(), serverHttpRequest);
        final Optional<Menu> remoteMenu = ui.getMenu().stream().filter(m -> m.getCaption().equals(remoteSubmenu.getCaption())).findFirst();
        AbstractMenu menuEntry = new AbstractMenu(caption + (remoteMenu.isEmpty() ? "(Not found)" : "")){

            @Override
            public List<MenuEntry> buildEntries() {
                if (remoteMenu.isEmpty()) {
                    return List.of();
                }
                ArrayList<MenuEntry> options = new ArrayList<MenuEntry>();
                ((Menu)remoteMenu.get()).getSubmenus().forEach(m -> options.add(MenuParser.this.toMenuEntry(remoteSubmenu.getBaseUrl(), (Menu)m)));
                return options;
            }
        };
        return menuEntry;
    }

    private void addMenuEntries(List<MenuEntry> l, RemoteUI remoteUI, ServerHttpRequest serverHttpRequest) {
        try {
            UI ui = this.mateuRemoteClient.getUi(remoteUI.getBaseUrl(), remoteUI.getUiId(), serverHttpRequest);
            ui.getMenu().stream().forEach(remoteMenu -> {
                MenuEntry menuEntry = this.toMenuEntry(remoteUI.getBaseUrl(), (Menu)remoteMenu);
                l.add(menuEntry);
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private MenuEntry toMenuEntry(final String baseUrl, final Menu remoteMenu) {
        MenuEntry menuEntry = null;
        menuEntry = !Strings.isNullOrEmpty((String)remoteMenu.getJourneyTypeId()) ? new MDDOpenRemoteJourneyAction(remoteMenu.getCaption(), new RemoteJourney(baseUrl, remoteMenu.getJourneyTypeId())) : new AbstractMenu(remoteMenu.getCaption()){

            @Override
            public List<MenuEntry> buildEntries() {
                if (remoteMenu.getSubmenus() == null) {
                    return List.of();
                }
                ArrayList<MenuEntry> options = new ArrayList<MenuEntry>();
                remoteMenu.getSubmenus().forEach(m -> options.add(MenuParser.this.toMenuEntry(baseUrl, (Menu)m)));
                return options;
            }
        };
        return menuEntry;
    }

    private boolean check(Private pa) {
        try {
            return Helper.getImpl(MateuSecurityManager.class).check(pa);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void addMenuEntry(final Object uiInstance, List<MenuEntry> l, final Method m, boolean authenticationAgnostic, boolean publicAccess, final ServerHttpRequest serverHttpRequest) {
        String caption;
        String string = caption = m.isAnnotationPresent(Submenu.class) ? m.getAnnotation(Submenu.class).value() : m.getAnnotation(MenuOption.class).value();
        if (Strings.isNullOrEmpty((String)caption)) {
            caption = Helper.capitalize(m.getName());
        }
        String icon = null;
        if (m.isAnnotationPresent(Submenu.class)) {
            icon = m.getAnnotation(Submenu.class).icon();
        }
        if (m.isAnnotationPresent(MenuOption.class)) {
            icon = m.getAnnotation(MenuOption.class).icon();
        }
        int order = 0;
        if (m.isAnnotationPresent(MenuOption.class)) {
            order = m.getAnnotation(MenuOption.class).order();
        } else if (m.isAnnotationPresent(Submenu.class)) {
            order = m.getAnnotation(Submenu.class).order();
        }
        if (order == 0 || order == 10000) {
            order = l.size();
        }
        if (m.isAnnotationPresent(Submenu.class)) {
            l.add(new AbstractMenu(icon, caption){

                @Override
                public List<MenuEntry> buildEntries() {
                    try {
                        return MenuParser.this.parse(uiInstance, serverHttpRequest);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        return new ArrayList<MenuEntry>();
                    }
                }
            }.setOrder(order));
        } else if (m.isAnnotationPresent(MenuOption.class) || m.isAnnotationPresent(Home.class) || m.isAnnotationPresent(PublicHome.class) || m.isAnnotationPresent(PrivateHome.class)) {
            if (List.class.isAssignableFrom(m.getReturnType()) && MenuEntry.class.equals(this.reflectionHelper.getGenericClass(m))) {
                l.add(new AbstractMenu(icon, caption){

                    @Override
                    public List<MenuEntry> buildEntries() {
                        List<MenuEntry> l = new ArrayList<MenuEntry>();
                        try {
                            l = (List)MenuParser.this.reflectionHelper.invokeInjectableParametersOnly(m, uiInstance);
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                        return l;
                    }
                }.setOrder(order));
            } else {
                l.add(new MDDCallMethodAction(caption, m, uiInstance).setIcon(icon).setOrder(order));
            }
        }
    }

    private void addMenuEntry(Object uiInstance, List<MenuEntry> l, FieldInterfaced f, boolean authenticationAgnostic, boolean publicAccess, final ServerHttpRequest serverHttpRequest) {
        block19: {
            String caption = this.reflectionHelper.getCaption(f);
            String icon = null;
            if (f.isAnnotationPresent(Submenu.class)) {
                icon = f.getAnnotation(Submenu.class).icon();
            }
            if (f.isAnnotationPresent(MenuOption.class)) {
                icon = f.getAnnotation(MenuOption.class).icon();
            }
            int order = 0;
            if (f.isAnnotationPresent(MenuOption.class)) {
                order = f.getAnnotation(MenuOption.class).order();
            } else if (f.isAnnotationPresent(Submenu.class)) {
                order = f.getAnnotation(Submenu.class).order();
            }
            if (order == 0 || order == 10000) {
                order = l.size();
            }
            if (f.isAnnotationPresent(Submenu.class)) {
                if (!Modifier.isPublic(f.getModifiers())) {
                    f.getField().setAccessible(true);
                }
                try {
                    if (RemoteSubmenu.class.equals(f.getType())) {
                        RemoteSubmenu remoteSubmenu = (RemoteSubmenu)this.reflectionHelper.getValue(f, uiInstance);
                        l.add(this.toMenuEntry(caption, remoteSubmenu, serverHttpRequest));
                        break block19;
                    }
                    if (URL.class.equals(f.getType())) {
                        l.add(new MDDOpenUrlAction(caption, (URL)this.reflectionHelper.getValue(f, uiInstance)));
                        break block19;
                    }
                    Object v = this.reflectionHelper.getValue(f, uiInstance);
                    if (v == null) {
                        v = this.reflectionHelper.newInstance(f.getType());
                    }
                    final Object finalV = v;
                    l.add(new AbstractMenu(icon, caption){

                        @Override
                        public List<MenuEntry> buildEntries() {
                            try {
                                return MenuParser.this.parse(finalV, serverHttpRequest);
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                                return new ArrayList<MenuEntry>();
                            }
                        }
                    }.setOrder(order));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (f.isAnnotationPresent(MenuOption.class) || f.isAnnotationPresent(Home.class) || f.isAnnotationPresent(PublicHome.class) || f.isAnnotationPresent(PrivateHome.class)) {
                try {
                    if (!Modifier.isPublic(f.getModifiers())) {
                        f.getField().setAccessible(true);
                    }
                    boolean menuResolved = false;
                    menuResolved = this.menuResolver.addMenuEntry(uiInstance, l, f, caption, order, icon);
                    if (!menuResolved) {
                        this.addDefaultMenuEntry(uiInstance, l, f, caption, order, icon);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void addDefaultMenuEntry(Object uiInstance, List<MenuEntry> l, FieldInterfaced f, String caption, int order, String icon) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        Object v = this.reflectionHelper.getValue(f, uiInstance);
        if (ReflectionHelper.isBasico(f.getType()) || String.class.equals(f.getType())) {
            if (f.isAnnotationPresent(Home.class) || f.isAnnotationPresent(PublicHome.class) || f.isAnnotationPresent(PrivateHome.class)) {
                l.add(new MDDOpenHtmlAction("Home", "" + v).setIcon("home").setOrder(order));
            } else {
                l.add(new MDDOpenHtmlAction(caption, "" + v).setIcon(icon).setOrder(order));
            }
        } else if (Listing.class.isAssignableFrom(f.getType())) {
            l.add(new MDDOpenListViewAction(caption, f.getType()).setIcon(icon).setOrder(order));
        } else {
            l.add(new MDDOpenEditorAction(caption, () -> {
                try {
                    return v != null ? v : this.reflectionHelper.newInstance(f.getType());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }).setIcon(icon).setOrder(order));
        }
    }

    private List<Method> getAllMenuMethods(Class c) {
        ArrayList<Method> l = new ArrayList<Method>();
        if (c.getSuperclass() != null) {
            l.addAll(this.getAllMenuMethods(c.getSuperclass()));
        }
        for (Method f : c.getDeclaredMethods()) {
            if (!f.isAnnotationPresent(MenuOption.class) && !f.isAnnotationPresent(Submenu.class)) continue;
            l.add(f);
        }
        return l;
    }

    public MenuParser(MateuRemoteClient mateuRemoteClient, ReflectionHelper reflectionHelper, MenuResolver menuResolver) {
        this.mateuRemoteClient = mateuRemoteClient;
        this.reflectionHelper = reflectionHelper;
        this.menuResolver = menuResolver;
    }
}

