/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.modelToDtoMappers;

import io.mateu.core.domain.apiClients.MateuRemoteClient;
import io.mateu.core.domain.model.editors.EntityEditor;
import io.mateu.core.domain.model.editors.FieldEditor;
import io.mateu.core.domain.model.editors.MethodParametersEditor;
import io.mateu.core.domain.model.editors.ObjectEditor;
import io.mateu.core.domain.model.metadataBuilders.ViewMetadataBuilder;
import io.mateu.core.domain.model.modelToDtoMappers.viewMapperStuff.DataExtractor;
import io.mateu.core.domain.model.modelToDtoMappers.viewMapperStuff.FieldExtractor;
import io.mateu.core.domain.model.modelToDtoMappers.viewMapperStuff.RulesBuilder;
import io.mateu.core.domain.model.modelToDtoMappers.viewMapperStuff.UIInstancePart;
import io.mateu.core.domain.model.modelToDtoMappers.viewMapperStuff.UIInstancePartsExtractor;
import io.mateu.core.domain.model.store.JourneyContainer;
import io.mateu.core.domain.model.store.JourneyStoreService;
import io.mateu.mdd.core.interfaces.HasMessages;
import io.mateu.mdd.core.interfaces.HasSubtitle;
import io.mateu.mdd.core.interfaces.HasTitle;
import io.mateu.mdd.core.interfaces.RpcCrudViewExtended;
import io.mateu.mdd.shared.annotations.SlotName;
import io.mateu.mdd.shared.data.Result;
import io.mateu.mdd.shared.interfaces.Listing;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.remote.dtos.Component;
import io.mateu.remote.dtos.Crud;
import io.mateu.remote.dtos.Form;
import io.mateu.remote.dtos.Message;
import io.mateu.remote.dtos.Rule;
import io.mateu.remote.dtos.RuleAction;
import io.mateu.remote.dtos.View;
import io.mateu.remote.dtos.ViewMetadata;
import io.mateu.remote.dtos.ViewPart;
import io.mateu.util.Serializer;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;

@Service
public class ViewMapper {
    @PersistenceContext
    EntityManager em;
    @Autowired
    MateuRemoteClient mateuRemoteClient;
    @Autowired
    ApplicationContext applicationContext;
    @Autowired
    FieldExtractor fieldExtractor;
    @Autowired
    ViewMetadataBuilder viewMetadataBuilder;
    @Autowired
    DataExtractor dataExtractor;
    @Autowired
    RulesBuilder rulesBuilder;
    @Autowired
    UIInstancePartsExtractor uiInstancePartsExtractor;
    @Autowired
    ReflectionHelper reflectionHelper;
    @Autowired
    Serializer serializer;

    public View map(JourneyContainer journeyContainer, String stepId, Object uiInstance, Map<String, Object> data, List<Rule> rules, ServerHttpRequest serverHttpRequest) throws Throwable {
        Object actualUiInstance = this.getActualUiInstance(journeyContainer, stepId, uiInstance, serverHttpRequest);
        data.putAll(this.dataExtractor.getData(uiInstance, actualUiInstance));
        ArrayList<Component> left = new ArrayList<Component>();
        ArrayList<Component> main = new ArrayList<Component>();
        ArrayList<Component> right = new ArrayList<Component>();
        ArrayList header = new ArrayList();
        ArrayList footer = new ArrayList();
        Map componentsPerSlot = Map.of(SlotName.left, left, SlotName.main, main, SlotName.right, right, SlotName.header, header, SlotName.footer, footer);
        for (SlotName slot : List.of(SlotName.main, SlotName.left, SlotName.right, SlotName.header, SlotName.footer)) {
            List<FieldInterfaced> slotFields = this.fieldExtractor.getFields(actualUiInstance, slot);
            List<UIInstancePart> uiInstanceParts = this.uiInstancePartsExtractor.getUiParts(actualUiInstance, slotFields, slot);
            if (SlotName.main.equals((Object)slot) && uiInstanceParts.size() == 0) {
                uiInstanceParts.add(new UIInstancePart("", actualUiInstance, List.of()));
            }
            uiInstanceParts.forEach(p -> {
                ViewMetadata metadata = this.viewMetadataBuilder.getMetadata(stepId, uiInstance, p.getUiInstance(), p.getFields());
                metadata.setDataPrefix(p.getDataPrefix());
                rules.addAll(this.rulesBuilder.buildRules(metadata, p.getUiInstance()));
                ((List)componentsPerSlot.get((Object)slot)).add(Component.builder().metadata(metadata).attributes(new HashMap()).build());
            });
        }
        this.addComponentIds(left, main, right, rules);
        this.removeTitleForFirstComponent(main);
        View view = View.builder().title(this.getTitle(actualUiInstance)).subtitle(this.getSubtitle(actualUiInstance)).messages(this.getMessages(actualUiInstance)).left(ViewPart.builder().components(left).build()).main(ViewPart.builder().components(main).build()).right(ViewPart.builder().components(right).build()).header(ViewPart.builder().components(header).build()).footer(ViewPart.builder().components(footer).build()).build();
        return view;
    }

    private List<Message> getMessages(Object uiInstance) {
        if (uiInstance instanceof HasMessages) {
            return ((HasMessages)uiInstance).getMessages().stream().map(m -> new Message(m.getId(), m.getType(), m.getTitle(), m.getText())).collect(Collectors.toList());
        }
        return List.of();
    }

    private void removeTitleForFirstComponent(List<Component> slot) {
        if (slot.size() > 0) {
            ViewMetadata metadata = slot.get(0).getMetadata();
            if (metadata instanceof Form) {
                ((Form)metadata).setTitle(null);
                ((Form)metadata).setSubtitle(null);
            } else if (metadata instanceof Crud) {
                ((Crud)metadata).setTitle(null);
                ((Crud)metadata).setSubtitle(null);
            }
        }
    }

    private String getSubtitle(Object uiInstance) {
        if (uiInstance instanceof Result) {
            return null;
        }
        if (uiInstance instanceof HasSubtitle) {
            return ((HasSubtitle)uiInstance).getSubtitle();
        }
        return "";
    }

    private String getTitle(Object uiInstance) {
        if (uiInstance instanceof Result) {
            return null;
        }
        if (uiInstance instanceof HasTitle) {
            return ((HasTitle)uiInstance).getTitle();
        }
        return this.reflectionHelper.getCaption(uiInstance);
    }

    private Object getActualUiInstance(JourneyContainer journeyContainer, String stepId, Object uiInstance, ServerHttpRequest serverHttpRequest) throws Exception {
        Object actualUiInstance = uiInstance;
        if (uiInstance instanceof EntityEditor) {
            EntityEditor entityEditor = (EntityEditor)uiInstance;
            actualUiInstance = this.em.find(entityEditor.getEntityClass(), entityEditor.getData().get("__id"));
        } else if (uiInstance instanceof ObjectEditor) {
            ObjectEditor objectEditor = (ObjectEditor)uiInstance;
            actualUiInstance = this.serializer.fromJson(this.serializer.toJson(objectEditor.getData()), objectEditor.getType());
        } else if (uiInstance instanceof FieldEditor) {
            FieldEditor fieldEditor = (FieldEditor)uiInstance;
            actualUiInstance = this.serializer.fromJson(this.serializer.toJson(fieldEditor.getData()), fieldEditor.getType());
        } else if (uiInstance instanceof MethodParametersEditor) {
            MethodParametersEditor fieldEditor = (MethodParametersEditor)uiInstance;
        } else if (("view".equals(stepId) || "edit".equals(stepId)) && journeyContainer.getInitialStep() != null && "io.mateu.mdd.ui.cruds.JpaRpcCrudView".equals(journeyContainer.getInitialStep().getType())) {
            RpcCrudViewExtended rpcCrudView = (RpcCrudViewExtended)((JourneyStoreService)this.applicationContext.getBean(JourneyStoreService.class)).getViewInstance(journeyContainer.getJourneyId(), journeyContainer.getInitialStep().getId(), serverHttpRequest);
            actualUiInstance = this.em.find(rpcCrudView.getEntityClass(), ((EntityEditor)uiInstance).getData().get("id"));
        } else if (uiInstance instanceof Class && Listing.class.isAssignableFrom((Class)uiInstance)) {
            actualUiInstance = this.reflectionHelper.newInstance((Class)uiInstance);
        }
        return actualUiInstance;
    }

    private void addComponentIds(List<Component> left, List<Component> main, List<Component> right, List<Rule> rules) {
        int i = 0;
        for (Component component : List.of(left, main, right).stream().flatMap(l -> l.stream()).collect(Collectors.toList())) {
            component.setId("component-" + i++);
            if (component.getMetadata() instanceof Crud) {
                Crud crud = (Crud)component.getMetadata();
                crud.getActions().forEach(action -> action.setId(component.getId() + "___" + action.getId()));
            }
            if (!(component.getMetadata() instanceof Form)) continue;
            Form form = (Form)component.getMetadata();
            Stream.concat(form.getActions().stream(), form.getMainActions().stream()).forEach(action -> {
                rules.stream().filter(r -> RuleAction.HideAction.equals((Object)r.getAction()) || RuleAction.ShowAction.equals((Object)r.getAction()) || RuleAction.EnableAction.equals((Object)r.getAction()) || RuleAction.DisableAction.equals((Object)r.getAction())).filter(r -> action.getId().equals(((String[])r.getData())[0])).forEach(r -> r.setData((Object)new String[]{component.getId() + "___" + action.getId()}));
                action.setId(component.getId() + "___" + action.getId());
            });
        }
    }
}

