/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.commands.runStepAction;

import com.google.common.base.Strings;
import io.mateu.core.domain.apiClients.MateuRemoteClient;
import io.mateu.core.domain.commands.runStepAction.ActionRunner;
import io.mateu.core.domain.commands.runStepAction.ActualValueExtractor;
import io.mateu.core.domain.commands.runStepAction.RunStepActionCommand;
import io.mateu.core.domain.model.editors.EntityEditor;
import io.mateu.core.domain.model.editors.FieldEditor;
import io.mateu.core.domain.model.editors.ObjectEditor;
import io.mateu.core.domain.model.store.JourneyContainer;
import io.mateu.core.domain.model.store.JourneyStoreService;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.remote.dtos.Form;
import io.mateu.remote.dtos.Step;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import reactor.core.publisher.Mono;

@Service
public class RunStepActionCommandHandler {
    private static final Logger log = LoggerFactory.getLogger(RunStepActionCommandHandler.class);
    final JourneyStoreService store;
    final MateuRemoteClient mateuRemoteClient;
    final List<ActionRunner> actionRunners;
    final ActualValueExtractor actualValueExtractor;
    final ReflectionHelper reflectionHelper;

    @Transactional
    public Mono<Void> handle(RunStepActionCommand command) throws Throwable {
        String journeyId = command.getJourneyId();
        String stepId = command.getStepId();
        String actionId = command.getActionId();
        Map<String, Object> data = command.getData();
        ServerHttpRequest serverHttpRequest = command.getServerHttpRequest();
        JourneyContainer journeyContainer = this.store.findJourneyById(journeyId).orElse(null);
        if (journeyContainer == null) {
            throw new Exception("No journey with id " + journeyId);
        }
        if (!Strings.isNullOrEmpty((String)journeyContainer.getRemoteJourneyTypeId())) {
            return this.mateuRemoteClient.runStep(journeyContainer.getRemoteBaseUrl(), journeyContainer.getRemoteJourneyTypeId(), journeyContainer.getJourneyId(), stepId, actionId, data, serverHttpRequest);
        }
        Object viewInstance = this.store.getViewInstance(journeyId, stepId, serverHttpRequest);
        if (!(viewInstance instanceof FieldEditor || viewInstance instanceof ObjectEditor || viewInstance instanceof EntityEditor)) {
            data.entrySet().forEach(entry -> {
                try {
                    Object actualValue = this.actualValueExtractor.getActualValue((Map.Entry<String, Object>)entry, viewInstance);
                    this.reflectionHelper.setValue((String)entry.getKey(), viewInstance, actualValue);
                }
                catch (Exception ex) {
                    System.out.println(ex.getClass().getSimpleName() + ": " + ex.getMessage());
                }
            });
        }
        Step step = this.store.readStep(journeyId, stepId);
        step.mergeData(data);
        this.store.updateStep(journeyId, stepId, step);
        String componentId = "component-0";
        if (actionId.contains("___")) {
            componentId = actionId.substring(0, actionId.indexOf("___"));
            actionId = actionId.substring(actionId.indexOf("___") + "___".length());
        }
        if (!"component-0".equals(componentId)) {
            // empty if block
        }
        for (ActionRunner actionRunner : this.actionRunners) {
            if (!actionRunner.applies(viewInstance, actionId)) continue;
            return actionRunner.run(viewInstance, journeyId, stepId, actionId, data, serverHttpRequest).then(Mono.deferContextual(contextView -> {
                String activeTabId = (String)command.getData().get("__activeTabId");
                try {
                    Step stepAfterRun = this.store.readStep(journeyId, stepId);
                    stepAfterRun.getView().getMain().getComponents().stream().map(c -> c.getMetadata()).filter(m -> m instanceof Form).map(m -> (Form)m).flatMap(f -> f.getTabs().stream()).forEach(t -> t.setActive(!Strings.isNullOrEmpty((String)activeTabId) && activeTabId.equals(t.getId())));
                    this.store.updateStep(journeyId, stepId, stepAfterRun);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                return Mono.empty();
            }));
        }
        throw new Exception("Unknown action " + actionId);
    }

    public RunStepActionCommandHandler(JourneyStoreService store, MateuRemoteClient mateuRemoteClient, List<ActionRunner> actionRunners, ActualValueExtractor actualValueExtractor, ReflectionHelper reflectionHelper) {
        this.store = store;
        this.mateuRemoteClient = mateuRemoteClient;
        this.actionRunners = actionRunners;
        this.actualValueExtractor = actualValueExtractor;
        this.reflectionHelper = reflectionHelper;
    }
}

