/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain;

import io.mateu.core.domain.model.files.StorageService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.naming.AuthenticationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class UploadService {
    @Autowired
    StorageService storageService;

    public ResponseEntity<Resource> serveFile(String fileId, String filename) throws AuthenticationException {
        Resource file = this.storageService.loadAsResource(fileId, filename);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"" + file.getFilename() + "\""})).body((Object)file);
    }

    public String getFileUrl(String fileId, String fileName) throws AuthenticationException {
        return this.storageService.getUrl(fileId, fileName);
    }

    public Mono<Void> handleFileUpload(String fileId, Mono<FilePart> file) throws AuthenticationException, ExecutionException, InterruptedException, TimeoutException {
        return this.storageService.store(fileId, file);
    }
}

