/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.queries.getUI;

import io.mateu.core.application.NotFoundException;
import io.mateu.core.domain.model.modelToDtoMappers.UIMapper;
import io.mateu.core.domain.queries.getUI.GetUIQuery;
import io.mateu.mdd.core.interfaces.DynamicUI;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.remote.dtos.UI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;

@Service
public class GetUIQueryHandler {
    private static final Logger log = LoggerFactory.getLogger(GetUIQueryHandler.class);
    final UIMapper uiMapper;
    final ReflectionHelper reflectionHelper;

    public UI run(GetUIQuery query, ServerHttpRequest serverHttpRequest) {
        String uiId = query.getUiId();
        try {
            Class<?> uiClass = Class.forName(uiId);
            Object uiInstance = this.reflectionHelper.newInstance(uiClass);
            if (uiInstance == null) {
                throw new Exception();
            }
            if (uiInstance instanceof DynamicUI) {
                return (UI)((DynamicUI)uiInstance).build().toFuture().get();
            }
            UI ui = this.uiMapper.map(uiInstance, serverHttpRequest);
            return ui;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("error on getUi", (Throwable)e);
            throw new NotFoundException("No class with name " + uiId + " found");
        }
    }

    public GetUIQueryHandler(UIMapper uiMapper, ReflectionHelper reflectionHelper) {
        this.uiMapper = uiMapper;
        this.reflectionHelper = reflectionHelper;
    }
}

