/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.queries.getJourney;

import com.google.common.base.Strings;
import io.mateu.core.domain.apiClients.MateuRemoteClient;
import io.mateu.core.domain.model.store.JourneyContainer;
import io.mateu.core.domain.model.store.JourneyStoreService;
import io.mateu.core.domain.queries.getJourney.GetJourneyQuery;
import io.mateu.remote.dtos.Journey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class GetJourneyQueryHandler {
    private static final Logger log = LoggerFactory.getLogger(GetJourneyQueryHandler.class);
    @Autowired
    JourneyStoreService store;
    @Autowired
    MateuRemoteClient mateuRemoteClient;

    public Mono<Journey> run(GetJourneyQuery query) throws Exception {
        String journeyId = query.getJourneyId();
        JourneyContainer journeyContainer = this.store.findJourneyById(journeyId).orElse(null);
        if (journeyContainer == null) {
            throw new Exception("No journey with id " + journeyId);
        }
        if (!Strings.isNullOrEmpty((String)journeyContainer.getRemoteJourneyTypeId())) {
            return this.mateuRemoteClient.getJourney(journeyContainer.getRemoteBaseUrl(), journeyContainer.getRemoteJourneyTypeId(), journeyContainer.getJourneyId(), query.getServerHttpRequest());
        }
        return Mono.just((Object)this.store.getJourney(journeyId));
    }
}

