/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.metadataBuilders.fields;

import io.mateu.core.domain.model.files.FileChecker;
import io.mateu.core.domain.model.metadataBuilders.fields.FieldTypeMapper;
import io.mateu.mdd.shared.annotations.ItemsProvider;
import io.mateu.mdd.shared.annotations.Output;
import io.mateu.mdd.shared.annotations.ReadOnly;
import io.mateu.mdd.shared.annotations.UseCrud;
import io.mateu.mdd.shared.annotations.ValuesProvider;
import io.mateu.mdd.shared.annotations.ValuesProviderMethod;
import io.mateu.mdd.shared.annotations.Width;
import io.mateu.mdd.shared.data.ExternalReference;
import io.mateu.mdd.shared.data.TelephoneNumber;
import io.mateu.mdd.shared.data.ValuesListProvider;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.remote.dtos.Column;
import io.mateu.remote.dtos.Pair;
import io.mateu.remote.dtos.TelephonePrefix;
import io.mateu.remote.dtos.Value;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class FieldAttributeBuilder {
    final FileChecker fileChecker;
    final FieldTypeMapper fieldTypeMapper;
    final ReflectionHelper reflectionHelper;

    public List<Pair> buildAttributes(Object view, FieldInterfaced field) {
        ArrayList<Pair> attributes = new ArrayList<Pair>();
        if (TelephoneNumber.class.equals(field.getType())) {
            List<TelephonePrefix> prefixes = List.of(TelephonePrefix.builder().key("es").img("https://flagcdn.com/es.svg").value((Object)"+34").build(), TelephonePrefix.builder().key("de").img("https://flagcdn.com/de.svg").value((Object)"+49").build(), TelephonePrefix.builder().key("us").img("https://flagcdn.com/us.svg").value((Object)"+1").build(), TelephonePrefix.builder().key("uy").img("https://flagcdn.com/uy.svg").value((Object)"+598").build());
            prefixes.forEach(v -> attributes.add(Pair.builder().key("prefix").value(v).build()));
        }
        if (field.isAnnotationPresent(Width.class)) {
            attributes.add(Pair.builder().key("width").value((Object)field.getAnnotation(Width.class).value()).build());
        }
        if (field.isAnnotationPresent(ItemsProvider.class)) {
            attributes.add(Pair.builder().key("itemprovider").value((Object)field.getAnnotation(ItemsProvider.class).value().getName()).build());
        }
        if (field.isAnnotationPresent(ManyToOne.class)) {
            attributes.add(Pair.builder().key("itemprovider").value((Object)field.getType().getName()).build());
        }
        if ((field.isAnnotationPresent(OneToMany.class) || field.isAnnotationPresent(ManyToMany.class)) && !field.isAnnotationPresent(UseCrud.class)) {
            attributes.add(Pair.builder().key("itemprovider").value((Object)field.getGenericClass().getName()).build());
        }
        if (field.isAnnotationPresent(ValuesProvider.class)) {
            try {
                ValuesListProvider provider = this.reflectionHelper.newInstance(field.getAnnotation(ValuesProvider.class).value());
                provider.getAll().forEach(v -> attributes.add(Pair.builder().key("choice").value((Object)Value.builder().key("" + v).value(v).build()).build()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (field.isAnnotationPresent(ValuesProviderMethod.class)) {
            try {
                Method m = this.reflectionHelper.getMethod(field.getDeclaringClass(), field.getAnnotation(ValuesProviderMethod.class).value());
                List choices = (List)m.invoke(view, new Object[0]);
                choices.forEach(v -> attributes.add(Pair.builder().key("choice").value((Object)Value.builder().key(v.getKey()).value(v.getValue()).build()).build()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.fileChecker.isFile(field)) {
            attributes.add(Pair.builder().key("fileidprefix").value((Object)"mateuremoteistheremoteflavourofmateu").build());
            if (List.class.isAssignableFrom(field.getType()) || field.getType().isArray()) {
                attributes.add(Pair.builder().key("maxfiles").value((Object)3).build());
            } else {
                attributes.add(Pair.builder().key("maxfiles").value((Object)1).build());
            }
        }
        if (field.getType().isEnum() || field.getType().isArray() && field.getType().getComponentType().isEnum() || List.class.isAssignableFrom(field.getType()) && field.getGenericClass().isEnum()) {
            Class<?> enumType = field.getType();
            if (enumType.isArray()) {
                enumType = enumType.getComponentType();
            }
            if (List.class.isAssignableFrom(enumType)) {
                enumType = field.getGenericClass();
            }
            Method m = null;
            try {
                m = enumType.getMethod("valueOf", null);
                for (Object enumConstant : enumType.getEnumConstants()) {
                    Object value = m.invoke(enumConstant, (Object[])null);
                    attributes.add(Pair.builder().key("choice").value((Object)Value.builder().key(enumConstant.toString()).value(value).build()).build());
                }
            }
            catch (Exception e) {
                for (Object enumConstant : enumType.getEnumConstants()) {
                    attributes.add(Pair.builder().key("choice").value((Object)Value.builder().key(enumConstant.toString()).value(enumConstant).build()).build());
                }
            }
        }
        if (Collection.class.isAssignableFrom(field.getType())) {
            if (!(ReflectionHelper.isBasico(field.getType()) || ExternalReference.class.equals(field.getGenericClass()) || field.getGenericClass().isEnum())) {
                for (FieldInterfaced columnField : this.reflectionHelper.getAllEditableFields(field.getGenericClass())) {
                    attributes.add(Pair.builder().key("column").value((Object)Column.builder().id(columnField.getId()).caption(this.reflectionHelper.getCaption(columnField)).type(this.fieldTypeMapper.mapColumnType(columnField)).readOnly(this.isReadOnly(columnField)).stereotype("column").attributes(List.of()).width(this.fieldTypeMapper.getWidth(columnField)).build()).build());
                }
            }
        }
        return attributes;
    }

    private boolean isReadOnly(FieldInterfaced field) {
        return field.isAnnotationPresent(ReadOnly.class) || field.isAnnotationPresent(Output.class);
    }

    public FieldAttributeBuilder(FileChecker fileChecker, FieldTypeMapper fieldTypeMapper, ReflectionHelper reflectionHelper) {
        this.fileChecker = fileChecker;
        this.fieldTypeMapper = fieldTypeMapper;
        this.reflectionHelper = reflectionHelper;
    }
}

