/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.commands.runStepAction.concreteStepActionRunners;

import io.mateu.core.domain.commands.runStepAction.ActionRunner;
import io.mateu.core.domain.commands.runStepAction.concreteStepActionRunners.ValidationService;
import io.mateu.core.domain.model.editors.FieldEditor;
import io.mateu.core.domain.model.store.JourneyStoreService;
import io.mateu.remote.dtos.Step;
import io.mateu.util.Serializer;
import java.util.Map;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class FieldEditorSaveActionRunner
implements ActionRunner {
    final JourneyStoreService store;
    final Serializer serializer;
    final ValidationService validationService;

    @Override
    public boolean applies(Object viewInstance, String actionId) {
        return viewInstance instanceof FieldEditor && "save".equals(actionId);
    }

    @Override
    public Mono<Void> run(Object viewInstance, String journeyId, String stepId, String actionId, Map<String, Object> data, ServerHttpRequest serverHttpRequest) throws Throwable {
        FieldEditor fieldEditor = (FieldEditor)viewInstance;
        Step initialStep = this.store.readStep(journeyId, fieldEditor.getInitialStep());
        Object object = this.serializer.fromJson(this.serializer.toJson(data), fieldEditor.getType());
        this.validationService.validate(object);
        data = this.serializer.toMap(object);
        data.put("__toString", "" + object);
        initialStep.getData().put(fieldEditor.getFieldId(), data);
        this.store.backToStep(journeyId, initialStep.getId());
        return Mono.empty();
    }

    public FieldEditorSaveActionRunner(JourneyStoreService store, Serializer serializer, ValidationService validationService) {
        this.store = store;
        this.serializer = serializer;
        this.validationService = validationService;
    }
}

