/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.util.servlet.common;

import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    public static boolean isEmpty(String s) {
        return s == null || "".equals(s.trim());
    }

    public static String read(InputStream is) {
        return Utils.read(is, "utf-8");
    }

    private static String read(InputStream is, String encoding) {
        StringBuffer s = new StringBuffer();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(is, encoding));
            String l = null;
            boolean primeraLinea = true;
            while ((l = br.readLine()) != null) {
                if (primeraLinea) {
                    primeraLinea = false;
                } else {
                    s.append("\n");
                }
                s.append(l);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return s.toString();
    }

    public static void write(String fn, byte[] bytes) {
        File f = new File(fn);
        Utils.write(f, bytes);
    }

    public static void write(File f, byte[] bytes) {
        log.debug("writing " + f.getAbsolutePath());
        try {
            if (!f.getParentFile().exists()) {
                f.getParentFile().mkdirs();
            }
            FileOutputStream w = new FileOutputStream(f);
            w.write(bytes);
            w.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static byte[] readBytes(String fn) throws IOException {
        return Utils.readBytes(new File(fn));
    }

    public static byte[] readBytes(File f) throws IOException {
        log.debug("reading " + f.getAbsolutePath());
        return Files.asByteSource((File)f).read();
    }

    public static byte[] readBytes(URL url) throws IOException {
        return Resources.asByteSource((URL)url).read();
    }
}

