/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.util.data;

import io.mateu.util.Serializer;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class Data
extends HashMap<String, Object> {
    public Data() {
        this.put("__id", "" + UUID.randomUUID());
    }

    public Data(String json) throws IOException {
        super(Serializer.fromJson(json));
        this.put("__id", "" + UUID.randomUUID());
    }

    public Data(Data other) {
        this.copy(other);
        this.put("__id", "" + UUID.randomUUID());
    }

    public Data(Object ... args) {
        if (args != null && args.length == 1 && args[0] != null && Map.class.isAssignableFrom(args[0].getClass())) {
            this.copy((Map)args[0]);
            this.put("__id", "" + UUID.randomUUID());
        } else {
            int pos = 0;
            String n = null;
            if (args != null) {
                for (Object x : args) {
                    if (pos % 2 == 0) {
                        n = (String)x;
                    } else {
                        this.put(n, x);
                    }
                    ++pos;
                }
            }
        }
    }

    public Data strip(String ... ids) {
        Data d = new Data(this);
        for (String id : ids) {
            d.remove(id);
        }
        return d;
    }

    public List<Data> getSelection(String property) {
        ArrayList<Data> s = new ArrayList<Data>();
        for (Data x : this.getList(property)) {
            if (!x.getBoolean("_selected")) continue;
            s.add(x);
        }
        return s;
    }

    public String getString(String property) {
        Object v = this.get(property);
        return v != null ? "" + v : null;
    }

    public double getDouble(String property) {
        return this.containsKey(property) ? (Double)this.get(property) : 0.0;
    }

    public boolean getBoolean(String property) {
        return this.get(property) != null ? (Boolean)this.get(property) : false;
    }

    public Date getDate(String property) {
        Object d = this.get(property);
        if (d instanceof Long) {
            return new Date((Long)d);
        }
        return (Date)d;
    }

    public LocalDate getLocalDate(String property) {
        Object d = this.get(property);
        return (LocalDate)d;
    }

    public LocalDateTime getLocalDateTime(String property) {
        Object d = this.get(property);
        return (LocalDateTime)d;
    }

    public int getInt(String property) {
        return this.get(property) != null ? (Integer)this.get(property) : 0;
    }

    public long getLong(String property) {
        long l = 0L;
        Object o = this.get(property);
        if (o != null) {
            l = o instanceof Long ? ((Long)o).longValue() : new Long("" + o).longValue();
        }
        return l;
    }

    public List<Data> getList(String property) {
        ArrayList l = (ArrayList)this.get(property);
        if (l == null) {
            l = new ArrayList();
            this.set(property, l);
        }
        return l;
    }

    public Data getData(String property) {
        return (Data)this.get(property);
    }

    public void copy(Map<String, Object> original) {
        this.clear();
        if (original != null) {
            for (Map.Entry<String, Object> e : original.entrySet()) {
                if (e.getValue() instanceof List) {
                    List<Data> l = this.getList(e.getKey());
                    l.clear();
                    for (Object o : (List)e.getValue()) {
                        l.add((Data)this.auxCopy(o));
                    }
                    continue;
                }
                this.set(e.getKey(), this.auxCopy(e.getValue()));
            }
        }
    }

    public Object auxCopy(Object o) {
        Object c = null;
        c = o instanceof Data ? new Data((Data)o) : o;
        return c;
    }

    public <X> X set(String name, X value) {
        if (value != null && value instanceof Date) {
            value = new Date(((Date)value).getTime());
        }
        return this.put(name, value);
    }

    public <X> X get(String property) {
        return (X)super.get(property);
    }

    public <X> X get(String property, X valueWhenNull) {
        X x = this.get(property);
        return x != null ? x : valueWhenNull;
    }

    public boolean isEmpty(String property) {
        boolean empty;
        boolean bl = empty = this.get(property) == null;
        if (!empty) {
            Object x = this.get(property);
            empty = x instanceof String && "".equals(((String)x).trim());
        }
        return empty;
    }

    @Override
    public Object clone() {
        Data d = new Data(this);
        if (d.containsKey("__id")) {
            d.set("__id", "" + UUID.randomUUID());
        }
        return d;
    }

    @Override
    public int hashCode() {
        return this.get("__id").hashCode();
    }

    @Override
    public String toString() {
        if (this.containsKey("_text")) {
            return (String)this.get("_text");
        }
        if (this.containsKey("_nameproperty")) {
            return (String)this.get((String)this.get("_nameproperty"));
        }
        try {
            return Serializer.toJson(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toJson() throws Exception {
        return Serializer.toJson(this);
    }

    public void setAll(Data data) {
        if (data != null) {
            for (String k : data.keySet()) {
                this.set(k, data.get(k));
            }
        }
    }
}

