/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.util;

import com.github.slugify.Slugify;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.ObjectParser;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import io.mateu.mdd.shared.SlimHelper;
import io.mateu.util.Serializer;
import io.mateu.util.SharedHelper;
import io.mateu.util.xml.XMLSerializable;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Helper
extends SlimHelper {
    private static final Logger log = LoggerFactory.getLogger(Helper.class);
    private static ScriptEngineManager scriptEngineManager;
    static final HttpTransport HTTP_TRANSPORT;
    static final JsonFactory JSON_FACTORY;
    private static final int BUFFER = 2048;

    public static LocalDate toDate(int n) {
        return LocalDate.of((n - n % 10000) / 10000, (n % 10000 - n % 100) / 100, n % 100);
    }

    public static int toInt(LocalDate n) {
        return n.getDayOfMonth() + n.getMonthValue() * 100 + n.getYear() * 10000;
    }

    public static long dias(LocalDate start, LocalDate end) {
        return ChronoUnit.DAYS.between(start, end);
    }

    public static long noches(LocalDate start, LocalDate end) {
        return ChronoUnit.DAYS.between(start, end) - 1L;
    }

    public static boolean intersects(LocalDate start, LocalDate end, LocalDate checkIn, LocalDate checkOut) {
        return !(start != null && !start.isBefore(checkOut) || end != null && end.compareTo(checkIn) < 0);
    }

    public static boolean cabe(LocalDate validFrom, LocalDate validTo, LocalDate checkIn, LocalDate checkOut) {
        return validFrom.compareTo(checkIn) <= 0 && validTo.compareTo(checkOut) >= 0;
    }

    public static Map<String, Object> fromJson(String json) throws IOException {
        return Serializer.fromJson(json);
    }

    public static <T> T fromJson(String json, Class<T> c) throws Exception {
        return Serializer.fromJson(json, c);
    }

    public static String toJson(Object o) throws Exception {
        return Serializer.toJson(o);
    }

    public static Map<String, Object> fromYaml(String yaml) throws IOException {
        return Serializer.fromYaml(yaml);
    }

    public static <T> T fromYaml(String yaml, Class<T> c) throws IOException {
        return Serializer.fromYaml(yaml, c);
    }

    public static String toYaml(Object o) throws IOException {
        return Serializer.toYaml(o);
    }

    public static String md5(String s) {
        return Hashing.sha256().newHasher().putString((CharSequence)s, Charsets.UTF_8).hash().toString();
    }

    public static URL whichJar(Class c) {
        return c.getProtectionDomain().getCodeSource().getLocation();
    }

    public static double roundEuros(double value) {
        return (double)Math.round(value * 100.0) / 100.0;
    }

    public static String formatEuros(double value) {
        return new DecimalFormat("##,###,###,###,###,###.00").format(value);
    }

    public static String httpGet(String url) throws IOException {
        log.debug("HTTP GET " + url);
        HttpRequestFactory requestFactory = HTTP_TRANSPORT.createRequestFactory(new HttpRequestInitializer(){

            public void initialize(HttpRequest request) {
                request.setParser((ObjectParser)new JsonObjectParser(JSON_FACTORY));
            }
        });
        HttpRequest request = requestFactory.buildGetRequest(new GenericUrl(url));
        return request.execute().parseAsString();
    }

    public static String httpPost(String url, Map<String, String> parameters) throws IOException {
        log.debug("HTTP POST " + url);
        HttpRequestFactory requestFactory = HTTP_TRANSPORT.createRequestFactory(new HttpRequestInitializer(){

            public void initialize(HttpRequest request) {
                request.setParser((ObjectParser)new JsonObjectParser(JSON_FACTORY));
            }
        });
        HttpRequest request = requestFactory.buildPostRequest(new GenericUrl(url), (HttpContent)new UrlEncodedContent((Object)""));
        return request.execute().parseAsString();
    }

    public static int max(int ... values) {
        int max = Integer.MIN_VALUE;
        for (int value : values) {
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return LocalDateTime.of(c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13));
    }

    public static LocalDate toLocalDate(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return LocalDate.of(c.get(1), c.get(2) + 1, c.get(5));
    }

    public static Map<String, Object> hashmap(Object ... args) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        int pos = 0;
        Object o0 = null;
        for (Object o : args) {
            if (pos > 0 && pos % 2 == 1) {
                m.put("" + o0, o);
            } else {
                o0 = o;
            }
            ++pos;
        }
        return m;
    }

    public static double roundOffEuros(double v) {
        return (double)Math.round(100.0 * v) / 100.0;
    }

    public static int toInt(String s) {
        int v = 0;
        try {
            v = Integer.parseInt(s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return v;
    }

    public static int[] toIntArray(String s) {
        if (s == null) {
            return null;
        }
        if ("".equals(s.trim())) {
            return new int[0];
        }
        String[] ts = s.replace("[", "").replace("]", "").split(",");
        int[] r = new int[ts.length];
        for (int pos = 0; pos < ts.length; ++pos) {
            r[pos] = Integer.parseInt(ts[pos]);
        }
        return r;
    }

    public static String leerFichero(Class c, String p) {
        String s = "";
        InputStream input = c.getResourceAsStream(p);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        long count = 0L;
        int n = 0;
        try {
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
                count += (long)n;
            }
            s = new String(output.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return s;
    }

    public static String leerInputStream(InputStream is, String encoding) {
        StringBuffer s = new StringBuffer();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(is, encoding));
            String l = null;
            boolean primeraLinea = true;
            while ((l = br.readLine()) != null) {
                if (primeraLinea) {
                    primeraLinea = false;
                } else {
                    s.append("\n");
                }
                s.append(l);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return s.toString();
    }

    public static String leerFichero(InputStream input, String codificacion) {
        String s = "";
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        long count = 0L;
        int n = 0;
        try {
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
                count += (long)n;
            }
            s = new String(output.toByteArray(), codificacion);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return s;
    }

    public static String leerFichero(InputStream is) throws IOException {
        int count;
        byte[] data = new byte[2048];
        ByteArrayOutputStream dest = new ByteArrayOutputStream();
        while ((count = is.read(data, 0, 2048)) != -1) {
            dest.write(data, 0, count);
        }
        dest.flush();
        dest.close();
        return new String(dest.toByteArray());
    }

    public static String leerFichero(String fn, String encoding) {
        String s = "";
        byte[] buffer = new byte[(int)new File(fn).length()];
        try {
            BufferedInputStream f = new BufferedInputStream(new FileInputStream(fn));
            f.read(buffer);
            f.close();
            s = new String(buffer, encoding);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return s;
    }

    public static String leerFichero(String fn) {
        String s = "";
        byte[] buffer = new byte[(int)new File(fn).length()];
        try (BufferedInputStream f = new BufferedInputStream(new FileInputStream(fn));){
            f.read(buffer);
            f.close();
            s = new String(buffer);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return s;
    }

    public static void escribirFichero(String fn, byte[] bytes) throws IOException {
        File f = new File(fn);
        Files.write((byte[])bytes, (File)f);
    }

    public static void escribirFichero(String fn, String txt) throws IOException {
        Helper.escribirFichero(fn, txt.getBytes());
    }

    public static byte[] leerByteArray(InputStream is) {
        byte[] data = new byte[2048];
        ByteArrayOutputStream dest = new ByteArrayOutputStream();
        try {
            int count;
            while ((count = is.read(data, 0, 2048)) != -1) {
                dest.write(data, 0, count);
            }
            dest.flush();
            dest.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return dest.toByteArray();
    }

    public static double toDouble(String s) {
        double v = 0.0;
        try {
            v = Double.parseDouble(s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return v;
    }

    public static Map<String, String> parseQueryString(String query) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (!Strings.isNullOrEmpty((String)query)) {
            for (String t : query.split("&")) {
                if (Strings.isNullOrEmpty((String)t)) continue;
                String[] q = t.split("=");
                params.put(q[0], q.length > 1 ? q[1] : null);
            }
        }
        return params;
    }

    public static String runCommand(String command) throws IOException, InterruptedException {
        String homeDirectory = System.getProperty("user.home");
        String[] cmd = new String[]{"/bin/sh", "-c", command};
        String[] wcmd = new String[]{"cmd", "/c", command};
        Process process = Runtime.getRuntime().exec(System.getProperty("os.name").toLowerCase().contains("win") ? wcmd : cmd);
        String r = Helper.leerInputStream(process.getInputStream(), "utf-8");
        String e = Helper.leerInputStream(process.getErrorStream(), "utf-8");
        int exitCode = process.waitFor();
        return r + e;
    }

    public static String toHtml(String s) {
        if (!Strings.isNullOrEmpty((String)s)) {
            return s.replaceAll("\\\n", "<br/>");
        }
        return s;
    }

    public static Object get(Map<String, Object> data, String key) {
        return Helper.get(data, key, null);
    }

    public static Object get(Map<String, Object> data, String key, Object defaultValue) {
        if (data == null) {
            return defaultValue;
        }
        Object v = defaultValue;
        Map d = data;
        String[] ks = key.split("/");
        int pos = 0;
        for (String k : ks) {
            if (!d.containsKey(k)) break;
            if (pos == ks.length - 1) {
                v = d.get(k);
                continue;
            }
            Object aux = d.get(k);
            if (!(aux instanceof Map)) break;
            d = (Map)aux;
            ++pos;
        }
        return v;
    }

    public static <T> T getImpl(Class<T> c) throws Exception {
        return SharedHelper.getImpl(c);
    }

    public static <T> List<T> getImpls(Class<T> c) throws Exception {
        return SharedHelper.getImpls(c);
    }

    public static void main(String[] args) {
        try {
            log.debug(Helper.toJson(Helper.fromYaml(Files.toString((File)new File("/home/miguel/work/initialdata.yml"), (Charset)Charset.defaultCharset()))));
            Map<String, Object> o = Helper.fromYaml(Files.toString((File)new File("/home/miguel/work/initialdata.yml"), (Charset)Charset.defaultCharset()));
            log.debug("" + Helper.get(o, "smtp/host"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String toString(Element element) {
        if (element == null) {
            return "";
        }
        return new XMLOutputter(Format.getPrettyFormat()).outputString(element);
    }

    public static boolean areXmlSerializableEqual(XMLSerializable a, XMLSerializable b) {
        return a == b || b != null && Helper.toString(a.toXml()).equals(Helper.toString(b.toXml()));
    }

    public static boolean equals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null && b != null) {
            return false;
        }
        if (a != null && b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static String eval(String operations) {
        return Helper.eval("nashorn", operations, null);
    }

    public static String eval(String engineName, String operations, Map<String, Object> params) {
        long t0 = System.currentTimeMillis();
        ScriptEngine engine = scriptEngineManager.getEngineByName(engineName);
        ScriptContext context = engine.getContext();
        if (params != null) {
            params.forEach((k, v) -> engine.put((String)k, v));
        }
        StringWriter writer = new StringWriter();
        context.setWriter(writer);
        long t1 = System.currentTimeMillis();
        try {
            writer.append("" + engine.eval(operations));
        }
        catch (ScriptException e) {
            writer.append(e.getMessage());
        }
        String output = writer.toString();
        return output;
    }

    public static String encodeState(String s) {
        return s.replaceAll("/", "YP9LKQ");
    }

    public static String toString(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    public static String urlize(String s) {
        return new Slugify().slugify(s);
    }

    static {
        SharedHelper.loadProperties();
        scriptEngineManager = new ScriptEngineManager(ClassLoader.getSystemClassLoader());
        HTTP_TRANSPORT = new NetHttpTransport();
        JSON_FACTORY = new JacksonFactory();
    }
}

