/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.shared.reflection;

import io.mateu.mdd.shared.interfaces.Listing;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.reflection.ReflectionHelper;
import java.lang.constant.Constable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CoreReflectionHelper {
    public static Object invokeInjectableParametersOnly(Method method, Object instance) throws Throwable {
        return CoreReflectionHelper.execute(method, new Object(), instance, null);
    }

    public static Object execute(Method m, Object parameters, Object instance, Set pendingSelection) throws Throwable {
        Object o = parameters;
        Map<String, Object> params = null;
        if (o != null && Map.class.isAssignableFrom(o.getClass())) {
            params = (Map)o;
        } else if (o != null) {
            params = new HashMap();
            for (FieldInterfaced f : ReflectionHelper.getAllEditableFields(o.getClass())) {
                params.put(f.getName(), ReflectionHelper.getValue(f, o));
            }
        }
        ArrayList<Object> vs = new ArrayList<Object>();
        int pos = 0;
        for (Parameter p : m.getParameters()) {
            Class<?> pgc = ReflectionHelper.getGenericClass(p.getParameterizedType());
            if ((instance instanceof Listing || Modifier.isStatic(m.getModifiers())) && Set.class.isAssignableFrom(p.getType()) && (m.getDeclaringClass().equals(pgc) || instance instanceof Listing && ReflectionHelper.getGenericClass(instance.getClass(), Listing.class, "C").equals(pgc)) || pendingSelection != null && Set.class.isAssignableFrom(p.getType())) {
                vs.add(pendingSelection);
            } else if (params != null && params.containsKey(p.getName())) {
                vs.add(params.get(p.getName()));
            } else if (o != null && ReflectionHelper.getFieldByName(o.getClass(), p.getName()) != null) {
                vs.add(ReflectionHelper.getValue(ReflectionHelper.getFieldByName(o.getClass(), p.getName()), o));
            } else {
                Constable v = null;
                if (Integer.TYPE.equals(p.getType())) {
                    v = 0;
                }
                if (Long.TYPE.equals(p.getType())) {
                    v = 0L;
                }
                if (Float.TYPE.equals(p.getType())) {
                    v = Float.valueOf(0.0f);
                }
                if (Double.TYPE.equals(p.getType())) {
                    v = 0.0;
                }
                if (Boolean.TYPE.equals(p.getType())) {
                    v = Boolean.valueOf(false);
                }
                vs.add(v);
            }
            ++pos;
        }
        Object[] args = vs.toArray();
        if (!Modifier.isStatic(m.getModifiers()) && instance == null) {
            instance = ReflectionHelper.newInstance(m.getDeclaringClass());
        }
        if (instance != null && !Modifier.isPublic(instance.getClass().getModifiers())) {
            m.setAccessible(true);
        } else if (!Modifier.isPublic(m.getModifiers())) {
            m.setAccessible(true);
        }
        return m.invoke(instance, args);
    }
}

