/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.queries.getUI;

import io.mateu.core.application.NotFoundException;
import io.mateu.core.domain.model.modelToDtoMappers.UIMapper;
import io.mateu.core.domain.queries.getUI.GetUIQuery;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.remote.dtos.UI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;

@Service
public class GetUIQueryHandler {
    private static final Logger log = LoggerFactory.getLogger(GetUIQueryHandler.class);
    @Autowired
    UIMapper uiMapper;

    public UI run(GetUIQuery query, ServerHttpRequest serverHttpRequest) {
        String uiId = query.getUiId();
        try {
            Class<?> uiClass = Class.forName(uiId);
            Object uiInstance = ReflectionHelper.newInstance(uiClass);
            if (uiInstance == null) {
                throw new Exception();
            }
            UI ui = this.uiMapper.map(uiInstance, serverHttpRequest);
            return ui;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("error on getUi", (Throwable)e);
            throw new NotFoundException("No class with name " + uiId + " found");
        }
    }
}

