/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.queries.getListRows;

import com.google.common.base.Strings;
import io.mateu.core.domain.apiClients.MateuRemoteClient;
import io.mateu.core.domain.model.store.JourneyContainer;
import io.mateu.core.domain.model.store.JourneyStoreService;
import io.mateu.core.domain.queries.FiltersDeserializer;
import io.mateu.core.domain.queries.getListRows.GetListRowsQuery;
import io.mateu.mdd.shared.interfaces.Listing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import reactor.core.publisher.Flux;

@Service
public class GetListRowsQueryHandler {
    private static final Logger log = LoggerFactory.getLogger(GetListRowsQueryHandler.class);
    @Autowired
    JourneyStoreService store;
    @Autowired
    MateuRemoteClient mateuRemoteClient;

    @Transactional
    public Flux<Object> run(GetListRowsQuery query) throws Throwable {
        JourneyContainer journeyContainer = this.store.findJourneyById(query.getJourneyId()).orElse(null);
        if (journeyContainer == null) {
            throw new Exception("No journey with id " + query.getJourneyId());
        }
        if (!Strings.isNullOrEmpty((String)journeyContainer.getRemoteJourneyTypeId())) {
            return this.mateuRemoteClient.getListRows(journeyContainer.getRemoteBaseUrl(), journeyContainer.getRemoteJourneyTypeId(), journeyContainer.getJourneyId(), query.getStepId(), query.getListId(), query.getFilters(), query.getOrdering(), query.getPage() * query.getPageSize(), (query.getPage() + 1) * query.getPageSize() - 1, query.getServerHttpRequest());
        }
        Object filtersDeserialized = new FiltersDeserializer(query.getJourneyId(), query.getStepId(), query.getListId(), query.getFilters(), query.getServerHttpRequest()).deserialize(this.store);
        Listing rpcView = this.store.getRpcViewInstance(query.getJourneyId(), query.getStepId(), query.getListId(), query.getServerHttpRequest());
        this.store.saveFilters(query.getJourneyId(), query.getStepId(), query.getListId(), filtersDeserialized);
        this.store.saveOrders(query.getJourneyId(), query.getStepId(), query.getListId(), query.getOrdering());
        if (rpcView == null) {
            return Flux.empty();
        }
        return rpcView.fetchRows(filtersDeserialized, query.getOrdering(), query.getPage() * query.getPageSize(), query.getPageSize());
    }
}

