/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.metadataBuilders;

import io.mateu.core.domain.model.editors.EntityEditor;
import io.mateu.core.domain.model.metadataBuilders.ActionMetadataBuilder;
import io.mateu.core.domain.model.metadataBuilders.FieldMetadataBuilder;
import io.mateu.mdd.core.interfaces.DynamicForm;
import io.mateu.mdd.core.interfaces.HasSubtitle;
import io.mateu.mdd.core.interfaces.HasTitle;
import io.mateu.mdd.core.interfaces.JpaRpcCrudFactory;
import io.mateu.mdd.core.interfaces.PersistentPojo;
import io.mateu.mdd.core.interfaces.ReadOnlyPojo;
import io.mateu.mdd.shared.annotations.Caption;
import io.mateu.mdd.shared.annotations.FieldGroup;
import io.mateu.mdd.shared.annotations.MainAction;
import io.mateu.mdd.shared.annotations.SameLine;
import io.mateu.mdd.shared.annotations.Section;
import io.mateu.mdd.shared.annotations.UseCrud;
import io.mateu.mdd.shared.data.StatusType;
import io.mateu.mdd.shared.interfaces.HasBadges;
import io.mateu.mdd.shared.interfaces.HasStatus;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.remote.dtos.Action;
import io.mateu.remote.dtos.ActionType;
import io.mateu.remote.dtos.Badge;
import io.mateu.remote.dtos.BadgeType;
import io.mateu.remote.dtos.FieldGroupLine;
import io.mateu.remote.dtos.Form;
import io.mateu.remote.dtos.SectionType;
import io.mateu.remote.dtos.Status;
import io.mateu.util.Helper;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToMany;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FormMetadataBuilder {
    private static final Logger log = LoggerFactory.getLogger(FormMetadataBuilder.class);
    @Autowired
    ActionMetadataBuilder actionMetadataBuilder;
    @Autowired
    FieldMetadataBuilder fieldMetadataBuilder;
    @Autowired
    JpaRpcCrudFactory jpaRpcCrudFactory;

    public Form build(String stepId, Object uiInstance, List<FieldInterfaced> slotFields) {
        if (uiInstance instanceof DynamicForm) {
            return (Form)((DynamicForm)uiInstance).build().toFuture().get();
        }
        Form form = Form.builder().title(this.getCaption(uiInstance)).subtitle(this.getSubtitle(uiInstance)).status(this.getStatus(uiInstance)).readOnly(this.isReadOnly(stepId, uiInstance)).badges(this.getBadges(uiInstance)).sections(this.getSections(stepId, uiInstance, slotFields)).actions(this.actionMetadataBuilder.getActions(stepId, "", uiInstance)).mainActions(this.getMainActions(stepId, uiInstance)).build();
        return form;
    }

    private boolean isReadOnly(String stepId, Object uiInstance) {
        return "view".equals(stepId) || uiInstance instanceof ReadOnlyPojo && !(uiInstance instanceof PersistentPojo) || uiInstance instanceof EntityEditor && this.hasCrud((EntityEditor)uiInstance) || uiInstance.getClass().isAnnotationPresent(Entity.class) && this.hasCrud(uiInstance.getClass());
    }

    private boolean hasCrud(EntityEditor entityEditor) {
        return this.hasCrud(entityEditor.getEntityClass());
    }

    private boolean hasCrud(Class entityClass) {
        return ReflectionHelper.getAllEditableFields(entityClass).stream().filter(f -> f.isAnnotationPresent(UseCrud.class)).count() > 0L;
    }

    public boolean isOwner(FieldInterfaced f) {
        return f.isAnnotationPresent(OneToMany.class) && Arrays.stream(f.getAnnotation(OneToMany.class).cascade()).filter(c -> CascadeType.ALL.equals(c) || CascadeType.PERSIST.equals(c)).count() > 0L || f.isAnnotationPresent(ManyToMany.class) && Arrays.stream(f.getAnnotation(ManyToMany.class).cascade()).filter(c -> CascadeType.ALL.equals(c) || CascadeType.PERSIST.equals(c)).count() > 0L && f.isAnnotationPresent(UseCrud.class);
    }

    private String getSubtitle(Object uiInstance) {
        if (uiInstance instanceof HasSubtitle) {
            return ((HasSubtitle)uiInstance).getSubtitle();
        }
        return null;
    }

    private Status getStatus(Object uiInstance) {
        if (!(uiInstance instanceof HasStatus)) {
            return null;
        }
        HasStatus hasStatus = (HasStatus)uiInstance;
        if (hasStatus.getStatus() == null) {
            return null;
        }
        return new Status(this.mapStatusType(hasStatus.getStatus().getType()), hasStatus.getStatus().getMessage());
    }

    private io.mateu.remote.dtos.StatusType mapStatusType(StatusType type) {
        return io.mateu.remote.dtos.StatusType.valueOf((String)type.toString());
    }

    private List<Badge> getBadges(Object uiInstance) {
        if (!(uiInstance instanceof HasBadges)) {
            return List.of();
        }
        return ((HasBadges)uiInstance).getBadges().stream().map(b -> new Badge(this.mapBadgeType(b.getType()), b.getMessage())).collect(Collectors.toList());
    }

    private BadgeType mapBadgeType(io.mateu.mdd.shared.data.BadgeType type) {
        return BadgeType.valueOf((String)type.toString());
    }

    private List<Action> getMainActions(String stepId, Object uiInstance) {
        List<Method> allMethods = ReflectionHelper.getAllMethods(uiInstance.getClass());
        List<Action> actions = allMethods.stream().filter(m -> m.isAnnotationPresent(MainAction.class)).sorted(Comparator.comparingInt(m -> m.getAnnotation(MainAction.class).order())).map(m -> this.actionMetadataBuilder.getAction((Method)m)).collect(Collectors.toList());
        if (!"view".equals(stepId) && (uiInstance instanceof PersistentPojo || uiInstance.getClass().isAnnotationPresent(Entity.class))) {
            Action action = Action.builder().id("cancel").caption(this.getCaptionForCancel(uiInstance)).type(ActionType.Secondary).validationRequired(false).visible(true).build();
            actions.add(action);
            action = Action.builder().id("save").caption(this.getCaptionForSave(uiInstance)).type(ActionType.Primary).validationRequired(true).visible(true).build();
            actions.add(action);
        }
        return actions;
    }

    private String getCaptionForCancel(Object uiInstance) {
        if (uiInstance instanceof PersistentPojo) {
            return ((PersistentPojo)uiInstance).getCaptionForCancel();
        }
        return "Cancel";
    }

    private String getCaptionForSave(Object uiInstance) {
        if (uiInstance instanceof PersistentPojo) {
            return ((PersistentPojo)uiInstance).getCaptionForSave();
        }
        return "Save";
    }

    private List<io.mateu.remote.dtos.Section> getSections(String stepId, Object uiInstance, List<FieldInterfaced> slotFields) {
        ArrayList<io.mateu.remote.dtos.Section> sections = new ArrayList<io.mateu.remote.dtos.Section>();
        io.mateu.remote.dtos.Section section = null;
        io.mateu.remote.dtos.FieldGroup fieldGroup = null;
        FieldGroupLine fieldGroupLine = null;
        List allEditableFields = ReflectionHelper.getAllEditableFields(uiInstance.getClass()).stream().filter(f -> !this.isOwner((FieldInterfaced)f)).filter(f -> slotFields.contains(f)).collect(Collectors.toList());
        for (FieldInterfaced fieldInterfaced : allEditableFields) {
            String caption;
            if (section == null || fieldInterfaced.isAnnotationPresent(Section.class)) {
                caption = "";
                String description = "";
                boolean card = true;
                if (fieldInterfaced.isAnnotationPresent(Section.class)) {
                    Section annotation = fieldInterfaced.getAnnotation(Section.class);
                    caption = annotation.value();
                    card = annotation.card();
                    description = annotation.description();
                }
                section = io.mateu.remote.dtos.Section.builder().caption(caption).readOnly("view".equals(stepId) || uiInstance instanceof ReadOnlyPojo && !(uiInstance instanceof PersistentPojo)).description(description).fieldGroups(new ArrayList()).type(card ? SectionType.Card : SectionType.Transparent).build();
                sections.add(section);
                fieldGroup = null;
            }
            if (fieldGroup == null || fieldInterfaced.isAnnotationPresent(FieldGroup.class)) {
                caption = "";
                if (fieldInterfaced.isAnnotationPresent(FieldGroup.class)) {
                    caption = fieldInterfaced.getAnnotation(FieldGroup.class).value();
                }
                fieldGroup = io.mateu.remote.dtos.FieldGroup.builder().caption(caption).lines(new ArrayList()).build();
                section.getFieldGroups().add(fieldGroup);
            }
            if (fieldGroupLine == null || !fieldInterfaced.isAnnotationPresent(SameLine.class)) {
                fieldGroupLine = FieldGroupLine.builder().fields(new ArrayList()).build();
                fieldGroup.getLines().add(fieldGroupLine);
            }
            fieldGroupLine.getFields().add(this.fieldMetadataBuilder.getField(uiInstance, fieldInterfaced));
        }
        this.fillSectionIds(sections);
        return sections;
    }

    private void fillSectionIds(List<io.mateu.remote.dtos.Section> sections) {
        int i = 0;
        for (io.mateu.remote.dtos.Section s : sections) {
            s.setId("section_" + i++);
            int j = 0;
            for (io.mateu.remote.dtos.FieldGroup g : s.getFieldGroups()) {
                g.setId("fieldgroup_" + i + "_" + j++);
            }
        }
    }

    private String getCaption(Object uiInstance) {
        if (uiInstance instanceof HasTitle) {
            return ((HasTitle)uiInstance).getTitle();
        }
        Class<?> modelType = uiInstance.getClass();
        if (modelType.isAnnotationPresent(Caption.class)) {
            return modelType.getAnnotation(Caption.class).value();
        }
        String viewTitle = "";
        if (uiInstance != null && uiInstance instanceof ReadOnlyPojo) {
            viewTitle = ((ReadOnlyPojo)uiInstance).retrieveEntityName();
        }
        if (uiInstance != null && uiInstance instanceof PersistentPojo) {
            viewTitle = ((PersistentPojo)uiInstance).retrieveEntityName();
            if (((PersistentPojo)uiInstance).isNewRecord()) {
                return "New " + viewTitle;
            }
        }
        Object prefix = "";
        if (!"".equals(viewTitle)) {
            prefix = viewTitle + " ";
        }
        try {
            if (Object.class.equals(modelType.getMethod("toString", new Class[0]).getDeclaringClass())) {
                return Helper.capitalize(modelType.getSimpleName());
            }
            return Helper.capitalize(uiInstance.toString());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return (String)prefix + uiInstance;
        }
    }
}

