/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.metadataBuilders;

import io.mateu.core.domain.model.metadataBuilders.ActionMetadataBuilder;
import io.mateu.core.domain.model.metadataBuilders.FieldMetadataBuilder;
import io.mateu.core.domain.model.metadataBuilders.fields.FieldTypeMapper;
import io.mateu.mdd.core.interfaces.DynamicCrud;
import io.mateu.mdd.core.interfaces.HasSubtitle;
import io.mateu.mdd.core.interfaces.HasTitle;
import io.mateu.mdd.core.interfaces.RpcCrudViewExtended;
import io.mateu.mdd.shared.annotations.Ignored;
import io.mateu.mdd.shared.interfaces.Listing;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.remote.dtos.Column;
import io.mateu.remote.dtos.Crud;
import io.mateu.remote.dtos.Field;
import io.mateu.remote.dtos.SearchForm;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CrudMetadataBuilder {
    @Autowired
    ActionMetadataBuilder actionMetadataBuilder;
    @Autowired
    FieldMetadataBuilder fieldMetadataBuilder;
    @Autowired
    FieldTypeMapper fieldTypeMapper;

    public Crud build(String stepId, String listId, Object crudInstance) {
        if (crudInstance instanceof DynamicCrud) {
            return (Crud)((DynamicCrud)crudInstance).build().toFuture().get();
        }
        Listing rpcView = (Listing)crudInstance;
        return Crud.builder().title(this.getTitle(rpcView)).subtitle(this.getSubtitle(rpcView)).canEdit(ReflectionHelper.isOverridden(rpcView, "getDetail")).searchForm(this.buildSearchForm(rpcView, listId)).columns(this.buildColumns(rpcView)).actions(this.actionMetadataBuilder.getActions(stepId, listId, rpcView)).listId(listId).build();
    }

    private String getSubtitle(Listing rpcView) {
        if (rpcView instanceof HasSubtitle) {
            return ((HasSubtitle)((Object)rpcView)).getSubtitle();
        }
        return null;
    }

    private String getTitle(Listing rpcView) {
        if (rpcView instanceof HasTitle) {
            return ((HasTitle)((Object)rpcView)).getTitle();
        }
        return rpcView.getCaption();
    }

    private List<Column> buildColumns(Listing rpcView) {
        Class rowClass = rpcView.getRowClass();
        HashMap<FieldInterfaced, String> columnIdsPerField = new HashMap<FieldInterfaced, String>();
        HashMap<FieldInterfaced, String> columnCaptionsPerField = new HashMap<FieldInterfaced, String>();
        List<FieldInterfaced> allRowFields = null;
        if (rpcView instanceof RpcCrudViewExtended) {
            allRowFields = ((RpcCrudViewExtended)((Object)rpcView)).getColumnFieldNames();
            columnIdsPerField.putAll(((RpcCrudViewExtended)((Object)rpcView)).getColumnIdsPerField());
            columnCaptionsPerField.putAll(((RpcCrudViewExtended)((Object)rpcView)).getColumnCaptionsPerField());
        } else {
            allRowFields = ReflectionHelper.getAllFields(rowClass);
        }
        return allRowFields.stream().filter(fieldInterfaced -> !fieldInterfaced.isAnnotationPresent(Ignored.class)).map(fieldInterfaced -> this.getColumn(columnIdsPerField.getOrDefault(fieldInterfaced, fieldInterfaced.getId()), columnCaptionsPerField.getOrDefault(fieldInterfaced, ReflectionHelper.getCaption(fieldInterfaced)), (FieldInterfaced)fieldInterfaced)).collect(Collectors.toList());
    }

    private Column getColumn(String columnId, String columnCaption, FieldInterfaced fieldInterfaced) {
        return Column.builder().id(columnId).caption(columnCaption).type(this.fieldTypeMapper.mapColumnType(fieldInterfaced)).stereotype("column").attributes(List.of()).width(this.fieldTypeMapper.getWidth(fieldInterfaced)).build();
    }

    private SearchForm buildSearchForm(Listing rpcView, String listId) {
        return SearchForm.builder().fields(this.buildSearchFields(rpcView, listId)).build();
    }

    private List<Field> buildSearchFields(Listing rpcView, String listId) {
        List validFieldIds;
        Class searchFormClass = rpcView.getSearchFormClass();
        List<FieldInterfaced> allEditableFields = ReflectionHelper.getAllEditableFields(searchFormClass);
        if (rpcView instanceof RpcCrudViewExtended && (validFieldIds = ((RpcCrudViewExtended)((Object)rpcView)).getFilterFields().stream().map(f -> f.getId()).collect(Collectors.toList())).size() > 0) {
            allEditableFields = allEditableFields.stream().filter(f -> validFieldIds.contains(f.getId())).collect(Collectors.toList());
        }
        return allEditableFields.stream().map(fieldInterfaced -> this.fieldMetadataBuilder.getField(rpcView, (FieldInterfaced)fieldInterfaced)).map(f -> {
            f.setId(listId + "-" + f.getId());
            return f;
        }).collect(Collectors.toList());
    }
}

