/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.commands.runStep.concreteActionRunners;

import io.mateu.core.domain.commands.runStep.ActionRunner;
import io.mateu.core.domain.commands.runStep.ActualValueExtractor;
import io.mateu.core.domain.commands.runStep.concreteActionRunners.AbstractActionRunner;
import io.mateu.core.domain.model.editors.EntityEditor;
import io.mateu.core.domain.model.editors.MethodParametersEditor;
import io.mateu.core.domain.model.editors.ObjectEditor;
import io.mateu.core.domain.model.persistence.Merger;
import io.mateu.core.domain.model.store.JourneyStoreService;
import io.mateu.mdd.shared.annotations.Action;
import io.mateu.mdd.shared.annotations.MainAction;
import io.mateu.mdd.shared.data.Result;
import io.mateu.mdd.shared.interfaces.Listing;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.Helper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class RunMethodActionRunner
extends AbstractActionRunner
implements ActionRunner {
    @Autowired
    JourneyStoreService store;
    @Autowired
    Merger merger;
    @Autowired
    ActualValueExtractor actualValueExtractor;

    @Override
    public boolean applies(Object viewInstance, String actionId) {
        return this.getActions(this.getActualInstance(viewInstance, Map.of())).containsKey(actionId);
    }

    private Object getActualInstance(Object viewInstance, Map<String, Object> data) {
        if (viewInstance instanceof EntityEditor) {
            try {
                EntityEditor entityEditor = (EntityEditor)viewInstance;
                Object actualInstance = this.merger.loadEntity(entityEditor.getData(), entityEditor.getEntityClass());
                data.entrySet().forEach(entry -> {
                    try {
                        Object actualValue = this.actualValueExtractor.getActualValue((Map.Entry<String, Object>)entry, actualInstance);
                        ReflectionHelper.setValue((String)entry.getKey(), actualInstance, actualValue);
                    }
                    catch (Exception ex) {
                        System.out.println(ex.getClass().getSimpleName() + ": " + ex.getMessage());
                    }
                });
                return actualInstance;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        if (viewInstance instanceof ObjectEditor) {
            try {
                ObjectEditor objectEditor = (ObjectEditor)viewInstance;
                Object object = ReflectionHelper.newInstance(objectEditor.getType());
                Object filled = Helper.fromJson(Helper.toJson(objectEditor.getData()), objectEditor.getType());
                ReflectionHelper.copy(filled, object);
                Object actualInstance = object;
                data.entrySet().forEach(entry -> {
                    try {
                        Object actualValue = this.actualValueExtractor.getActualValue((Map.Entry<String, Object>)entry, actualInstance);
                        ReflectionHelper.setValue((String)entry.getKey(), actualInstance, actualValue);
                    }
                    catch (Exception ex) {
                        System.out.println(ex.getClass().getSimpleName() + ": " + ex.getMessage());
                    }
                });
                return actualInstance;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return viewInstance;
    }

    private Map<Object, Method> getActions(Object viewInstance) {
        return ReflectionHelper.getAllMethods(this.getActualInstance(viewInstance, Map.of()).getClass()).stream().filter(m -> m.isAnnotationPresent(Action.class) || m.isAnnotationPresent(MainAction.class)).collect(Collectors.toMap(m -> m.getName(), m -> m));
    }

    @Override
    public Mono<Void> run(Object viewInstance, String journeyId, String stepId, String actionId, Map<String, Object> data, ServerHttpRequest serverHttpRequest) throws Throwable {
        Object actualViewInstance = this.getActualInstance(viewInstance, data);
        Method m = this.getActions(actualViewInstance).get(actionId);
        return this.runMethod(actualViewInstance, m, journeyId, stepId, actionId, data, serverHttpRequest);
    }

    protected Mono<Void> runMethod(final Object actualViewInstance, Method m, final String journeyId, String stepId, String actionId, Map<String, Object> data, final ServerHttpRequest serverHttpRequest) throws Throwable {
        if (this.needsParameters(m)) {
            if (Modifier.isStatic(m.getModifiers())) {
                this.store.setStep(journeyId, actionId, new MethodParametersEditor(m.getDeclaringClass(), m.getName(), this.store.getCurrentStep(journeyId).getId(), data), serverHttpRequest);
            } else {
                this.store.setStep(journeyId, actionId, new MethodParametersEditor(actualViewInstance, m.getName(), this.store.getCurrentStep(journeyId).getId()), serverHttpRequest);
            }
        } else {
            try {
                Object result = m.invoke(actualViewInstance, this.injectParameters(m, serverHttpRequest));
                if (result != null && Mono.class.isAssignableFrom(result.getClass())) {
                    Mono mono = (Mono)result;
                    return mono.map(r -> {
                        try {
                            Object whatToShow = r;
                            if (!Void.TYPE.equals(m.getReturnType())) {
                                if (whatToShow instanceof Result) {
                                    this.addBackDestination((Result)whatToShow, this.store.getInitialStep(journeyId));
                                }
                                String newStepId = "result_" + UUID.randomUUID().toString();
                                this.store.setStep(journeyId, newStepId, whatToShow, serverHttpRequest);
                            }
                        }
                        catch (Throwable e) {
                            return Mono.error((Throwable)new RuntimeException(e));
                        }
                        return Mono.empty();
                    }).then(Mono.fromRunnable((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (actualViewInstance != null && !(actualViewInstance instanceof Listing)) {
                                try {
                                    RunMethodActionRunner.this.store.updateStep(journeyId, actualViewInstance, serverHttpRequest);
                                }
                                catch (Throwable e) {
                                    throw new RuntimeException(e);
                                }
                            }
                        }
                    }));
                }
                if (actualViewInstance != null && !(actualViewInstance instanceof Listing)) {
                    this.store.updateStep(journeyId, actualViewInstance, serverHttpRequest);
                }
                Object whatToShow = result;
                if (!Void.TYPE.equals(m.getReturnType())) {
                    if (whatToShow instanceof Result) {
                        this.addBackDestination((Result)whatToShow, this.store.getInitialStep(journeyId));
                    }
                    String newStepId = "result_" + UUID.randomUUID().toString();
                    this.store.setStep(journeyId, newStepId, whatToShow, serverHttpRequest);
                }
            }
            catch (InvocationTargetException ex) {
                Throwable targetException = ex.getTargetException();
                System.out.println(targetException.getClass().getSimpleName() + ": " + targetException.getMessage());
                throw targetException;
            }
        }
        return Mono.empty();
    }

    private Object[] injectParameters(Method m, ServerHttpRequest serverHttpRequest) {
        Object[] values = new Object[m.getParameterCount()];
        for (int i = 0; i < m.getParameters().length; ++i) {
            Parameter parameter = m.getParameters()[i];
            ServerHttpRequest value = null;
            if (ServerHttpRequest.class.equals(parameter.getType())) {
                value = serverHttpRequest;
            }
            values[i] = value;
        }
        return values;
    }

    private boolean needsParameters(Method m) {
        if (m.getParameterCount() == 0) {
            return false;
        }
        boolean anyNotInjected = false;
        for (Parameter parameter : m.getParameters()) {
            if (parameter.getType().equals(ServerHttpRequest.class)) continue;
            anyNotInjected = true;
        }
        return anyNotInjected;
    }
}

