/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.commands.runStep.concreteActionRunners;

import io.mateu.core.domain.commands.runStep.ActionRunner;
import io.mateu.core.domain.commands.runStep.ActualValueExtractor;
import io.mateu.core.domain.commands.runStep.concreteActionRunners.AbstractActionRunner;
import io.mateu.core.domain.model.editors.MethodParametersEditor;
import io.mateu.core.domain.model.store.JourneyStoreService;
import io.mateu.mdd.shared.data.Result;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.remote.dtos.Step;
import io.mateu.util.Serializer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class MethodParametersEditorRunActionRunner
extends AbstractActionRunner
implements ActionRunner {
    @Autowired
    JourneyStoreService store;
    @Autowired
    private ActualValueExtractor actualValueExtractor;

    @Override
    public boolean applies(Object viewInstance, String actionId) {
        return viewInstance instanceof MethodParametersEditor && "run".equals(actionId);
    }

    @Override
    public Mono<Void> run(Object viewInstance, String journeyId, String stepId, String actionId, Map<String, Object> data, ServerHttpRequest serverHttpRequest) throws Throwable {
        MethodParametersEditor methodParametersEditor = (MethodParametersEditor)viewInstance;
        Step initialStep = this.store.getStep(journeyId, methodParametersEditor.getInitialStep());
        Method m = ReflectionHelper.getMethod(methodParametersEditor.getType(), methodParametersEditor.getMethodId());
        Object object = Modifier.isStatic(m.getModifiers()) ? null : Serializer.fromMap(methodParametersEditor.getData(), methodParametersEditor.getType());
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < m.getParameterCount(); ++i) {
            if (ServerHttpRequest.class.equals(m.getParameterTypes()[i])) {
                values.add(serverHttpRequest);
                continue;
            }
            values.add(this.actualValueExtractor.getActualValue(m.getParameterTypes()[i], data.get("param_" + i)));
        }
        Object result = m.invoke(object, values.toArray());
        if (object != null) {
            this.store.updateStep(journeyId, initialStep.getId(), object, serverHttpRequest);
        }
        Object whatToShow = result;
        if (!Void.TYPE.equals(m.getReturnType())) {
            if (whatToShow instanceof Result) {
                this.addBackDestination((Result)whatToShow, this.store.getInitialStep(journeyId));
            }
            String newStepId = "result_" + UUID.randomUUID().toString();
            this.store.setStep(journeyId, newStepId, whatToShow, serverHttpRequest);
        } else {
            this.store.backToStep(journeyId, initialStep.getId());
        }
        return Mono.empty();
    }
}

