/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.commands.runStep;

import com.google.common.base.Strings;
import io.mateu.core.domain.apiClients.MateuRemoteClient;
import io.mateu.core.domain.commands.runStep.ActionRunner;
import io.mateu.core.domain.commands.runStep.ActualValueExtractor;
import io.mateu.core.domain.commands.runStep.RunStepActionCommand;
import io.mateu.core.domain.model.editors.EntityEditor;
import io.mateu.core.domain.model.editors.FieldEditor;
import io.mateu.core.domain.model.editors.ObjectEditor;
import io.mateu.core.domain.model.store.JourneyContainer;
import io.mateu.core.domain.model.store.JourneyStoreService;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.remote.dtos.Step;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import reactor.core.publisher.Mono;

@Service
public class RunStepActionCommandHandler {
    private static final Logger log = LoggerFactory.getLogger(RunStepActionCommandHandler.class);
    @Autowired
    JourneyStoreService store;
    @Autowired
    MateuRemoteClient mateuRemoteClient;
    @Autowired
    List<ActionRunner> actionRunners;
    @Autowired
    ActualValueExtractor actualValueExtractor;

    @Transactional
    public Mono<Void> handle(RunStepActionCommand command) throws Throwable {
        String journeyId = command.getJourneyId();
        String stepId = command.getStepId();
        String actionId = command.getActionId();
        Map<String, Object> data = command.getData();
        ServerHttpRequest serverHttpRequest = command.getServerHttpRequest();
        JourneyContainer journeyContainer = this.store.findJourneyById(journeyId).orElse(null);
        if (journeyContainer == null) {
            throw new Exception("No journey with id " + journeyId);
        }
        if (!Strings.isNullOrEmpty((String)journeyContainer.getRemoteJourneyTypeId())) {
            return this.mateuRemoteClient.runStep(journeyContainer.getRemoteBaseUrl(), journeyContainer.getRemoteJourneyTypeId(), journeyContainer.getJourneyId(), stepId, actionId, data, serverHttpRequest);
        }
        Object viewInstance = this.store.getViewInstance(journeyId, stepId, serverHttpRequest);
        if (!(viewInstance instanceof FieldEditor || viewInstance instanceof ObjectEditor || viewInstance instanceof EntityEditor)) {
            data.entrySet().forEach(entry -> {
                try {
                    Object actualValue = this.actualValueExtractor.getActualValue((Map.Entry<String, Object>)entry, viewInstance);
                    ReflectionHelper.setValue((String)entry.getKey(), viewInstance, actualValue);
                }
                catch (Exception ex) {
                    System.out.println(ex.getClass().getSimpleName() + ": " + ex.getMessage());
                }
            });
        }
        Step step = this.store.getStep(journeyId, stepId);
        step.mergeData(data);
        this.store.updateStep(journeyId, stepId, step);
        String componentId = "component-0";
        if (actionId.contains("___")) {
            componentId = actionId.substring(0, actionId.indexOf("___"));
            actionId = actionId.substring(actionId.indexOf("___") + "___".length());
        }
        if (!"component-0".equals(componentId)) {
            // empty if block
        }
        for (ActionRunner actionRunner : this.actionRunners) {
            if (!actionRunner.applies(viewInstance, actionId)) continue;
            return actionRunner.run(viewInstance, journeyId, stepId, actionId, data, serverHttpRequest);
        }
        throw new Exception("Unkonwn action " + actionId);
    }
}

