/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.apiClients;

import io.mateu.mdd.shared.interfaces.SortCriteria;
import io.mateu.remote.dtos.Journey;
import io.mateu.remote.dtos.JourneyCreationRq;
import io.mateu.remote.dtos.RunActionRq;
import io.mateu.remote.dtos.Step;
import io.mateu.remote.dtos.UI;
import io.mateu.util.Helper;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.reactivestreams.Publisher;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class MateuRemoteClient {
    private WebClient buildClient(String remoteBaseUrl) {
        return WebClient.builder().baseUrl(remoteBaseUrl).build();
    }

    public Mono<Void> startJourney(String remoteBaseUrl, String remoteJourneyTypeId, String journeyId, ServerHttpRequest serverHttpRequest) {
        String uri = "/journeys/" + remoteJourneyTypeId + "/" + journeyId;
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.buildClient(remoteBaseUrl).post().uri(uri, new Object[0])).headers(headers -> serverHttpRequest.getHeaders())).body((Publisher)Mono.just((Object)JourneyCreationRq.builder().build()), JourneyCreationRq.class).retrieve().bodyToMono(Void.class);
    }

    public Mono<Journey> getJourney(String remoteBaseUrl, String remoteJourneyTypeId, String journeyId, ServerHttpRequest serverHttpRequest) {
        String uri = "/journeys/" + remoteJourneyTypeId + "/" + journeyId;
        return this.buildClient(remoteBaseUrl).get().uri(uri, new Object[0]).headers(headers -> serverHttpRequest.getHeaders()).retrieve().bodyToMono(Journey.class);
    }

    public Mono<Step> getStep(String remoteBaseUrl, String remoteJourneyTypeId, String journeyId, String stepId, ServerHttpRequest serverHttpRequest) {
        String uri = "/journeys/" + remoteJourneyTypeId + "/" + journeyId + "/steps/" + stepId;
        return this.buildClient(remoteBaseUrl).get().uri(uri, new Object[0]).headers(headers -> serverHttpRequest.getHeaders()).retrieve().bodyToMono(Step.class);
    }

    public Mono<Void> runStep(String remoteBaseUrl, String remoteJourneyTypeId, String journeyId, String stepId, String actionId, Map<String, Object> data, ServerHttpRequest serverHttpRequest) {
        String uri = "/journeys/" + remoteJourneyTypeId + "/" + journeyId + "/steps/" + stepId + "/" + actionId;
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.buildClient(remoteBaseUrl).post().uri(uri, new Object[0])).headers(headers -> serverHttpRequest.getHeaders())).body((Publisher)Mono.just((Object)RunActionRq.builder().data(data).build()), RunActionRq.class).retrieve().bodyToMono(Void.class);
    }

    public Flux<Object> getListRows(String remoteBaseUrl, String remoteJourneyTypeId, String journeyId, String stepId, String listId, Object filters, List<SortCriteria> ordering, int page, int pageSize, ServerHttpRequest serverHttpRequest) throws ExecutionException, InterruptedException {
        String uri = "/journeys/" + remoteJourneyTypeId + "/" + journeyId + "/steps/" + stepId + "/lists/" + listId + "/rows";
        return this.buildClient(remoteBaseUrl).get().uri(uriBuilder -> uriBuilder.path(uri).queryParam("filters", new Object[]{filters}).queryParam("ordering", new Object[]{this.serialize(ordering)}).queryParam("page", new Object[]{page}).queryParam("page_size", new Object[]{pageSize}).build(new Object[0])).headers(headers -> serverHttpRequest.getHeaders()).retrieve().bodyToFlux(Object.class);
    }

    private String serialize(Object object) {
        String json = "{}";
        try {
            json = Helper.toJson(object);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Base64.getEncoder().encodeToString(json.getBytes(StandardCharsets.UTF_8));
    }

    public Mono<Long> getListCount(String remoteBaseUrl, String remoteJourneyTypeId, String journeyId, String stepId, String listId, Object filters, ServerHttpRequest serverHttpRequest) throws ExecutionException, InterruptedException {
        String uri = "/journeys/" + remoteJourneyTypeId + "/" + journeyId + "/steps/" + stepId + "/lists/" + listId + "/count";
        return this.buildClient(remoteBaseUrl).get().uri(uriBuilder -> uriBuilder.path(uri).queryParam("filters", new Object[]{filters}).build(new Object[0])).headers(headers -> serverHttpRequest.getHeaders()).retrieve().bodyToMono(Long.class);
    }

    public UI getUi(String remoteBaseUrl, String uiId, ServerHttpRequest serverHttpRequest) throws ExecutionException, InterruptedException {
        String uri = "/uis/" + uiId;
        return (UI)this.buildClient(remoteBaseUrl).get().uri(uriBuilder -> uriBuilder.path(uri).build(new Object[0])).headers(headers -> serverHttpRequest.getHeaders()).retrieve().bodyToMono(UI.class).toFuture().get();
    }
}

