/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.commands.runStepAction.concreteStepActionRunners;

import io.mateu.core.domain.commands.runStepAction.ActionRunner;
import io.mateu.core.domain.model.editors.FieldEditor;
import io.mateu.core.domain.model.store.JourneyStoreService;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.Serializer;
import java.util.Map;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class FieldEditorActionRunner
implements ActionRunner {
    final JourneyStoreService store;
    final ReflectionHelper reflectionHelper;
    final Serializer serializer;

    @Override
    public boolean applies(Object viewInstance, String actionId) {
        return actionId.startsWith("__editfield__");
    }

    @Override
    public Mono<Void> run(Object viewInstance, String journeyId, String stepId, String actionId, Map<String, Object> data, ServerHttpRequest serverHttpRequest) throws Throwable {
        if (viewInstance instanceof FieldEditor) {
            this.store.setStep(journeyId, actionId, viewInstance, serverHttpRequest);
            return Mono.empty();
        }
        String fieldId = actionId.substring("__editfield__".length());
        FieldInterfaced field = this.reflectionHelper.getFieldByName(viewInstance.getClass(), fieldId);
        Object targetValue = this.reflectionHelper.getValue(field, viewInstance);
        if (targetValue == null) {
            targetValue = this.reflectionHelper.newInstance(field.getType());
        }
        this.store.setStep(journeyId, actionId, new FieldEditor(targetValue, fieldId, this.store.getCurrentStep(journeyId).getId(), this.serializer), serverHttpRequest);
        return Mono.empty();
    }

    public FieldEditorActionRunner(JourneyStoreService store, ReflectionHelper reflectionHelper, Serializer serializer) {
        this.store = store;
        this.reflectionHelper = reflectionHelper;
        this.serializer = serializer;
    }
}

