/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.reflection;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import io.mateu.core.infra.MateuConfiguratorBean;
import io.mateu.i18n.Translator;
import io.mateu.mdd.shared.SlimHelper;
import io.mateu.mdd.shared.annotations.Action;
import io.mateu.mdd.shared.annotations.Caption;
import io.mateu.mdd.shared.annotations.FieldsFilter;
import io.mateu.mdd.shared.annotations.Forbidden;
import io.mateu.mdd.shared.annotations.GenericClass;
import io.mateu.mdd.shared.annotations.Ignored;
import io.mateu.mdd.shared.annotations.KPI;
import io.mateu.mdd.shared.annotations.MenuOption;
import io.mateu.mdd.shared.annotations.ModifyValuesOnly;
import io.mateu.mdd.shared.annotations.NotInEditor;
import io.mateu.mdd.shared.annotations.NotWhenCreating;
import io.mateu.mdd.shared.annotations.NotWhenEditing;
import io.mateu.mdd.shared.annotations.Position;
import io.mateu.mdd.shared.annotations.ReadOnly;
import io.mateu.mdd.shared.annotations.ReadWrite;
import io.mateu.mdd.shared.annotations.Submenu;
import io.mateu.mdd.shared.interfaces.Listing;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.reflection.BaseReflectionHelper;
import io.mateu.reflection.FieldInterfacedFactory;
import io.mateu.reflection.FieldInterfacedForCheckboxColumn;
import io.mateu.reflection.FieldInterfacedFromField;
import io.mateu.reflection.MapEntry;
import io.mateu.util.Helper;
import io.mateu.util.data.Pair;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Version;
import jakarta.validation.constraints.NotNull;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.constant.Constable;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.converters.LongConverter;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReflectionHelper
extends BaseReflectionHelper {
    private static final Logger log = LoggerFactory.getLogger(ReflectionHelper.class);
    final Translator translator;
    final MateuConfiguratorBean beanProvider;
    final FieldInterfacedFactory fieldInterfacedFactory;
    Map<Class, List<FieldInterfaced>> allFieldsCache = new HashMap<Class, List<FieldInterfaced>>();
    Map<Class, List<Method>> allMethodsCache = new HashMap<Class, List<Method>>();
    Map<String, Method> methodCache = new HashMap<String, Method>();
    List<Class> notFromString = new ArrayList<Class>();
    private ObjectMapper mapper = new ObjectMapper();

    public ReflectionHelper(Translator translator, MateuConfiguratorBean beanProvider, FieldInterfacedFactory fieldInterfacedFactory) {
        this.translator = translator;
        this.beanProvider = beanProvider;
        this.fieldInterfacedFactory = fieldInterfacedFactory;
        BeanUtilsBean beanUtilsBean = BeanUtilsBean.getInstance();
        beanUtilsBean.getConvertUtils().register((Converter)new IntegerConverter(null), Integer.class);
        beanUtilsBean.getConvertUtils().register((Converter)new LongConverter(null), Long.class);
        beanUtilsBean.getConvertUtils().register((Converter)new DoubleConverter(null), Double.class);
        beanUtilsBean.getConvertUtils().register((Converter)new BooleanConverter(null), Boolean.class);
    }

    public Object getValue(Field f, Object o) {
        if (f == null) {
            return null;
        }
        Method getter = null;
        try {
            getter = o.getClass().getMethod(this.getGetter(f), new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object v = null;
        try {
            if (getter != null) {
                v = getter.invoke(o, new Object[0]);
            } else {
                if (!Modifier.isPublic(f.getModifiers())) {
                    f.setAccessible(true);
                }
                v = f.get(o);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("when getting value for field " + f.getName(), (Throwable)e);
        }
        return v;
    }

    public void setValue(FieldInterfaced f, Object o, Object v) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        block11: {
            if (f == null) {
                return;
            }
            if (f instanceof FieldInterfacedForCheckboxColumn) {
                f.setValue(o, v);
            } else if (f instanceof FieldInterfacedFromField) {
                Method setter = null;
                try {
                    setter = o.getClass().getMethod(this.getSetter(f), f.getType());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (setter != null) {
                        setter.invoke(o, v);
                        break block11;
                    }
                    if (!Modifier.isPublic(f.getField().getModifiers())) {
                        f.getField().setAccessible(true);
                    }
                    f.getField().set(o, v);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    log.error("when setting value for field " + f.getName(), (Throwable)e);
                }
            } else {
                this.setValue(f.getId(), o, v);
            }
        }
    }

    public void setValue(String fn, Object o, Object v) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        if (Map.class.isAssignableFrom(o.getClass())) {
            ((Map)o).put(fn, v);
        } else if (fn.contains(".")) {
            o = this.getInstance(o, fn.substring(0, fn.indexOf(".")));
            this.setValue(fn.substring(fn.indexOf(".") + 1), o, v);
        } else {
            if (v instanceof Collection) {
                if (v instanceof List) {
                    v = new ArrayList(v);
                } else if (v instanceof Set) {
                    v = new HashSet(v);
                }
            }
            FieldInterfaced f = this.getFieldByName(o.getClass(), fn);
            this.setValue(f, o, v);
        }
    }

    public Object getValue(FieldInterfaced f, Object o, Object valueIfNull) {
        Object v = null;
        try {
            v = this.getValue(f, o);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return v != null ? v : valueIfNull;
    }

    public Object getValue(FieldInterfaced f, Object o) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (o == null) {
            return null;
        }
        if (Map.class.isAssignableFrom(o.getClass())) {
            return ((Map)o).get(f.getName());
        }
        if (f instanceof FieldInterfacedForCheckboxColumn) {
            return f.getValue(o);
        }
        return this.getValue(f.getId(), o);
    }

    public Object getValue(String id, Object o) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object v;
        block24: {
            v = null;
            if (id.contains(".")) {
                String firstId = id.substring(0, id.indexOf("."));
                String path = id.substring(id.indexOf(".") + 1);
                Method getter2 = null;
                try {
                    FieldInterfaced f = this.getFieldByName(o.getClass(), firstId);
                    if (f == null) break block24;
                    try {
                        getter2 = o.getClass().getMethod(this.getGetter(f.getType(), firstId), new Class[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (getter2 != null) {
                        v = getter2.invoke(o, new Object[0]);
                    } else {
                        try {
                            if (f instanceof FieldInterfacedFromField) {
                                Field field = f.getField();
                                if (!Modifier.isPublic(field.getModifiers())) {
                                    field.setAccessible(true);
                                }
                                v = field.get(o);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (v != null) {
                        v = this.getValue(path, v);
                    }
                }
                catch (Exception exception) {}
            } else {
                FieldInterfaced f = this.getFieldByName(o.getClass(), id);
                if (f != null) {
                    Method getter = null;
                    try {
                        getter = o.getClass().getMethod(this.getGetter(f.getType(), id), new Class[0]);
                    }
                    catch (Exception getter2) {
                        // empty catch block
                    }
                    try {
                        if (getter != null) {
                            v = getter.invoke(o, new Object[0]);
                            break block24;
                        }
                        try {
                            if (f instanceof FieldInterfacedFromField) {
                                Field field = f.getField();
                                if (!Modifier.isPublic(field.getModifiers())) {
                                    field.setAccessible(true);
                                }
                                v = field.get(o);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return v;
    }

    private Object getInstance(Object o, String fn) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Object x = null;
        if (o != null) {
            if (fn.contains(".")) {
                o = this.getInstance(o, fn.substring(0, fn.indexOf(".")));
                x = this.getInstance(o, fn.substring(fn.indexOf(".") + 1));
            } else {
                x = o.getClass().getMethod(this.getGetter(fn), new Class[0]).invoke(o, new Object[0]);
            }
        }
        return x;
    }

    public Method getMethod(Class<?> c, String methodName) {
        if (c == null) {
            log.debug("getMethod(null, " + methodName + ") devolver\u00e1 null!");
            return null;
        }
        Method l = this.methodCache.get(c.getName() + "-" + methodName);
        if (l == null) {
            l = this.buildMethod(c, methodName);
            this.methodCache.put(c.getName() + "-" + methodName, l);
        }
        return l;
    }

    public Method buildMethod(Class<?> c, String methodName) {
        Method m = null;
        if (c != null) {
            for (Method q : this.getAllMethods(c)) {
                if (!methodName.equals(q.getName())) continue;
                m = q;
                break;
            }
        }
        return m;
    }

    public String getGetter(Field f) {
        return this.getGetter(f.getType(), f.getName());
    }

    public String getGetter(FieldInterfaced f) {
        return this.getGetter(f.getType(), f.getName());
    }

    public String getGetter(Class c, String fieldName) {
        return (Boolean.TYPE.equals(c) ? "is" : "get") + this.getFirstUpper(fieldName);
    }

    public String getGetter(String fn) {
        return "get" + this.getFirstUpper(fn);
    }

    public String getSetter(Field f) {
        return this.getSetter(f.getType(), f.getName());
    }

    public String getSetter(FieldInterfaced f) {
        return this.getSetter(f.getType(), f.getName());
    }

    public String getSetter(Class c, String fieldName) {
        return "set" + this.getFirstUpper(fieldName);
    }

    public List<Method> getAllMethods(Class c) {
        List<Method> l = this._getAllMethods(c);
        ArrayList<Method> r = new ArrayList<Method>();
        for (Method m : l) {
            if (!this.check(m)) continue;
            r.add(m);
        }
        return r;
    }

    public List<Method> _getAllMethods(Class c) {
        List<Method> l = this.allMethodsCache.get(c);
        if (l == null) {
            l = this.buildAllMethods(c);
            this.allMethodsCache.put(c, l);
        }
        return l;
    }

    public List<Method> buildAllMethods(Class c) {
        ArrayList<Method> l = new ArrayList<Method>();
        if (c.getSuperclass() != null && (!c.isAnnotationPresent(Entity.class) || c.getSuperclass().isAnnotationPresent(Entity.class) || c.getSuperclass().isAnnotationPresent(MappedSuperclass.class))) {
            l.addAll(this.getAllMethods(c.getSuperclass()));
        }
        for (Method f : c.getDeclaredMethods()) {
            l.removeIf(m -> this.getSignature((Method)m).equals(this.getSignature(f)));
            l.add(f);
        }
        return l;
    }

    private String getSignature(Method m) {
        return m.getGenericReturnType().getTypeName() + " " + m.getName() + "(" + this.getSignature(m.getParameters()) + ")";
    }

    private String getSignature(Parameter[] parameters) {
        Object s = "";
        if (parameters != null) {
            for (Parameter p : parameters) {
                if (!"".equals(s)) {
                    s = (String)s + ", ";
                }
                s = (String)s + p.getType().getName();
            }
        }
        return s;
    }

    private Method getMethod(Class c, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Method m = c.getClass().getDeclaredMethod(methodName, parameterTypes);
        if (m == null && c.getSuperclass() != null && (!c.isAnnotationPresent(Entity.class) || c.getSuperclass().isAnnotationPresent(Entity.class) || c.getSuperclass().isAnnotationPresent(MappedSuperclass.class))) {
            m = this.getMethod(c.getSuperclass(), methodName, parameterTypes);
        }
        return m;
    }

    public List<FieldInterfaced> getAllFields(Class c) {
        List<FieldInterfaced> l = this.allFieldsCache.get(c);
        if (l == null) {
            l = this.buildAllFields(c);
            this.allFieldsCache.put(c, l);
        }
        return new ArrayList<FieldInterfaced>(l);
    }

    private List<FieldInterfaced> buildAllFields(Class c) {
        ArrayList<String> vistos = new ArrayList<String>();
        HashMap<String, Field> originales = new HashMap<String, Field>();
        for (Field f : c.getDeclaredFields()) {
            if (Logger.class.isAssignableFrom(f.getType()) || f.getName().contains("$") || "_proxied".equalsIgnoreCase(f.getName()) || "_possibleValues".equalsIgnoreCase(f.getName()) || "_binder".equalsIgnoreCase(f.getName()) || "_field".equalsIgnoreCase(f.getName())) continue;
            originales.put(f.getName(), f);
        }
        ArrayList<FieldInterfaced> l = new ArrayList<FieldInterfaced>();
        if (c.getSuperclass() != null && (!c.isAnnotationPresent(Entity.class) || c.getSuperclass().isAnnotationPresent(Entity.class) || c.getSuperclass().isAnnotationPresent(MappedSuperclass.class))) {
            for (FieldInterfaced f : this.getAllFields(c.getSuperclass())) {
                if (!originales.containsKey(f.getId())) {
                    l.add(f);
                } else {
                    l.add(this.fieldInterfacedFactory.getFieldInterfacedFromField((Field)originales.get(f.getName()), this));
                }
                vistos.add(f.getName());
            }
        }
        for (Field f : c.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers()) || f.isAnnotationPresent(Version.class) || Logger.class.isAssignableFrom(f.getType()) || vistos.contains(f.getName()) || f.getName().contains("$") || "_proxied".equalsIgnoreCase(f.getName()) || "_possibleValues".equalsIgnoreCase(f.getName()) || "_binder".equalsIgnoreCase(f.getName()) || "_field".equalsIgnoreCase(f.getName())) continue;
            l.add(this.fieldInterfacedFactory.getFieldInterfacedFromField(f, this));
        }
        return l;
    }

    public boolean hasGetter(FieldInterfaced f) {
        return this.getMethod(f.getDeclaringClass(), this.getGetter(f)) != null;
    }

    public boolean hasSetter(FieldInterfaced f) {
        return this.getMethod(f.getDeclaringClass(), this.getSetter(f)) != null;
    }

    public List<FieldInterfaced> getAllFields(Method m) {
        ArrayList<FieldInterfaced> l = new ArrayList<FieldInterfaced>();
        for (Parameter p : m.getParameters()) {
            if (this.isInjectable(m, p)) continue;
            l.add(this.fieldInterfacedFactory.getFieldInterfacedFromParameter(m, p, this));
        }
        return l;
    }

    public boolean isInjectable(Executable m, Parameter p) {
        boolean injectable = true;
        if (!EntityManager.class.equals(p.getType())) {
            injectable = false;
        }
        return injectable;
    }

    private Map<String, FieldInterfaced> getAllFieldsMap(Class c) {
        return this.getAllFieldsMap(this.getAllFields(c));
    }

    private Map<String, FieldInterfaced> getAllFieldsMap(List<FieldInterfaced> l) {
        HashMap<String, FieldInterfaced> m = new HashMap<String, FieldInterfaced>();
        for (FieldInterfaced f : l) {
            m.put(f.getName(), f);
        }
        return m;
    }

    public Object getId(Object model) {
        if (model instanceof Object[]) {
            return ((Object[])model)[0];
        }
        if (model instanceof Pair) {
            return ((Pair)model).getKey();
        }
        if (model.getClass().isAnnotationPresent(Entity.class)) {
            Object id = null;
            try {
                FieldInterfaced idField = this.getIdField(model.getClass());
                id = this.getValue(idField, model);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            return id;
        }
        if (model.getClass().isEnum()) {
            return ((Enum)model).ordinal();
        }
        return model;
    }

    public FieldInterfaced getIdField(Class type) {
        if (type.isAnnotationPresent(Entity.class)) {
            FieldInterfaced idField = null;
            for (FieldInterfaced f : this.getAllFields(type)) {
                if (!f.isAnnotationPresent(Id.class)) continue;
                idField = f;
                break;
            }
            return idField;
        }
        return null;
    }

    public Field getVersionField(Class c) {
        if (c.isAnnotationPresent(Entity.class)) {
            Field idField = null;
            if (c.getSuperclass() != null && (!c.isAnnotationPresent(Entity.class) || c.getSuperclass().isAnnotationPresent(Entity.class) || c.getSuperclass().isAnnotationPresent(MappedSuperclass.class))) {
                idField = this.getVersionField(c.getSuperclass());
            }
            if (idField == null) {
                for (Field f : c.getDeclaredFields()) {
                    if (!f.isAnnotationPresent(Version.class)) continue;
                    idField = f;
                }
            }
            return idField;
        }
        return null;
    }

    public FieldInterfaced getNameField(Class entityClass, boolean toStringPreferred) {
        boolean toStringIsOverriden;
        FieldInterfaced fName = null;
        Method toStringMethod = this.getMethod(entityClass, "toString");
        boolean bl = toStringIsOverriden = toStringMethod != null && toStringMethod.getDeclaringClass().equals(entityClass);
        if (!toStringPreferred || !toStringIsOverriden) {
            boolean hayName = false;
            for (FieldInterfaced ff : this.getAllFields(entityClass)) {
                if (!"name".equalsIgnoreCase(ff.getName()) && !"nombre".equalsIgnoreCase(ff.getName())) continue;
                fName = ff;
                hayName = true;
            }
            if (!hayName) {
                for (FieldInterfaced ff : this.getAllFields(entityClass)) {
                    if (!"value".equalsIgnoreCase(ff.getName()) && !"title".equalsIgnoreCase(ff.getName()) && !"titulo".equalsIgnoreCase(ff.getName()) && !"description".equalsIgnoreCase(ff.getName()) && !"descripcion".equalsIgnoreCase(ff.getName())) continue;
                    fName = ff;
                    hayName = true;
                }
            }
            if (!hayName) {
                for (FieldInterfaced ff : this.getAllFields(entityClass)) {
                    if (!"description".equalsIgnoreCase(ff.getName()) && !"descripcion".equalsIgnoreCase(ff.getName())) continue;
                    fName = ff;
                    hayName = true;
                }
            }
            if (!hayName) {
                for (FieldInterfaced ff : this.getAllFields(entityClass)) {
                    if (!ff.isAnnotationPresent(Id.class)) continue;
                    fName = ff;
                }
            }
        }
        return fName;
    }

    public FieldInterfaced getFieldByName(Class sourceClass, String fieldName) {
        FieldInterfaced field = null;
        String fn = fieldName.split("\\.")[0];
        for (FieldInterfaced f : this.getAllFields(sourceClass)) {
            if (!fn.equals(f.getName())) continue;
            if (fn.equals(fieldName)) {
                field = f;
                break;
            }
            field = this.getFieldByName(f.getType(), fieldName.substring(fn.length() + 1));
            break;
        }
        return field;
    }

    public FieldInterfaced getMapper(FieldInterfaced field) {
        FieldInterfaced mapper = null;
        String mfn = null;
        if (field.isAnnotationPresent(OneToOne.class)) {
            mfn = field.getAnnotation(OneToOne.class).mappedBy();
        } else if (field.isAnnotationPresent(OneToMany.class)) {
            mfn = field.getAnnotation(OneToMany.class).mappedBy();
        } else if (field.isAnnotationPresent(ManyToMany.class)) {
            mfn = field.getAnnotation(ManyToMany.class).mappedBy();
        } else if (field.isAnnotationPresent(ManyToOne.class)) {
            for (FieldInterfaced f : this.getAllFields(field.getType())) {
                String z = null;
                if (f.isAnnotationPresent(OneToOne.class)) {
                    z = f.getAnnotation(OneToOne.class).mappedBy();
                } else if (f.isAnnotationPresent(OneToMany.class)) {
                    z = f.getAnnotation(OneToMany.class).mappedBy();
                } else if (f.isAnnotationPresent(ManyToMany.class)) {
                    z = f.getAnnotation(ManyToMany.class).mappedBy();
                }
                if (!field.getName().equals(z) || !field.getDeclaringClass().equals(f.getType()) && !field.getDeclaringClass().equals(this.getGenericClass(f.getGenericType()))) continue;
                mfn = f.getName();
                break;
            }
        }
        Class<Object> targetClass = null;
        targetClass = Collection.class.isAssignableFrom(field.getType()) || Set.class.isAssignableFrom(field.getType()) ? field.getGenericClass() : (Map.class.isAssignableFrom(field.getType()) ? this.getGenericClass(field, Map.class, "V") : field.getType());
        if (!Strings.isNullOrEmpty((String)mfn)) {
            mapper = this.getFieldByName(targetClass, mfn);
        } else if (targetClass.isAnnotationPresent(Entity.class)) {
            for (FieldInterfaced f : this.getAllFields(targetClass)) {
                mfn = null;
                if (f.isAnnotationPresent(OneToOne.class)) {
                    mfn = f.getAnnotation(OneToOne.class).mappedBy();
                } else if (f.isAnnotationPresent(OneToMany.class)) {
                    mfn = f.getAnnotation(OneToMany.class).mappedBy();
                } else if (f.isAnnotationPresent(ManyToMany.class)) {
                    mfn = f.getAnnotation(ManyToMany.class).mappedBy();
                }
                if (!field.getName().equals(mfn)) continue;
                Class<Object> reverseClass = null;
                reverseClass = Collection.class.isAssignableFrom(f.getType()) || Set.class.isAssignableFrom(f.getType()) ? f.getGenericClass() : (Map.class.isAssignableFrom(field.getType()) ? this.getGenericClass(f, Map.class, "V") : f.getType());
                if (reverseClass == null || !field.getDeclaringClass().isAssignableFrom(reverseClass)) continue;
                mapper = f;
                break;
            }
        }
        return mapper;
    }

    public Class getGenericClass(FieldInterfaced field, Class asClassOrInterface, String genericArgumentName) {
        Type t = field.getGenericType();
        if (field.isAnnotationPresent(GenericClass.class)) {
            return field.getAnnotation(GenericClass.class).clazz();
        }
        return this.getGenericClass(t instanceof ParameterizedType ? (ParameterizedType)t : null, field.getType(), asClassOrInterface, genericArgumentName);
    }

    public Class getGenericClass(ParameterizedType parameterizedType, Class asClassOrInterface, String genericArgumentName) {
        return this.getGenericClass(parameterizedType, (Class)parameterizedType.getRawType(), asClassOrInterface, genericArgumentName);
    }

    public Class getGenericClass(Class sourceClass, Class asClassOrInterface, String genericArgumentName) {
        return this.getGenericClass(null, sourceClass, asClassOrInterface, genericArgumentName);
    }

    public Class getGenericClass(ParameterizedType parameterizedType, Class sourceClass, Class asClassOrInterface, String genericArgumentName) {
        Class c = null;
        if (asClassOrInterface.isInterface()) {
            Class baseInterface = null;
            if (sourceClass.isInterface()) {
                boolean laImplementa;
                baseInterface = sourceClass;
                ArrayList jerarquiaInterfaces = this.buscarInterfaz(sourceClass, asClassOrInterface);
                if (asClassOrInterface.equals(sourceClass)) {
                    jerarquiaInterfaces = Lists.newArrayList((Object[])new Type[]{asClassOrInterface});
                }
                boolean bl = laImplementa = jerarquiaInterfaces != null;
                if (laImplementa) {
                    jerarquiaInterfaces.add(parameterizedType != null ? parameterizedType : sourceClass);
                    c = this.buscarHaciaAbajo(asClassOrInterface, genericArgumentName, jerarquiaInterfaces);
                }
            } else {
                Type tipoEnCurso;
                boolean laImplementa = false;
                ArrayList<Type> jerarquia = new ArrayList<Type>();
                List<Type> jerarquiaInterfaces = null;
                Type type = tipoEnCurso = parameterizedType != null ? parameterizedType : sourceClass;
                while (tipoEnCurso != null && !laImplementa) {
                    jerarquiaInterfaces = this.buscarInterfaz(tipoEnCurso, asClassOrInterface);
                    laImplementa = jerarquiaInterfaces != null;
                    if (laImplementa) continue;
                    Type genericSuperclass = this.getSuper(tipoEnCurso);
                    if (genericSuperclass != null && genericSuperclass instanceof ParameterizedType) {
                        ParameterizedType pt = (ParameterizedType)genericSuperclass;
                        if (!(pt.getRawType() instanceof Class)) continue;
                        genericSuperclass = pt.getRawType();
                        if (Object.class.equals((Object)genericSuperclass)) {
                            tipoEnCurso = null;
                            continue;
                        }
                        jerarquia.add(tipoEnCurso);
                        tipoEnCurso = pt;
                        continue;
                    }
                    if (genericSuperclass != null && genericSuperclass instanceof Class) {
                        if (Object.class.equals((Object)genericSuperclass)) {
                            tipoEnCurso = null;
                            continue;
                        }
                        jerarquia.add(tipoEnCurso);
                        tipoEnCurso = (Class)genericSuperclass;
                        continue;
                    }
                    tipoEnCurso = null;
                }
                if (laImplementa) {
                    jerarquia.add(tipoEnCurso);
                    jerarquia.addAll(jerarquiaInterfaces);
                    c = this.buscarHaciaAbajo(asClassOrInterface, genericArgumentName, jerarquia);
                }
            }
        } else {
            Type tipoEnCurso;
            if (sourceClass.isInterface()) {
                return null;
            }
            ArrayList<Type> jerarquia = new ArrayList<Type>();
            Type type = tipoEnCurso = parameterizedType != null ? parameterizedType : sourceClass;
            while (!(tipoEnCurso == null || asClassOrInterface.equals(tipoEnCurso) || tipoEnCurso instanceof ParameterizedType && asClassOrInterface.equals(tipoEnCurso.getRawType()))) {
                Type genericSuperclass = this.getSuper(tipoEnCurso);
                if (genericSuperclass != null && genericSuperclass instanceof ParameterizedType) {
                    ParameterizedType pt = (ParameterizedType)genericSuperclass;
                    if (!(pt.getRawType() instanceof Class)) continue;
                    genericSuperclass = pt.getRawType();
                    if (Object.class.equals((Object)genericSuperclass)) {
                        tipoEnCurso = null;
                        continue;
                    }
                    jerarquia.add(tipoEnCurso);
                    tipoEnCurso = pt;
                    continue;
                }
                if (genericSuperclass != null && genericSuperclass instanceof Class) {
                    if (Object.class.equals((Object)genericSuperclass)) {
                        tipoEnCurso = null;
                        continue;
                    }
                    jerarquia.add(tipoEnCurso);
                    tipoEnCurso = (Class)genericSuperclass;
                    continue;
                }
                tipoEnCurso = null;
            }
            if (tipoEnCurso != null) {
                jerarquia.add(tipoEnCurso);
                c = this.buscarHaciaAbajo(asClassOrInterface, genericArgumentName, jerarquia);
            }
        }
        return c;
    }

    private Class buscarHaciaAbajo(Type asClassOrInterface, String genericArgumentName, List<Type> jerarquia) {
        Class c = null;
        int argPos = this.getArgPos(asClassOrInterface, genericArgumentName);
        for (int escalon = jerarquia.size() - 1; escalon >= 0 && c == null; --escalon) {
            Type tipoEnCurso = jerarquia.get(escalon);
            if (tipoEnCurso instanceof Class) {
                if (((Class)tipoEnCurso).getTypeParameters().length > argPos) {
                    TypeVariable t = ((Class)tipoEnCurso).getTypeParameters()[argPos];
                    genericArgumentName = t.getName();
                    asClassOrInterface = (Class)tipoEnCurso;
                    argPos = this.getArgPos(asClassOrInterface, genericArgumentName);
                    continue;
                }
                c = Object.class;
                continue;
            }
            if (!(tipoEnCurso instanceof ParameterizedType)) continue;
            ParameterizedType pt = (ParameterizedType)tipoEnCurso;
            Type t = pt.getActualTypeArguments()[argPos];
            if (t instanceof Class) {
                c = (Class)t;
                continue;
            }
            if (!(t instanceof TypeVariable)) continue;
            genericArgumentName = ((TypeVariable)t).getName();
            asClassOrInterface = tipoEnCurso;
            argPos = this.getArgPos(asClassOrInterface, genericArgumentName);
        }
        return c;
    }

    private List<Type> buscarInterfaz(Type tipo, Class interfaz) {
        ParameterizedType pt;
        List<Type> jerarquia = null;
        Class clase = null;
        if (tipo instanceof Class) {
            clase = (Class)tipo;
        } else if (tipo instanceof ParameterizedType && (pt = (ParameterizedType)tipo).getRawType() instanceof Class) {
            clase = (Class)pt.getRawType();
        }
        if (clase != null) {
            Type t;
            Type[] typeArray = clase.getGenericInterfaces();
            int n = typeArray.length;
            for (int i = 0; i < n && (jerarquia = this.buscarSuperInterfaz(t = typeArray[i], interfaz)) == null; ++i) {
            }
        }
        return jerarquia;
    }

    private List<Type> buscarSuperInterfaz(Type tipo, Class interfaz) {
        ParameterizedType pt;
        ArrayList<Type> jerarquia = null;
        Class clase = null;
        if (tipo instanceof Class) {
            clase = (Class)tipo;
        } else if (tipo instanceof ParameterizedType && (pt = (ParameterizedType)tipo).getRawType() instanceof Class) {
            clase = (Class)pt.getRawType();
        }
        if (clase != null) {
            Type tipoEnCurso = clase;
            ArrayList<Type> tempJerarquia = new ArrayList<Type>();
            tempJerarquia.add(tipo);
            while (!(tipoEnCurso == null || interfaz.equals(tipoEnCurso) || tipoEnCurso instanceof ParameterizedType && interfaz.equals(((ParameterizedType)tipoEnCurso).getRawType()))) {
                Type genericSuperclass = this.getSuper(tipoEnCurso);
                if (genericSuperclass != null && genericSuperclass instanceof ParameterizedType) {
                    ParameterizedType pt2 = (ParameterizedType)genericSuperclass;
                    if (!(pt2.getRawType() instanceof Class)) continue;
                    genericSuperclass = pt2.getRawType();
                    if (Object.class.equals((Object)genericSuperclass)) {
                        tipoEnCurso = null;
                        continue;
                    }
                    tempJerarquia.add(tipoEnCurso);
                    tipoEnCurso = pt2;
                    continue;
                }
                if (genericSuperclass != null && genericSuperclass instanceof Class) {
                    if (Object.class.equals((Object)genericSuperclass)) {
                        tipoEnCurso = null;
                        continue;
                    }
                    tempJerarquia.add(tipoEnCurso);
                    tipoEnCurso = (Class)genericSuperclass;
                    continue;
                }
                tipoEnCurso = null;
            }
            if (tipoEnCurso != null) {
                jerarquia = tempJerarquia;
            }
        }
        return jerarquia;
    }

    private Type getSuper(Type tipoEnCurso) {
        ParameterizedType pt;
        Class<?> genericSuperclass = null;
        if (tipoEnCurso instanceof Class) {
            if (((Class)tipoEnCurso).isInterface()) {
                Class<?>[] is = ((Class)tipoEnCurso).getInterfaces();
                if (is != null && is.length > 0) {
                    genericSuperclass = is[0];
                }
            } else {
                genericSuperclass = ((Class)tipoEnCurso).getGenericSuperclass();
            }
        } else if (tipoEnCurso instanceof ParameterizedType && (pt = (ParameterizedType)tipoEnCurso).getRawType() instanceof Class) {
            genericSuperclass = ((Class)pt.getRawType()).getGenericSuperclass();
        }
        return genericSuperclass;
    }

    private int getArgPos(Type asClassOrInterface, String genericArgumentName) {
        int argPos = 0;
        Type[] types = null;
        if (asClassOrInterface instanceof Class) {
            types = ((Class)asClassOrInterface).getTypeParameters();
        } else if (asClassOrInterface instanceof ParameterizedType) {
            types = ((ParameterizedType)asClassOrInterface).getActualTypeArguments();
        }
        int argPosAux = 0;
        if (types != null) {
            for (int pos = 0; pos < types.length; ++pos) {
                if (!(types[pos] instanceof TypeVariable)) continue;
                TypeVariable t = (TypeVariable)types[pos];
                if (t.getName().equals(genericArgumentName)) {
                    argPos = argPosAux;
                    break;
                }
                ++argPosAux;
            }
        }
        return argPos;
    }

    public <T> T fillQueryResult(List<FieldInterfaced> fields, Object[] o, T t) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        int pos = 0;
        for (FieldInterfaced f : fields) {
            if (pos >= o.length) break;
            if (o[pos] != null) {
                if (f instanceof FieldInterfacedFromField) {
                    f.getField().set(t, o[pos]);
                } else {
                    this.set(t, f, o[pos]);
                }
            }
            ++pos;
        }
        return t;
    }

    private void set(Object o, FieldInterfaced f, Object v) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method m = null;
        try {
            m = o.getClass().getMethod(this.getSetter(f), v.getClass());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (m == null) {
            m = this.getMethod(o.getClass(), this.getSetter(f));
        }
        if (m != null) {
            try {
                m.invoke(o, v);
            }
            catch (Exception e) {
                log.error("Exception when setting value " + v + " for field " + f.getName());
                throw e;
            }
        }
    }

    public List<FieldInterfaced> getKpiFields(Class modelType) {
        List<FieldInterfaced> allFields = this.getAllFields(modelType);
        allFields = allFields.stream().filter(f -> f.isAnnotationPresent(KPI.class)).collect(Collectors.toList());
        return allFields;
    }

    public List<FieldInterfaced> getAllTransferrableFields(Class modelType) {
        List<FieldInterfaced> allFields = this.getAllFields(modelType);
        allFields = this.filterAccesible(allFields);
        allFields = this.filterInjected(allFields);
        return allFields;
    }

    public List<FieldInterfaced> getAllEditableFields(Class modelType) {
        return this.getAllEditableFilteredFields(modelType, null, null);
    }

    public List<FieldInterfaced> getAllEditableFilteredFields(Class modelType, String fieldsFilter, List<FieldInterfaced> editableFields) {
        List<FieldInterfaced> l;
        List<FieldInterfaced> list = l = editableFields != null ? editableFields : this.getAllEditableFields(modelType, null, true);
        if (!Strings.isNullOrEmpty((String)fieldsFilter)) {
            ArrayList<FieldInterfaced> borrar = new ArrayList<FieldInterfaced>();
            List<String> ts = Arrays.asList(fieldsFilter.replaceAll(" ", "").split(","));
            for (FieldInterfaced f : l) {
                if (ts.contains(f.getName())) continue;
                borrar.add(f);
            }
            l.removeAll(borrar);
        }
        return l;
    }

    public List<FieldInterfaced> getAllEditableFields(Class modelType, Class superType, boolean includeReverseMappers) {
        return this.getAllEditableFields(modelType, superType, includeReverseMappers, null);
    }

    public List<FieldInterfaced> getAllEditableFields(Class modelType, Class superType, boolean includeReverseMappers, FieldInterfaced field) {
        List<FieldInterfaced> allFields = this.getAllFields(modelType);
        if (field != null && field.isAnnotationPresent(FieldsFilter.class)) {
            List<String> fns = Arrays.asList(field.getAnnotation(FieldsFilter.class).value().split(","));
            ArrayList<FieldInterfaced> borrar = new ArrayList<FieldInterfaced>();
            for (FieldInterfaced f2 : allFields) {
                if (fns.contains(f2.getName())) continue;
                borrar.add(f2);
            }
            allFields.removeAll(borrar);
        }
        allFields = this.filterAccesible(allFields);
        allFields = this.filterMenuFields(allFields);
        allFields = this.filterAuthorized(allFields);
        allFields = this.filterInjected(allFields);
        boolean isEditingNewRecord = false;
        allFields = allFields.stream().filter(f -> !(f.isAnnotationPresent(Version.class) || f.isAnnotationPresent(Ignored.class) || f.isAnnotationPresent(KPI.class) || f.isAnnotationPresent(NotInEditor.class) || f.isAnnotationPresent(Id.class) && f.isAnnotationPresent(GeneratedValue.class) || f.isAnnotationPresent(NotWhenCreating.class) && isEditingNewRecord || f.isAnnotationPresent(NotWhenEditing.class) && !isEditingNewRecord)).collect(Collectors.toList());
        if (superType != null && !includeReverseMappers) {
            List manytoones = allFields.stream().filter(f -> f.isAnnotationPresent(ManyToOne.class)).collect(Collectors.toList());
            block1: for (FieldInterfaced manytoonefield : manytoones) {
                if (!superType.equals(manytoonefield.getType())) continue;
                for (FieldInterfaced parentField : this.getAllFields(manytoonefield.getType())) {
                    String mb;
                    OneToMany aa = parentField.getAnnotation(OneToMany.class);
                    if (aa == null || Strings.isNullOrEmpty((String)(mb = parentField.getAnnotation(OneToMany.class).mappedBy()))) continue;
                    FieldInterfaced mbf = null;
                    for (FieldInterfaced f3 : allFields) {
                        if (!f3.getName().equals(mb)) continue;
                        mbf = f3;
                        break;
                    }
                    if (mbf == null) continue;
                    allFields.remove(mbf);
                    continue block1;
                }
            }
        }
        for (FieldInterfaced f4 : new ArrayList<FieldInterfaced>(allFields)) {
            if (!f4.isAnnotationPresent(Position.class)) continue;
            allFields.remove(f4);
            allFields.add(f4.getAnnotation(Position.class).value(), f4);
        }
        return allFields;
    }

    private List<FieldInterfaced> filterMenuFields(List<FieldInterfaced> allFields) {
        ArrayList<FieldInterfaced> r = new ArrayList<FieldInterfaced>();
        for (FieldInterfaced f : allFields) {
            if (f.isAnnotationPresent(MenuOption.class) || f.isAnnotationPresent(Submenu.class)) continue;
            r.add(f);
        }
        return r;
    }

    private List<FieldInterfaced> filterInjected(List<FieldInterfaced> allFields) {
        ArrayList<FieldInterfaced> r = new ArrayList<FieldInterfaced>();
        for (FieldInterfaced f : allFields) {
            if (f.isAnnotationPresent(Autowired.class) || Modifier.isFinal(f.getModifiers())) continue;
            r.add(f);
        }
        return r;
    }

    private List<FieldInterfaced> getAllInjectedFields(Class<?> type) {
        ArrayList<FieldInterfaced> r = new ArrayList<FieldInterfaced>();
        List<FieldInterfaced> allFields = this.getAllFields(type);
        for (FieldInterfaced f : allFields) {
            if (!f.isAnnotationPresent(Autowired.class) && !Modifier.isFinal(f.getModifiers())) continue;
            r.add(f);
        }
        return r;
    }

    private List<FieldInterfaced> filterAccesible(List<FieldInterfaced> allFields) {
        ArrayList<FieldInterfaced> r = new ArrayList<FieldInterfaced>();
        for (FieldInterfaced f : allFields) {
            if (!this.hasGetter(f)) continue;
            r.add(f);
        }
        return r;
    }

    private List<FieldInterfaced> filterAuthorized(List<FieldInterfaced> allFields) {
        ArrayList<FieldInterfaced> r = new ArrayList<FieldInterfaced>();
        for (FieldInterfaced f : allFields) {
            if (!this.check(f)) continue;
            r.add(f);
        }
        return r;
    }

    private boolean check(FieldInterfaced f) {
        Annotation a;
        boolean r = false;
        boolean annotated = false;
        if (f.isAnnotationPresent(ReadOnly.class)) {
            annotated = true;
            a = f.getAnnotation(ReadOnly.class);
            r |= this.check(a);
        }
        if (f.isAnnotationPresent(ReadWrite.class)) {
            annotated = true;
            a = f.getAnnotation(ReadWrite.class);
            r |= this.check(a);
        }
        if (f.isAnnotationPresent(Forbidden.class)) {
            annotated = true;
            a = f.getAnnotation(Forbidden.class);
            r &= !this.check(a);
        }
        return !annotated || r;
    }

    private boolean check(Annotation a) {
        return true;
    }

    private boolean check(Method m) {
        Annotation a;
        boolean r = false;
        boolean annotated = false;
        if (m.isAnnotationPresent(ReadOnly.class)) {
            annotated = true;
            a = m.getAnnotation(ReadOnly.class);
            r |= this.check(a);
        }
        if (m.isAnnotationPresent(ReadWrite.class)) {
            annotated = true;
            a = m.getAnnotation(ReadWrite.class);
            r |= this.check(a);
        }
        if (m.isAnnotationPresent(Forbidden.class)) {
            annotated = true;
            a = m.getAnnotation(Forbidden.class);
            r &= !this.check(a);
        }
        return !annotated || r;
    }

    private FieldInterfaced getInterfaced(final Parameter p) {
        return new FieldInterfaced(){

            @Override
            public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
                return p.isAnnotationPresent(annotationClass);
            }

            @Override
            public Class<?> getType() {
                return p.getType();
            }

            @Override
            public AnnotatedType getAnnotatedType() {
                return p.getAnnotatedType();
            }

            @Override
            public Class<?> getGenericClass() {
                if (p.getParameterizedType() instanceof ParameterizedType) {
                    ParameterizedType genericType = (ParameterizedType)p.getParameterizedType();
                    Class genericClass = (Class)genericType.getActualTypeArguments()[0];
                    return genericClass;
                }
                return null;
            }

            @Override
            public Class<?> getDeclaringClass() {
                return null;
            }

            @Override
            public Type getGenericType() {
                return p.getParameterizedType();
            }

            @Override
            public String getName() {
                return p.getName();
            }

            @Override
            public String getId() {
                return p.getName();
            }

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return p.getAnnotation(annotationClass);
            }

            @Override
            public Object getValue(Object o) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
                return null;
            }

            @Override
            public Field getField() {
                return null;
            }

            @Override
            public <T extends Annotation> T[] getDeclaredAnnotationsByType(Class<T> annotationClass) {
                return this.getDeclaredAnnotationsByType(annotationClass);
            }

            @Override
            public void setValue(Object o, Object v) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
            }

            @Override
            public int getModifiers() {
                return p.getModifiers();
            }

            @Override
            public Annotation[] getDeclaredAnnotations() {
                return p.getDeclaredAnnotations();
            }
        };
    }

    public String getCaption(Object o) {
        if (o.getClass().isAnnotationPresent(Caption.class)) {
            return this.translator.translate(o.getClass().getAnnotation(Caption.class).value());
        }
        if (o instanceof Listing) {
            return ((Listing)o).getCaption();
        }
        String caption = "";
        try {
            if (!o.getClass().getMethod("toString", new Class[0]).getDeclaringClass().equals(Object.class)) {
                caption = o.toString();
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        if (Strings.isNullOrEmpty((String)caption)) {
            caption = Helper.capitalize(o.getClass().getSimpleName());
        }
        return this.translator.translate(caption);
    }

    public String getCaption(FieldInterfaced f) {
        if (f.isAnnotationPresent(Caption.class)) {
            return this.translator.translate(f.getAnnotation(Caption.class).value());
        }
        String caption = "";
        if (f.isAnnotationPresent(Submenu.class)) {
            caption = f.getAnnotation(Submenu.class).value();
        }
        if (f.isAnnotationPresent(Action.class)) {
            f.getAnnotation(Action.class).value();
        }
        if (Strings.isNullOrEmpty((String)caption)) {
            caption = Helper.capitalize(f.getName());
        }
        return this.translator.translate(caption);
    }

    public String getCaption(Method f) {
        if (f.isAnnotationPresent(Caption.class)) {
            return this.translator.translate(f.getAnnotation(Caption.class).value());
        }
        String caption = "";
        if (f.isAnnotationPresent(Submenu.class)) {
            caption = f.getAnnotation(Submenu.class).value();
        }
        if (f.isAnnotationPresent(Action.class)) {
            caption = f.getAnnotation(Action.class).value();
        }
        if (Strings.isNullOrEmpty((String)caption)) {
            caption = Helper.capitalize(f.getName());
        }
        return this.translator.translate(caption);
    }

    public Collection addToCollection(FieldInterfaced field, Object bean) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Method m = this.getMethod(bean.getClass(), "create" + this.getFirstUpper(field.getName()) + "Instance");
        Object i = null;
        i = m != null ? m.invoke(bean, new Object[0]) : this.createChild(bean, field);
        return this.addToCollection(field, bean, i);
    }

    public Collection addToCollection(FieldInterfaced field, Object bean, Object i) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object v = this.getValue(field, bean);
        v = v != null ? this.extend((Collection)v, i) : (ImmutableList.class.isAssignableFrom(field.getType()) ? ImmutableList.of((Object)i) : (ImmutableSet.class.isAssignableFrom(field.getType()) ? ImmutableSet.of((Object)i) : (Set.class.isAssignableFrom(field.getType()) ? Set.of(i) : List.of(i))));
        this.setValue(field, bean, v);
        return (Collection)v;
    }

    private Object createChild(Object parent, FieldInterfaced collectionField) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Class<?> c = collectionField.getGenericClass();
        return this.newInstance(c, parent);
    }

    public void addToMap(FieldInterfaced field, Object bean, Object k, Object v) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Map<Object, Object> m = (Map<Object, Object>)this.getValue(field, bean);
        if (m == null) {
            if (ImmutableMap.class.isAssignableFrom(field.getType())) {
                v = ImmutableMap.of((Object)k, (Object)v);
            } else {
                m = Map.of(k, v);
            }
            this.setValue(field, bean, m);
        } else {
            this.setValue(field, bean, this.extend(m, k, v));
        }
    }

    public void removeFromMap(FieldInterfaced field, Object bean, Set l) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object v = this.getValue(field, bean);
        if (v != null) {
            l.forEach(e -> ((Map)v).remove(((MapEntry)e).getKey()));
        }
    }

    public Class<?> getGenericClass(Class type) {
        Class gc;
        block2: {
            Type[] typeArray;
            int n;
            int n2;
            gc = null;
            if (type.getGenericInterfaces() == null || (n2 = 0) >= (n = (typeArray = type.getGenericInterfaces()).length)) break block2;
            Type gi = typeArray[n2];
            if (gi instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)gi;
                gc = (Class)pt.getActualTypeArguments()[0];
            } else {
                gc = (Class)gi;
            }
        }
        return gc;
    }

    public Class<?> getGenericClass(Type type) {
        Class gc = null;
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            gc = (Class)pt.getActualTypeArguments()[0];
        } else {
            gc = (Class)type;
        }
        return gc;
    }

    public Set<Class> getSubclasses(Class c) {
        Object pkg = c.getPackage().getName();
        String[] ts = ((String)pkg).split("\\.");
        if (ts.length > 3) {
            pkg = ts[0] + "." + ts[1] + "." + ts[2];
        }
        Reflections reflections = new Reflections((String)pkg, new Scanner[0]);
        Set subs = reflections.getSubTypesOf(c);
        TreeSet<Class> subsFiltered = new TreeSet<Class>((a, b) -> a.getSimpleName().compareTo(b.getSimpleName()));
        subsFiltered.addAll(subs.stream().filter(s -> !Modifier.isAbstract(s.getModifiers())).collect(Collectors.toSet()));
        return subsFiltered;
    }

    public Class<?> getGenericClass(Method m) {
        Type gi = m.getGenericReturnType();
        Class gc = null;
        if (gi instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)gi;
            gc = (Class)pt.getActualTypeArguments()[0];
        } else {
            gc = (Class)gi;
        }
        return gc;
    }

    public boolean isOwner(FieldInterfaced field) {
        OneToOne oo = field.getAnnotation(OneToOne.class);
        OneToMany aa = field.getAnnotation(OneToMany.class);
        ManyToMany mm = field.getAnnotation(ManyToMany.class);
        boolean owner = false;
        if (oo != null) {
            owner = this.checkCascade(oo.cascade());
        } else if (aa != null) {
            owner = this.checkCascade(aa.cascade());
        } else if (mm != null) {
            owner = this.checkCascade(mm.cascade());
        }
        return owner;
    }

    private boolean checkCascade(CascadeType[] cascade) {
        boolean owned = false;
        for (CascadeType ct : cascade) {
            if (!CascadeType.ALL.equals((Object)ct) && !CascadeType.PERSIST.equals((Object)ct)) continue;
            owned = true;
            break;
        }
        return owned;
    }

    public boolean puedeBorrar(FieldInterfaced field) {
        if (field.isAnnotationPresent(ModifyValuesOnly.class)) {
            return false;
        }
        boolean puede = true;
        CascadeType[] cascades = null;
        if (field.isAnnotationPresent(OneToMany.class)) {
            cascades = field.getAnnotation(OneToMany.class).cascade();
        } else if (field.isAnnotationPresent(ManyToMany.class)) {
            cascades = field.getAnnotation(ManyToMany.class).cascade();
        }
        if (cascades != null) {
            puede = false;
            for (CascadeType ct : cascades) {
                if (!CascadeType.ALL.equals((Object)ct) && !CascadeType.REMOVE.equals((Object)ct)) continue;
                puede = true;
                break;
            }
        }
        return puede;
    }

    public boolean puedeAnadir(FieldInterfaced field) {
        if (field.isAnnotationPresent(ModifyValuesOnly.class)) {
            return false;
        }
        boolean puede = true;
        CascadeType[] cascades = null;
        if (field.isAnnotationPresent(OneToMany.class)) {
            cascades = field.getAnnotation(OneToMany.class).cascade();
        } else if (field.isAnnotationPresent(ManyToMany.class)) {
            cascades = field.getAnnotation(ManyToMany.class).cascade();
        }
        if (cascades != null) {
            puede = false;
            for (CascadeType ct : cascades) {
                if (!CascadeType.ALL.equals((Object)ct) && !CascadeType.PERSIST.equals((Object)ct)) continue;
                puede = true;
                break;
            }
        }
        return puede;
    }

    public void main(String[] args) throws Exception {
    }

    public String getFirstUpper(String fieldName) {
        return fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    public Object clone(Object original) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        if (original == null) {
            return null;
        }
        Method m = this.getMethod(original.getClass(), "cloneAsConverted");
        if (m != null) {
            return m.invoke(original, new Object[0]);
        }
        Object copy = null;
        Constructor con = this.getConstructor(original.getClass());
        if (con != null && con.getParameterCount() == 0) {
            copy = con.newInstance(new Object[0]);
        } else {
            con = Arrays.stream(original.getClass().getDeclaredConstructors()).filter(x -> x.getParameterCount() == 0).findFirst().orElse(null);
            if (!Modifier.isPublic(con.getModifiers())) {
                con.setAccessible(true);
            }
            copy = con.newInstance(new Object[0]);
        }
        for (FieldInterfaced f : this.getAllFields(original.getClass())) {
            if (f.isAnnotationPresent(Id.class)) continue;
            this.setValue(f, copy, this.getValue(f, original));
        }
        return copy;
    }

    public void delete(EntityManager em, Object o) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (o != null) {
            for (FieldInterfaced f : this.getAllFields(o.getClass())) {
                CascadeType[] c;
                Object t = this.getValue(f, o);
                if (t == null) continue;
                boolean owner = false;
                if (f.isAnnotationPresent(ManyToOne.class) && (c = f.getAnnotation(ManyToOne.class).cascade()) != null) {
                    for (CascadeType cx : c) {
                        if (!CascadeType.ALL.equals((Object)cx) && !CascadeType.REMOVE.equals((Object)cx)) continue;
                        owner = true;
                        break;
                    }
                }
                if (f.isAnnotationPresent(OneToMany.class) && (c = f.getAnnotation(OneToMany.class).cascade()) != null) {
                    for (CascadeType cx : c) {
                        if (!CascadeType.ALL.equals((Object)cx) && !CascadeType.REMOVE.equals((Object)cx)) continue;
                        owner = true;
                        break;
                    }
                }
                if (f.isAnnotationPresent(ManyToMany.class) && (c = f.getAnnotation(ManyToMany.class).cascade()) != null) {
                    for (CascadeType cx : c) {
                        if (!CascadeType.ALL.equals((Object)cx) && !CascadeType.REMOVE.equals((Object)cx)) continue;
                        owner = true;
                        break;
                    }
                }
                if (owner || !f.isAnnotationPresent(OneToMany.class) && !f.isAnnotationPresent(ManyToMany.class)) continue;
                FieldInterfaced mbf = this.getMapper(f);
                if (Collection.class.isAssignableFrom(t.getClass())) {
                    Collection col = (Collection)t;
                    t = col.size() > 0 ? col.iterator().next() : null;
                }
                if (mbf == null || t == null) continue;
                throw new Error(o + " is referenced from " + t);
            }
            em.remove(o);
        }
    }

    public void copy(Object from, Object to) {
        block11: {
            if (from == null || to == null) break block11;
            if (from.getClass().equals(to.getClass())) {
                for (FieldInterfaced f : this.getAllTransferrableFields(to.getClass())) {
                    try {
                        this.setValue(f, to, this.getValue(f, from));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                for (FieldInterfaced f : this.getAllInjectedFields(to.getClass())) {
                    try {
                        this.copy(this.getValue(f, from), this.getValue(f, to));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                for (FieldInterfaced f2 : this.getAllTransferrableFields(to.getClass())) {
                    try {
                        FieldInterfaced f1 = this.getFieldByName(from.getClass(), f2.getName());
                        if (f1 == null || !f1.getType().equals(f2.getType())) continue;
                        this.setValue(f2, to, this.getValue(f1, from));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public Object newInstance(Constructor c, Object params) throws Throwable {
        ArrayList<Object> vs = new ArrayList<Object>();
        for (Parameter p : c.getParameters()) {
            if (params != null && this.getFieldByName(params.getClass(), p.getName()) != null) {
                vs.add(this.getValue(this.getFieldByName(params.getClass(), p.getName()), params));
                continue;
            }
            Constable v = null;
            if (Integer.TYPE.equals(p.getType())) {
                v = 0;
            }
            if (Long.TYPE.equals(p.getType())) {
                v = 0L;
            }
            if (Float.TYPE.equals(p.getType())) {
                v = Float.valueOf(0.0f);
            }
            if (Double.TYPE.equals(p.getType())) {
                v = 0.0;
            }
            if (Boolean.TYPE.equals(p.getType())) {
                v = Boolean.valueOf(false);
            }
            vs.add(v);
        }
        Object[] args = vs.toArray();
        return c.newInstance(args);
    }

    public <T> T newInstance(Class<T> c) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object o = null;
        if (!this.notFromString.contains(c)) {
            o = this.beanProvider.getBean(c);
        }
        if (o == null) {
            if (c.getDeclaringClass() != null) {
                Object p = this.newInstance(c.getDeclaringClass());
                Constructor<?> cons = c.getDeclaredConstructors()[0];
                cons.setAccessible(true);
                o = cons.newInstance(p);
            } else {
                Constructor con = this.getConstructor(c);
                if (con != null) {
                    o = con.newInstance(new Object[0]);
                } else {
                    Method builderMethod = null;
                    try {
                        builderMethod = c.getMethod("builder", new Class[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (builderMethod != null) {
                        Object builder = c.getMethod("builder", new Class[0]).invoke(null, new Object[0]);
                        o = builder.getClass().getMethod("build", new Class[0]).invoke(builder, new Object[0]);
                    } else if (c.getDeclaredConstructors().length == 1) {
                        Constructor<?> constructor = c.getDeclaredConstructors()[0];
                        o = constructor.newInstance(this.newInstance(constructor.getParameterTypes()[0]));
                    }
                }
            }
            this.notFromString.add(c);
        }
        return (T)o;
    }

    public Object newInstance(Class c, Object parent) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        Object i = null;
        if (parent != null) {
            Constructor con = this.getConstructor(c, parent.getClass());
            if (con != null) {
                i = con.newInstance(parent);
            } else {
                con = Arrays.stream(c.getDeclaredConstructors()).filter(x -> x.getParameterCount() == 0).findFirst().orElse(null);
                if (!Modifier.isPublic(con.getModifiers())) {
                    con.setAccessible(true);
                }
                i = con.newInstance(new Object[0]);
                for (FieldInterfaced f : this.getAllFields(c)) {
                    if (!f.getType().equals(parent.getClass()) || !f.isAnnotationPresent(NotNull.class)) continue;
                    this.setValue(f, i, parent);
                    break;
                }
            }
        } else {
            Constructor con = this.getConstructor(c);
            if (con != null) {
                i = con.newInstance(new Object[0]);
            } else if (c.getMethod("builder", new Class[0]) != null) {
                Object builder = c.getMethod("builder", new Class[0]).invoke(null, new Object[0]);
                i = builder.getClass().getMethod("build", new Class[0]).invoke(builder, new Object[0]);
            }
        }
        return i;
    }

    public Constructor getConstructor(Class type) {
        Constructor<?> con = null;
        int minParams = Integer.MAX_VALUE;
        for (Constructor<?> x : type.getConstructors()) {
            if (!Modifier.isPublic(x.getModifiers()) || x.getParameterCount() >= minParams) continue;
            con = x;
            minParams = con.getParameterCount();
        }
        return con;
    }

    public Constructor getConstructor(Class c, Class parameterClass) {
        Constructor con = null;
        while (con == null && !Object.class.equals((Object)parameterClass)) {
            try {
                con = c.getConstructor(parameterClass);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (con != null) continue;
            parameterClass = parameterClass.getSuperclass();
        }
        return con;
    }

    public String toHtml(Object o) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.toHtml(pw, o, new ArrayList());
        return sw.toString();
    }

    public void toHtml(PrintWriter pw, Object o, List visited) {
        if (o != null) {
            if (!visited.contains(o)) {
                visited.add(o);
            }
            pw.println("<table>");
            for (FieldInterfaced f : this.getAllFields(o.getClass())) {
                try {
                    Object i = this.getValue(f, o);
                    pw.println("<tr><td style='text-align:right; font-style:italic;'>" + SlimHelper.capitalize(f.getName()) + ":</td><td>");
                    if (i != null) {
                        if (ReflectionHelper.isBasico(i)) {
                            pw.print("" + i);
                        } else {
                            this.toHtml(pw, i, visited);
                        }
                    }
                    pw.println("</td></tr>");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            pw.println("</table>");
        }
    }

    public String toJson(Object o) {
        if (o == null) {
            return null;
        }
        ObjectWriter ow = this.mapper.writer().withDefaultPrettyPrinter();
        try {
            String json = ow.writeValueAsString(o);
            return json;
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object fromJson(String json) {
        try {
            return this.mapper.reader().readValue(json);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public <T> Collection<T> extend(Collection<T> list, T o) {
        if (list == null) {
            return null;
        }
        if (list instanceof ImmutableList) {
            return this.extend((ImmutableList)list, o);
        }
        if (list instanceof ImmutableSet) {
            return this.extend((ImmutableSet)list, o);
        }
        if (Set.class.isAssignableFrom(list.getClass())) {
            return this.extend((Set)list, o);
        }
        return this.extend((List)list, o);
    }

    public <T> List<T> extend(List<T> list, T o) {
        ArrayList<T> l = new ArrayList<T>(list);
        l.add(o);
        return l;
    }

    public <T> ImmutableList<T> extend(ImmutableList<T> list, T o) {
        ArrayList<T> l = new ArrayList<T>(list);
        l.add(o);
        return ImmutableList.copyOf(l);
    }

    public <T> Set<T> extend(Set<T> list, T o) {
        HashSet<T> l = new HashSet<T>(list);
        l.add(o);
        return l;
    }

    public <T> ImmutableSet<T> extend(ImmutableSet<T> list, T o) {
        HashSet<T> l = new HashSet<T>(list);
        l.add(o);
        return ImmutableSet.copyOf(l);
    }

    public <K, V> Map<K, V> extend(Map<K, V> list, K k, V v) {
        HashMap<K, V> l = new HashMap<K, V>(list);
        l.put(k, v);
        return l;
    }

    public <K, V> ImmutableMap<K, V> extend(ImmutableMap<K, V> list, K k, V v) {
        HashMap<K, V> l = new HashMap<K, V>(list);
        l.put(k, v);
        return ImmutableMap.copyOf(l);
    }

    public <T> Collection<T> remove(Collection<T> list, T o) {
        if (list == null) {
            return null;
        }
        if (list instanceof ImmutableList) {
            return this.remove((ImmutableList)list, o);
        }
        if (list instanceof ImmutableSet) {
            return this.remove((ImmutableSet)list, o);
        }
        if (Set.class.isAssignableFrom(list.getClass())) {
            return this.remove((Set)list, o);
        }
        return this.remove((List)list, o);
    }

    public <T> List<T> remove(List<T> list, T o) {
        if (list == null) {
            return null;
        }
        ArrayList<T> l = new ArrayList<T>(list);
        l.remove(o);
        return l;
    }

    public <T> Set<T> remove(Set<T> list, T o) {
        if (list == null) {
            return null;
        }
        HashSet<T> l = new HashSet<T>(list);
        l.remove(o);
        return l;
    }

    public <T> ImmutableList<T> remove(ImmutableList<T> list, T o) {
        if (list == null) {
            return null;
        }
        ArrayList<T> l = new ArrayList<T>(list);
        l.remove(o);
        return ImmutableList.copyOf(l);
    }

    public <T> ImmutableSet<T> remove(ImmutableSet<T> list, T o) {
        if (list == null) {
            return null;
        }
        HashSet<T> l = new HashSet<T>(list);
        l.remove(o);
        return ImmutableSet.copyOf(l);
    }

    public <K, V> ImmutableMap<K, V> remove(ImmutableMap<K, V> list, K o) {
        if (list == null) {
            return null;
        }
        HashMap<K, V> l = new HashMap<K, V>(list);
        l.remove(o);
        return ImmutableMap.copyOf(l);
    }

    public <T> Collection<T> removeAll(Collection<T> list, Collection o) {
        if (list == null) {
            return null;
        }
        if (list instanceof ImmutableList) {
            return this.removeAll((ImmutableList)list, o);
        }
        if (list instanceof ImmutableSet) {
            return this.removeAll((ImmutableSet)list, o);
        }
        if (Set.class.isAssignableFrom(list.getClass())) {
            return this.removeAll((Set)list, o);
        }
        return this.removeAll((List)list, o);
    }

    public <T> List<T> removeAll(List<T> list, Collection o) {
        if (list == null) {
            return null;
        }
        ArrayList<T> l = new ArrayList<T>(list);
        l.removeAll(o);
        return l;
    }

    public <T> Set<T> removeAll(Set<T> list, Collection o) {
        if (list == null) {
            return null;
        }
        HashSet<T> l = new HashSet<T>(list);
        l.removeAll(o);
        return l;
    }

    public <T> ImmutableList<T> removeAll(ImmutableList<T> list, Collection o) {
        if (list == null) {
            return null;
        }
        ArrayList<T> l = new ArrayList<T>(list);
        l.removeAll(o);
        return ImmutableList.copyOf(l);
    }

    public <T> ImmutableSet<T> removeAll(ImmutableSet<T> list, Collection o) {
        if (list == null) {
            return null;
        }
        HashSet<T> l = new HashSet<T>(list);
        l.removeAll(o);
        return ImmutableSet.copyOf(l);
    }

    public boolean isOverridden(Object instance, String methodName) {
        Method m = this.getMethod(instance.getClass(), methodName);
        return m != null && !m.getDeclaringClass().equals(Object.class) && !m.getDeclaringClass().isInterface();
    }

    public Object invokeInjectableParametersOnly(Method method, Object instance) throws Throwable {
        return this.execute(method, new Object(), instance, null);
    }

    public Object execute(Method m, Object parameters, Object instance, Set pendingSelection) throws Throwable {
        Object o = parameters;
        Map<String, Object> params = null;
        if (o != null && Map.class.isAssignableFrom(o.getClass())) {
            params = (Map)o;
        } else if (o != null) {
            params = new HashMap();
            for (FieldInterfaced f : this.getAllEditableFields(o.getClass())) {
                params.put(f.getName(), this.getValue(f, o));
            }
        }
        ArrayList<Object> vs = new ArrayList<Object>();
        int pos = 0;
        for (Parameter p : m.getParameters()) {
            Class<?> pgc = this.getGenericClass(p.getParameterizedType());
            if ((instance instanceof Listing || Modifier.isStatic(m.getModifiers())) && Set.class.isAssignableFrom(p.getType()) && (m.getDeclaringClass().equals(pgc) || instance instanceof Listing && this.getGenericClass(instance.getClass(), Listing.class, "C").equals(pgc)) || pendingSelection != null && Set.class.isAssignableFrom(p.getType())) {
                vs.add(pendingSelection);
            } else if (params != null && params.containsKey(p.getName())) {
                vs.add(params.get(p.getName()));
            } else if (o != null && this.getFieldByName(o.getClass(), p.getName()) != null) {
                vs.add(this.getValue(this.getFieldByName(o.getClass(), p.getName()), o));
            } else {
                Constable v = null;
                if (Integer.TYPE.equals(p.getType())) {
                    v = 0;
                }
                if (Long.TYPE.equals(p.getType())) {
                    v = 0L;
                }
                if (Float.TYPE.equals(p.getType())) {
                    v = Float.valueOf(0.0f);
                }
                if (Double.TYPE.equals(p.getType())) {
                    v = 0.0;
                }
                if (Boolean.TYPE.equals(p.getType())) {
                    v = Boolean.valueOf(false);
                }
                vs.add(v);
            }
            ++pos;
        }
        Object[] args = vs.toArray();
        if (!Modifier.isStatic(m.getModifiers()) && instance == null) {
            instance = this.newInstance(m.getDeclaringClass());
        }
        if (instance != null && !Modifier.isPublic(instance.getClass().getModifiers())) {
            m.setAccessible(true);
        } else if (!Modifier.isPublic(m.getModifiers())) {
            m.setAccessible(true);
        }
        return m.invoke(instance, args);
    }
}

