/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.commands.startJourney;

import io.mateu.core.application.NotFoundException;
import io.mateu.core.domain.apiClients.MateuRemoteClient;
import io.mateu.core.domain.commands.startJourney.StartJourneyCommand;
import io.mateu.core.domain.model.modelToDtoMappers.JourneyMapper;
import io.mateu.core.domain.model.store.JourneyContainer;
import io.mateu.core.domain.model.store.JourneyStoreService;
import io.mateu.mdd.shared.interfaces.Listing;
import io.mateu.mdd.shared.interfaces.RemoteJourney;
import io.mateu.mdd.shared.interfaces.SortCriteria;
import io.mateu.remote.dtos.Journey;
import io.mateu.remote.dtos.Step;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class StartJourneyCommandHandler {
    private static final Logger log = LoggerFactory.getLogger(StartJourneyCommandHandler.class);
    @Autowired
    MateuRemoteClient mateuRemoteClient;
    @Autowired
    JourneyStoreService store;

    public Mono<Void> handle(StartJourneyCommand command) throws Throwable {
        String journeyId = command.getJourneyId();
        String journeyTypeId = command.getJourneyTypeId();
        ServerHttpRequest serverHttpRequest = command.getServerHttpRequest();
        Journey journey = null;
        Object formInstance = null;
        JourneyContainer journeyContainer = this.store.findJourneyById(journeyId).orElse(null);
        if (journeyContainer == null) {
            try {
                formInstance = this.store.createInstanceFromJourneyTypeId(journeyTypeId, serverHttpRequest);
                if (formInstance == null) {
                    throw new Exception();
                }
                journey = new JourneyMapper().map(formInstance);
                if (formInstance instanceof RemoteJourney) {
                    RemoteJourney remoteJourney = (RemoteJourney)formInstance;
                    this.store(journeyId, journeyTypeId, journey, remoteJourney.getBaseUrl(), remoteJourney.getJourneyTypeId());
                    return this.mateuRemoteClient.startJourney(remoteJourney.getBaseUrl(), remoteJourney.getJourneyTypeId(), journeyId, serverHttpRequest);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("error on getUi", (Throwable)e);
                throw new NotFoundException("No class with name " + journeyTypeId + " found");
            }
            Step step = this.store.getStepMapper().map(journeyContainer, this.getStepId(formInstance), null, formInstance, serverHttpRequest);
            journey.setCurrentStepId(step.getId());
            journey.setCurrentStepDefinitionId(step.getType());
            this.store(journeyId, journeyTypeId, journey, step);
        } else {
            journeyContainer.reset();
        }
        return Mono.empty();
    }

    private String getStepId(Object formInstance) {
        if (formInstance instanceof Listing) {
            return "list";
        }
        return "form";
    }

    private void store(String journeyId, String journeyTypeId, Journey journey, Step step) {
        JourneyContainer journeyContainer = JourneyContainer.builder().journeyId(journeyId).journeyTypeId(journeyTypeId).journey(journey).steps(Map.of(step.getId(), step)).initialStep(step).lastUsedFilters(new HashMap<String, Object>()).lastUsedSorting(new HashMap<String, List<SortCriteria>>()).build();
        this.store.save(journeyContainer);
    }

    private void store(String journeyId, String journeyTypeId, Journey journey, String remoteBaseUrl, String remoteJourneyTypeId) {
        JourneyContainer journeyContainer = JourneyContainer.builder().journeyId(journeyId).journeyTypeId(journeyTypeId).journey(journey).steps(Map.of()).initialStep(null).lastUsedFilters(new HashMap<String, Object>()).lastUsedSorting(new HashMap<String, List<SortCriteria>>()).remoteBaseUrl(remoteBaseUrl).remoteJourneyTypeId(remoteJourneyTypeId).build();
        this.store.save(journeyContainer);
    }
}

