/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.annotationProcessing;

import com.google.auto.service.AutoService;
import com.google.common.base.Strings;
import freemarker.template.TemplateException;
import io.mateu.mdd.annotationProcessing.Formatter;
import io.mateu.mdd.annotationProcessing.Helper;
import io.mateu.mdd.shared.annotations.Caption;
import io.mateu.mdd.shared.annotations.ExternalScripts;
import io.mateu.mdd.shared.annotations.KeycloakSecured;
import io.mateu.mdd.shared.annotations.MateuUI;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"io.mateu.mdd.shared.annotations.MateuUI"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@AutoService(value={Processor.class})
public class MateuUIAnnotationProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(typeElement);
            for (Element element : annotatedElements) {
                String className = ((TypeElement)element).getQualifiedName().toString();
                String simpleClassName = element.getSimpleName().toString();
                String path = element.getAnnotation(MateuUI.class).value();
                System.out.println("MateuUIAnnotationProcessor running on " + simpleClassName);
                String generatedFullClassName = className + "Controller";
                String pkgName = generatedFullClassName.substring(0, generatedFullClassName.lastIndexOf("."));
                String generatedClassName = generatedFullClassName.substring(generatedFullClassName.lastIndexOf(".") + 1);
                String caption = this.getCaption(element, simpleClassName);
                try {
                    this.createIndexController(generatedFullClassName, pkgName, className, simpleClassName, element, generatedClassName, caption, path);
                    this.createController(className + "MateuController", pkgName, className, simpleClassName, element, generatedClassName, caption, this.removeTrailingSlash(path));
                    this.createConfig(className + "Config", pkgName, className, simpleClassName, element, generatedClassName, caption, path);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return true;
    }

    private String removeTrailingSlash(String path) {
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    private String getCaption(Element e, String simpleClassName) {
        if (e.getAnnotation(Caption.class) != null) {
            return e.getAnnotation(Caption.class).value();
        }
        return Helper.capitalize(simpleClassName);
    }

    private void createIndexController(String generatedFullClassName, String pkgName, String className, String simpleClassName, Element e, String generatedClassName, String caption, String path) throws IOException {
        JavaFileObject builderFile = this.processingEnv.getFiler().createSourceFile(generatedFullClassName, new Element[0]);
        try (PrintWriter out = new PrintWriter(builderFile.openWriter());){
            String[] externalScripts = null;
            if (e.getAnnotation(ExternalScripts.class) != null) {
                externalScripts = e.getAnnotation(ExternalScripts.class).value();
            }
            if (externalScripts == null) {
                externalScripts = new String[]{};
            }
            String indexHtmlPath = "/index/index.html";
            Object frontendPath = path + "/dist/assets/mateu.js";
            if (e.getAnnotation(MateuUI.class) != null) {
                if (!Strings.isNullOrEmpty((String)e.getAnnotation(MateuUI.class).indexHtmlPath())) {
                    indexHtmlPath = e.getAnnotation(MateuUI.class).indexHtmlPath();
                }
                if (!(Strings.isNullOrEmpty((String)e.getAnnotation(MateuUI.class).frontendComponenPath()) || ((String)(frontendPath = e.getAnnotation(MateuUI.class).frontendComponenPath())).startsWith("http:") || ((String)frontendPath).startsWith("https:"))) {
                    frontendPath = path + (String)frontendPath;
                }
            }
            System.out.println("Using " + indexHtmlPath + " for index.html");
            System.out.println("Using " + (String)frontendPath + " for frontend component");
            HashMap<String, Object> model = new HashMap<String, Object>(Map.of("pkgName", pkgName, "className", className, "simpleClassName", simpleClassName, "generatedClassName", generatedClassName, "generatedFullClassName", generatedFullClassName, "caption", caption, "path", path, "externalScripts", externalScripts, "frontendPath", frontendPath, "indexHtmlPath", indexHtmlPath));
            KeycloakSecured keycloakAnnotation = e.getAnnotation(KeycloakSecured.class);
            if (keycloakAnnotation != null) {
                String keycloakUrl = keycloakAnnotation.url();
                String keycloakRealm = keycloakAnnotation.realm();
                String keycloakClientId = keycloakAnnotation.clientId();
                model.put("keycloak", Map.of("url", keycloakUrl, "realm", keycloakRealm, "clientId", keycloakClientId));
            }
            Formatter formatter = new Formatter("index.ftl", model);
            try {
                out.println(formatter.apply());
            }
            catch (TemplateException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void createConfig(String generatedFullClassName, String pkgName, String className, String simpleClassName, Element e, String generatedClassName, String caption, String path) throws IOException {
        JavaFileObject builderFile = this.processingEnv.getFiler().createSourceFile(generatedFullClassName, new Element[0]);
        try (PrintWriter out = new PrintWriter(builderFile.openWriter());){
            Formatter formatter = new Formatter("config.ftl", Map.of("pkgName", pkgName, "className", className, "simpleClassName", simpleClassName, "generatedClassName", generatedClassName, "generatedFullClassName", generatedFullClassName, "caption", caption, "path", path));
            try {
                out.println(formatter.apply());
            }
            catch (TemplateException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void createController(String generatedFullClassName, String pkgName, String className, String simpleClassName, Element e, String generatedClassName, String caption, String path) throws IOException {
        JavaFileObject builderFile = this.processingEnv.getFiler().createSourceFile(generatedFullClassName, new Element[0]);
        try (PrintWriter out = new PrintWriter(builderFile.openWriter());){
            Formatter formatter = new Formatter("controller.ftl", Map.of("pkgName", pkgName, "className", className, "simpleClassName", simpleClassName, "generatedClassName", generatedClassName, "generatedFullClassName", generatedFullClassName, "caption", caption, "path", path));
            try {
                out.println(formatter.apply());
            }
            catch (TemplateException ex) {
                ex.printStackTrace();
            }
        }
    }
}

