/*
 * Decompiled with CFR 0.152.
 */
package maryk.rocksdb.util;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import maryk.ByteBufferKt;
import maryk.rocksdb.util.BytewiseComparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rocksdb.AbstractComparator;
import org.rocksdb.ComparatorOptions;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0015\u0012\u000e\u0010\u0003\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\n\u0010\f\u001a\u00060\nj\u0002`\u000bH\u0016J \u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\nj\u0002`\u000b2\n\u0010\u0010\u001a\u00060\nj\u0002`\u000bH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lmaryk/rocksdb/util/ReverseBytewiseComparator;", "Lorg/rocksdb/AbstractComparator;", "Lmaryk/rocksdb/AbstractComparator;", "copt", "Lorg/rocksdb/ComparatorOptions;", "Lmaryk/rocksdb/ComparatorOptions;", "(Lorg/rocksdb/ComparatorOptions;)V", "compare", "", "a", "Ljava/nio/ByteBuffer;", "Lmaryk/ByteBuffer;", "b", "findShortestSeparator", "", "start", "limit", "name", "", "rocksdb-multiplatform"})
public final class ReverseBytewiseComparator
extends AbstractComparator {
    public ReverseBytewiseComparator(@Nullable ComparatorOptions copt) {
        super(copt);
    }

    @NotNull
    public String name() {
        return "rocksdb.java.ReverseBytewiseComparator";
    }

    public int compare(@NotNull ByteBuffer a, @NotNull ByteBuffer b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return -BytewiseComparator.Companion.compare(a, b);
    }

    public void findShortestSeparator(@NotNull ByteBuffer start, @NotNull ByteBuffer limit) {
        int limitByte;
        int startByte;
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)limit, (String)"limit");
        int minLength = Math.min(start.remaining(), limit.remaining());
        int diffIndex = 0;
        while (diffIndex < minLength && start.get(diffIndex) == limit.get(diffIndex)) {
            int n = diffIndex;
            diffIndex = n + 1;
        }
        if (!(diffIndex <= minLength)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (diffIndex != minLength && (startByte = start.get(diffIndex) & 0xFF) > (limitByte = limit.get(diffIndex) & 0xFF) && diffIndex < start.remaining() - 1) {
            start.limit(diffIndex + 1);
            if (!(BytewiseComparator.Companion.compare(ByteBufferKt.duplicateByteBuffer(start), ByteBufferKt.duplicateByteBuffer(limit)) > 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }
    }
}

